/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.Utils;

public class MbankTransactionManager
extends MPSTransactionManager {
    private static final String VALUE_JSON_PARAMETER_NAME = "value";
    private static final String INFORMATION_JSON_PARAMETER_NAME = "information";
    private static final String NAME_JSON_PARAMETER_NAME = "name";
    private static final String TRANSACTION_ID_JSON_PARAMETER_NAME = "provider_transaction_id";
    private static final String MESSAGE_JSON_PARAMETER_NAME = "message";
    private static final String ERROR_JSON_PARAMETER_NAME = "error_message";
    private static final String RU_JSON_PARAMETER_NAME = "ru";
    private static final String BALANCE_JSON_PARAMETER_NAME = "balance";
    private static final String FIO_JSON_PARAMETER_NAME = "fio";
    private static final String PARAM_PROVIDER_TRANSACTION_ID = "provider_transaction_id";
    private static final String PARAM_REQ_TIME = "req_time";
    private static final String PARAM_AMOUNT = "amount";
    private static final String PARAM_TRANSACTION_ID = "transaction_id";
    private static final String PARAM_MBANK_TRANSACTION_ID = "mbank_transaction_id";
    private static final String PARAM_MD5_DIGEST = "md5_digest";
    private static final String PARAM_CLIENT = "client";
    private static final String PARAM_ACTION = "action";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9);
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            mpsResponse.setAction(mpsRequest.getAction());
            switch (mpsRequest.getAction()) {
                case 1: {
                    this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    Contract contract = this.actionCheck(mpsRequest);
                    try (BalanceUtils bu = new BalanceUtils(con);){
                        if (system.extNeedClientInfo) {
                            mpsResponse.getParameters().put(BALANCE_JSON_PARAMETER_NAME, Utils.formatBigDecimalSumm((BigDecimal)bu.getBalanceOut(new Date(), contract.getId())));
                        }
                    }
                    String comment = this.getComment(system, conf, con, contract);
                    if (system.extNeedClientInfo && Utils.notBlankString((String)comment)) {
                        mpsResponse.getParameters().put(FIO_JSON_PARAMETER_NAME, comment);
                    }
                    mpsResponse.setResult(0);
                    mpsResponse.setMessage("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d - \u043e\u043f\u043b\u0430\u0442\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                    break;
                }
                case 2: {
                    this.getLogger().debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                    Contract contract = this.actionCheck(mpsRequest);
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getNumber(), mpsRequest.getType(), "");
                        mpsResponse.getParameters().put("provider_transaction_id", transaction.getId());
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                        break;
                    }
                    throw new MPSException(4);
                }
                case 3: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        throw new MPSException(5);
                    }
                    if (!transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) break;
                    mpsResponse.setResult(0);
                    mpsResponse.setMessage("\u041d\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0438. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                    break;
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1, e.getMessage()), mpsResponse);
            this.getLogger().error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage(), (Throwable)e);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        String providerTransactionId;
        MPSRequest result = new MPSRequest(con, moduleId, mpsId, request, system);
        this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        StringBuilder incomeJson = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line = null;
            while ((line = reader.readLine()) != null) {
                incomeJson.append(line);
            }
        }
        catch (IOException e1) {
            throw new MPSException(-1, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0447\u0438\u0442\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        JSONObject resultJsonObject = new JSONObject(incomeJson.toString());
        String action = resultJsonObject.has(PARAM_ACTION) ? resultJsonObject.get(PARAM_ACTION).toString() : null;
        String client = resultJsonObject.has(PARAM_CLIENT) ? resultJsonObject.get(PARAM_CLIENT).toString() : null;
        String md5 = resultJsonObject.has(PARAM_MD5_DIGEST) ? resultJsonObject.get(PARAM_MD5_DIGEST).toString() : null;
        String transactionId = resultJsonObject.has(PARAM_TRANSACTION_ID) ? resultJsonObject.get(PARAM_TRANSACTION_ID).toString() : null;
        String mbankTransactionId = resultJsonObject.has(PARAM_MBANK_TRANSACTION_ID) ? resultJsonObject.get(PARAM_MBANK_TRANSACTION_ID).toString() : null;
        String amount = resultJsonObject.has(PARAM_AMOUNT) ? resultJsonObject.get(PARAM_AMOUNT).toString() : null;
        String reqTime = resultJsonObject.has(PARAM_REQ_TIME) ? resultJsonObject.get(PARAM_REQ_TIME).toString() : null;
        String string = providerTransactionId = resultJsonObject.has("provider_transaction_id") ? resultJsonObject.get("provider_transaction_id").toString() : null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(String.format("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: action = %s, client = %s, md5_digest = %s, transactionId = %s, amount = %s, req_time = %s, provider_transaction_id = %s", action, client, md5, transactionId, amount, reqTime, providerTransactionId));
        }
        String str2Hash = null;
        switch (Utils.parseInt((String)action)) {
            case 1: {
                result.setAction(1);
                if (Utils.isBlankString((String)client)) {
                    throw new MPSException(21);
                }
                str2Hash = action + client;
                break;
            }
            case 2: {
                result.setAction(2);
                if (Utils.isBlankString((String)client) || Utils.isBlankString((String)amount) || Utils.isBlankString((String)reqTime)) {
                    throw new MPSException(21);
                }
                result.setSum(new BigDecimal(amount));
                try {
                    result.setTime(TIME_FORMAT.parse(reqTime));
                }
                catch (ParseException e) {
                    throw new MPSException(6);
                }
                result.setTransId(transactionId);
                str2Hash = action + transactionId + client + amount + reqTime;
                break;
            }
            case 3: {
                result.setAction(3);
                if (Utils.isBlankString((String)providerTransactionId) || Utils.isBlankString((String)mbankTransactionId) || Utils.isBlankString((String)reqTime)) {
                    throw new MPSException(21);
                }
                try {
                    result.setTime(TIME_FORMAT.parse(reqTime));
                }
                catch (ParseException e) {
                    throw new MPSException(6);
                }
                result.setTransId(mbankTransactionId);
                result.parameters.put("provider_transaction_id", providerTransactionId);
                str2Hash = action + mbankTransactionId + providerTransactionId;
                break;
            }
            default: {
                throw new MPSException(21);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            this.getLogger().debug("\u0421\u0442\u0440\u043e\u043a\u0430, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0444\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f hash: " + str2Hash + "<secret>");
        }
        str2Hash = str2Hash + system.secret;
        String hashValue = Utils.getDigest((String)str2Hash, (String)(Utils.isBlankString((String)system.requestEncoding) ? "UTF-8" : system.requestEncoding));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u043e\u0434\u043f\u0438\u0441\u044c, \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c: " + hashValue);
        }
        if (!hashValue.equalsIgnoreCase(md5)) {
            throw new MPSException(10);
        }
        result.setNumber(client);
        result.setRawNumber(client);
        result.parameters.put(PARAM_MD5_DIGEST, md5);
        return result;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 6: 
            case 21: {
                response.setResult(ErrorCode.ANSWER_MISSING_FIELDS.errCode);
                response.setMessage(ErrorCode.ANSWER_MISSING_FIELDS.errText);
                break;
            }
            case -1: {
                response.setResult(ErrorCode.ANSWER_TEMPORARY_TECHNICAL_ERROR.errCode);
                response.setMessage(ex.getMessage());
                break;
            }
            case 4: {
                response.setResult(ErrorCode.ANSWER_TRANSACTION_ALREARY_EXTST.errCode);
                response.setMessage(ErrorCode.ANSWER_TRANSACTION_ALREARY_EXTST.errText);
                break;
            }
            case 3: {
                response.setResult(ErrorCode.ANSWER_INCORRECT_CONTRACT.errCode);
                response.setMessage(ErrorCode.ANSWER_INCORRECT_CONTRACT.errText);
                break;
            }
            case 10: {
                response.setResult(ErrorCode.ANSWER_MD5_INCORRECT.errCode);
                response.setMessage(ErrorCode.ANSWER_MD5_INCORRECT.errText);
                break;
            }
            case 5: {
                response.setResult(ErrorCode.ANSWER_CONFIRM_ERROR.errCode);
                response.setMessage(ErrorCode.ANSWER_CONFIRM_ERROR.errText);
                break;
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        JSONObject answerObject = new JSONObject();
        answerObject.put("status", response.getResult());
        switch (response.getAction()) {
            case 1: {
                Object balanceObject;
                if (response.getResult() != ErrorCode.ANSWER_SUCCESS.errCode) {
                    JSONObject ruObject = new JSONObject();
                    ruObject.put(RU_JSON_PARAMETER_NAME, (Object)response.getMessage());
                    JSONArray errorObject = new JSONArray();
                    errorObject.put((Object)ruObject);
                    answerObject.put(ERROR_JSON_PARAMETER_NAME, (Object)errorObject);
                    break;
                }
                JSONArray informationObject = new JSONArray();
                Object fioObject = response.getParameters().get(FIO_JSON_PARAMETER_NAME);
                if (fioObject != null && Utils.notBlankString((String)fioObject.toString())) {
                    JSONObject ruObj = new JSONObject();
                    ruObj.put(RU_JSON_PARAMETER_NAME, (Object)"\u0424\u0418\u041e");
                    JSONObject itemObj = new JSONObject();
                    itemObj.put(NAME_JSON_PARAMETER_NAME, (Object)ruObj);
                    itemObj.put(VALUE_JSON_PARAMETER_NAME, (Object)fioObject.toString());
                    informationObject.put((Object)itemObj);
                }
                if ((balanceObject = response.getParameters().get(BALANCE_JSON_PARAMETER_NAME)) != null && Utils.notBlankString((String)balanceObject.toString())) {
                    JSONObject ruObj = new JSONObject();
                    ruObj.put(RU_JSON_PARAMETER_NAME, (Object)"\u0411\u0430\u043b\u0430\u043d\u0441");
                    JSONObject itemObj = new JSONObject();
                    itemObj.put(NAME_JSON_PARAMETER_NAME, (Object)ruObj);
                    itemObj.put(VALUE_JSON_PARAMETER_NAME, (Object)balanceObject.toString());
                    informationObject.put((Object)itemObj);
                }
                if (informationObject.length() <= 0) break;
                answerObject.put(INFORMATION_JSON_PARAMETER_NAME, (Object)informationObject);
                break;
            }
            case 2: {
                String providerTransactionId = response.getResult() == ErrorCode.ANSWER_SUCCESS.errCode ? response.getParameters().get("provider_transaction_id").toString() : "-1";
                answerObject.put(MESSAGE_JSON_PARAMETER_NAME, (Object)response.getMessage());
                answerObject.put("provider_transaction_id", (Object)providerTransactionId);
                break;
            }
            case 3: {
                answerObject.put(MESSAGE_JSON_PARAMETER_NAME, (Object)response.getMessage());
                break;
            }
        }
        byte[] result = null;
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0443: " + answerObject.toString());
            }
            result = answerObject.toString().getBytes(Utils.isBlankString((String)system.responseEncoding) ? "UTF-8" : system.responseEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            this.logError(ex);
        }
        return result;
    }

    private static enum ErrorCode {
        ANSWER_SUCCESS(0, "\u041d\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0438. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e"),
        ANSWER_NOT_ALL_PARAMS(10, "\u0423\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u0435 \u0432\u0441\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"),
        ANSWER_MD5_INCORRECT(20, "MD5-\u043e\u0442\u043f\u0435\u0447\u0430\u0442\u043e\u043a \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442"),
        ANSWER_ANOTHER_IP(30, "\u0417\u0430\u043f\u0440\u043e\u0441 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d \u0441 \u0434\u0440\u0443\u0433\u043e\u0433\u043e IP \u0430\u0434\u0440\u0435\u0441\u0430"),
        ANSWER_MISSING_FIELDS(40, "\u0423\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u0435 \u0432\u0441\u0435 \u043f\u043e\u043b\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438"),
        ANSWER_MISSING_REQUIRED_FIELDS(70, "\u0423\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u0435 \u0432\u0441\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043b\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438"),
        ANWER_INTERNAL_SOFTWARE_ERROR(80, "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u041f\u041e \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430"),
        ANSWER_INCORRECT_CONTRACT(90, "\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u043b\u0438\u0446\u0435\u0432\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430 (\u043b\u0438\u0431\u043e \u0434\u0440\u0443\u0433\u043e\u0439 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438)"),
        ANSWER_CONFIRM_ERROR(100, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0430."),
        ANSWER_TRANSACTION_ALREARY_EXTST(110, "\u041e\u0448\u0438\u0431\u043a\u0430. \u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0443\u0436\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u0430."),
        ANSWER_NOT_POST_ERROR(170, "\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u043d\u0435 POST \u0437\u0430\u043f\u0440\u043e\u0441"),
        ANSWER_TEMPORARY_TECHNICAL_ERROR(330, "\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u043d\u0430 \u0441\u0442\u043e\u0440\u043e\u043d\u0435 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430.");

        private int errCode;
        private String errText;

        private ErrorCode(int code, String title) {
            this.errCode = code;
            this.errText = title;
        }
    }
}

