/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractCreatedEvent;
import ru.bitel.bgbilling.modules.card.common.event.CardActivateRequestEvent;
import ru.bitel.bgbilling.modules.card.common.event.CardGetRequestEvent;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardDao;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class CardActivateWorker
extends EventWorker
implements Lifecycle {
    private final int moduleId;

    @ConstructorProperties(value={"setup"})
    public CardActivateWorker(EventProcessor ep, Setup setup, int moduleId) throws BGException {
        super(ep, CardActivateRequestEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        ep.addListener((EventListener)new EventListener<CardGetRequestEvent>(){

            public void notify(CardGetRequestEvent e, EventListenerContext ctx) throws BGException {
                int status = CardActivateWorker.this.find(e, ctx);
                e.setStatus(status);
            }
        }, CardGetRequestEvent.class, moduleId, null);
    }

    public void start() throws BGException {
        this.getLogger().info("Starting CardActivateWorker");
        new Thread((Runnable)((Object)this), "card-activate-worker").start();
    }

    public void stop() throws BGException {
        this.shutdown();
    }

    protected boolean runWorker() throws BGException {
        return this.doTasks();
    }

    public Object doTask(Object task) throws BGException {
        CardActivateRequestEvent e = (CardActivateRequestEvent)task;
        try {
            int status = this.activate(e);
            e.setStatus(status);
        }
        catch (Exception ex) {
            e.setStatus(100);
            if (ex instanceof BGException) {
                throw (BGException)((Object)ex);
            }
            throw new BGException((Throwable)ex);
        }
        return null;
    }

    private int find(CardGetRequestEvent e, EventListenerContext ctx) {
        CardDao cardManager = new CardDao(ctx.getConnection(), e.getModuleId());
        Card card = null;
        try {
            card = cardManager.findCard(e.getCardNumber());
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        if (card == null) {
            this.getLogger().debug("Card not found");
            return 1;
        }
        this.getLogger().debug("Card found, checking..");
        int status = this.checkCard(null, card);
        if (status != 0) {
            return status;
        }
        e.setCardId(card.getId());
        e.setActivateServiceId(card.getServiceActivateId());
        e.setPinCode(card.getCardPinCode());
        this.getLogger().debug("Card OK.");
        return 0;
    }

    private int activate(CardActivateRequestEvent e) throws BGException {
        Set serviceIds = e.getActivateServiceIds();
        if (serviceIds != null) {
            serviceIds = Collections.emptySet();
        }
        CardDao cardManager = new CardDao(((EventListenerContext)this.context).getConnection(), this.moduleId);
        Card card = null;
        try {
            card = cardManager.findCard(e.getCardNumber());
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        if (card == null) {
            this.getLogger().debug("Card not found");
            return 1;
        }
        this.getLogger().debug("Card found, checking..");
        int status = this.checkCard(e.getActivateServiceIds(), card);
        if (status != 0) {
            return status;
        }
        Connection con = ((EventListenerContext)this.context).getConnection();
        CardSeriesManager csm = new CardSeriesManager(con, this.moduleId);
        String cs = csm.getSeriesTitle(card.getSeriesId());
        HashMap<String, Object> titleParams = new HashMap<String, Object>(4);
        titleParams.put("card", card.getCardCode());
        titleParams.put("card_series", cs);
        try (ContractDao contractDao = new ContractDao(((EventListenerContext)this.context).getConnection(), 0);){
            HashMap<Object, Object> params = new HashMap<Object, Object>();
            String cardParamName = card.getClass().getName();
            params.put(cardParamName, card);
            params.put(cardParamName + ".series", cs);
            params.put("deviceId", e.getDeviceId());
            params.put("moduleId", e.getActivateModuleId());
            ContractCreateData data = ContractCreateData.builder().setPatternId(card.getPatternId()).setDateFrom(new Date()).setPassword(card.getCardPinCode()).setTitleParams(titleParams).build();
            Contract contract = contractDao.createFromPattern(data, params, true);
            card.setContractId(contract.getId());
            cardManager.addCardToContract((ServerContext)this.context, con, new GregorianCalendar(), card, contract.getId());
            cardManager.activated(card, 2);
            EventProcessor.getInstance().request((QueueEvent)new ContractCreatedEvent(contract));
            ((EventListenerContext)this.context).commit();
            ConvergenceBalanceManager.getInstance().updateBalance(((EventListenerContext)this.context).getConnectionSet(), contract.getId(), System.currentTimeMillis());
            ((EventListenerContext)this.context).commit();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return 0;
    }

    private int checkCard(Set<Integer> serviceIds, Card card) {
        if (!card.checkPeriod(new Date())) {
            this.getLogger().debug("Card expired");
            return 30;
        }
        if (card.getStatus() == 0) {
            this.getLogger().debug("Card lock");
            return 31;
        }
        if (card.getStatus() == 3) {
            this.getLogger().debug("Card activated for balance");
            return 32;
        }
        if (!(serviceIds == null || card.getServiceActivateId() != 0 && serviceIds.contains(card.getServiceActivateId()) || serviceIds.contains(0))) {
            this.getLogger().debug("Cant't activate card at this NAS");
            return 33;
        }
        if (card.getStatus() != 1) {
            this.getLogger().debug("Card status not active");
            return 30;
        }
        return 0;
    }
}

