/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree.voice;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.RangeParser;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class NPrefixTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("prefix_range");
    private JPanel yesNoPanel;
    private JPanel propsPanel;
    private JLabel view = new JLabel();
    private BGComboBox<IdTitle> destCombo;
    private BGComboBox<IdTitle> zoneCombo;
    private JTextField prefixPart_TF;
    private JTextField comment_TF;
    private Directory destDir;
    private Directory zoneDir;
    private String prefix;
    private String comment;
    private String destTitle;
    private String zoneTitle;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(icon);
        this.destDir = this.getDirManager().getDirectory("destinations");
        this.zoneDir = this.getDirManager().getDirectory("zones");
    }

    private void createPropsPanel() throws Exception {
        this.propsPanel = new JPanel();
        this.yesNoPanel = new JPanel();
        this.propsPanel.setLayout(new GridBagLayout());
        this.prefixPart_TF = new JTextField();
        this.comment_TF = new JTextField();
        this.prefixPart_TF.setPreferredSize(new Dimension(100, 24));
        this.prefixPart_TF.setMinimumSize(new Dimension(100, 24));
        this.comment_TF.setPreferredSize(new Dimension(100, 24));
        this.comment_TF.setMinimumSize(new Dimension(100, 24));
        this.propsPanel.add((Component)new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u043e\u0432:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.propsPanel.add((Component)this.prefixPart_TF, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.propsPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432\u0435\u0442\u043a\u0438:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.propsPanel.add((Component)this.comment_TF, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.destCombo = new BGComboBox();
        this.buildDirectoryCombo(this.destDir, this.destCombo);
        IdTitle di = new IdTitle();
        di.setId(0);
        di.setTitle("-- \u043d\u0435\u0442 --");
        this.destCombo.insertItemAt(di, 0);
        this.destCombo.setSelectedIndex(0);
        this.propsPanel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.propsPanel.add(this.destCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.propsPanel.add((Component)this.getDirectoryAddPanel(this.destDir, this.destCombo, true), new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        if (this.zoneDir != null) {
            this.zoneCombo = new BGComboBox();
            this.buildDirectoryCombo(this.zoneDir, this.zoneCombo);
            di = new IdTitle();
            di.setId(0);
            di.setTitle("-- \u043d\u0435\u0442 --");
            this.zoneCombo.insertItemAt(di, 0);
            this.zoneCombo.setSelectedIndex(0);
            this.propsPanel.add((Component)new JLabel("\u0417\u043e\u043d\u0430:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.propsPanel.add(this.zoneCombo, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.propsPanel.add((Component)this.getDirectoryAddPanel(this.zoneDir, this.zoneCombo, true), new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.yesNoPanel.setLayout(new GridBagLayout());
        JButton okButton = new JButton("\u041e\u041a");
        okButton.addActionListener(e -> this.okPressed());
        JButton canceButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        canceButton.addActionListener(e -> this.cancelPressed());
        this.yesNoPanel.add(Box.createHorizontalStrut(4), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.yesNoPanel.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.yesNoPanel.add((Component)canceButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.propsPanel.add((Component)this.yesNoPanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
    }

    @Override
    public Component getEditor() {
        return this.propsPanel;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    private void updateView() {
        try {
            StringBuffer str = new StringBuffer();
            this.extractData();
            str.append("<html>");
            str.append(this.prefix);
            str.append(" ");
            str.append(this.comment);
            if (Utils.notEmptyString(this.destTitle)) {
                str.append("<br>\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: ");
                str.append(this.destTitle);
            }
            if (Utils.notBlankString(this.zoneTitle)) {
                str.append("<br>\u0417\u043e\u043d\u0430: ");
                str.append(this.zoneTitle);
            }
            this.view.setText(str.toString());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    protected void loadData() throws Exception {
        String comment;
        Map<String, String> data;
        String prefix;
        if (this.propsPanel == null) {
            this.createPropsPanel();
        }
        if ((prefix = (data = this.getDataInHash()).get("prefix")) == null) {
            prefix = "";
        }
        if ((comment = data.get("comment")) == null) {
            comment = "";
        }
        this.setDirectoryItemSelection(this.destCombo, Utils.parseInt(data.get("dest"), 0));
        if (this.zoneDir != null) {
            this.setDirectoryItemSelection(this.zoneCombo, Utils.parseInt(data.get("zone"), 0));
        }
        this.prefixPart_TF.setText(prefix);
        this.comment_TF.setText(comment);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        IdTitle di = this.destCombo.getSelectedItem();
        if (di != null) {
            data.put("dest", String.valueOf(di.getId()));
        }
        if (this.zoneDir != null && (di = this.zoneCombo.getSelectedItem()) != null) {
            data.put("zone", String.valueOf(di.getId()));
        }
        data.put("prefix", this.prefixPart_TF.getText().trim());
        data.put("comment", this.comment_TF.getText().trim());
        this.setDataInHash(data);
    }

    public void extractData() throws Exception {
        Map<String, String> data = this.getDataInHash();
        String dest = data.get("dest");
        String zone = data.get("zone");
        if (dest == null) {
            dest = "0";
        }
        if (zone == null) {
            zone = "0";
        }
        this.zoneTitle = "";
        this.destTitle = "";
        if (this.destDir != null && !dest.equals("0")) {
            this.destTitle = this.destDir.getValue(Utils.parseInt(dest, 0));
        }
        if (this.zoneDir != null && !zone.equals("0")) {
            this.zoneTitle = this.zoneDir.getValue(Utils.parseInt(zone, 0));
        }
        this.prefix = data.get("prefix");
        if (this.prefix == null) {
            this.prefix = "";
        }
        this.comment = data.get("comment");
        if (this.comment == null) {
            this.comment = "";
        }
    }

    private void okPressed() {
        try {
            new RangeParser(this.prefixPart_TF.getText());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex.getLocalizedMessage());
            return;
        }
        this.serializeData();
        this.saveData();
        this.updateView();
        this.tree.updateTree();
        this.tree.getViewableTree().stopEditing();
    }

    private void cancelPressed() {
        try {
            this.loadData();
            this.tree.getViewableTree().stopEditing();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    protected JPanel getEditorPanel() {
        return new JPanel();
    }

    @Override
    public void serializeToXML(Element el) throws Exception {
        super.serializeToXML(el);
        this.extractData();
        el.setAttribute("prefix", this.prefix);
        if (Utils.notEmptyString(this.destTitle)) {
            el.setAttribute("dest", this.destTitle);
        }
        if (Utils.notEmptyString(this.zoneTitle)) {
            el.setAttribute("zone", this.zoneTitle);
        }
        el.setAttribute("comment", this.comment);
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) throws Exception {
        String zoneTitle;
        HashMap<String, String> data = new HashMap<String, String>(3);
        String destTitle = el.getAttribute("dest");
        if (destTitle.length() > 0) {
            int destCode = this.destDir.getCode(destTitle);
            if (destCode < 0) {
                destCode = this.destDir.addValue(destTitle);
            }
            data.put("dest", String.valueOf(destCode));
        }
        if (this.zoneDir != null && Utils.notBlankString(zoneTitle = el.getAttribute("zone"))) {
            int zoneCode = this.zoneDir.getCode(zoneTitle);
            if (zoneCode <= 0) {
                zoneCode = this.zoneDir.addValue(zoneTitle);
            }
            data.put("zone", String.valueOf(zoneCode));
        }
        data.put("prefix", el.getAttribute("prefix"));
        data.put("comment", el.getAttribute("comment"));
        this.setDataInHash(data);
        this.saveData();
        this.updateView();
        this.loadChildsFromXML(el);
    }
}

