/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client.upload;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.sorm.client.upload.AbonentsConfigurePanel;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Preferences;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class InnersStaffPanel
extends JPanel {
    private final AbonentsConfigurePanel parentPanel;
    private SormService sormService;
    private final IdTitle SEPARATOR = new IdTitle(-1, "--------------------");
    private final BGUComboBox<IdTitle> objFirstName = new BGUComboBox();
    private final BGUComboBox<IdTitle> objLastName = new BGUComboBox();
    private final BGUComboBox<IdTitle> objMiddleName = new BGUComboBox();
    private final BGUComboBox<IdTitle> objBirthday = new BGUComboBox();
    private final BGUComboBox<IdTitle> objDocumentType = new BGUComboBox();
    private final BGUComboBox<IdTitle> objDocumentSerial = new BGUComboBox();
    private final BGUComboBox<IdTitle> objDocumentNumber = new BGUComboBox();
    private final BGUComboBox<IdTitle> objDocumentWhoGive = new BGUComboBox();
    private final BGUComboBox<IdTitle> objDocumentWhenGive = new BGUComboBox();
    private final BGUComboBox<IdTitle> objAddressUnstruct = new BGUComboBox();
    private final BGUComboBox<IdTitle> objAddressStruct = new BGUComboBox();
    private final BGUComboBox<IdTitle> objPhoneNumber = new BGUComboBox();
    private final BGUComboBox<IdTitle>[] boxes = new BGUComboBox[]{this.objFirstName, this.objLastName, this.objMiddleName, this.objBirthday, this.objDocumentType, this.objDocumentSerial, this.objDocumentNumber, this.objDocumentWhoGive, this.objDocumentWhenGive, this.objAddressStruct, this.objAddressUnstruct, this.objPhoneNumber};
    private final BGUComboBox<IdTitle> objectTypes = new BGUComboBox();
    private final List<IdTitle> objectTypesList = new ArrayList<IdTitle>();
    private final List<IdTitle> objectParams = new ArrayList<IdTitle>();
    private final JCheckBox getFromSuper = new JCheckBox("\u0411\u0440\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u0438\u0437 \u0441\u0443\u043f\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?");

    protected InnersStaffPanel(AbonentsConfigurePanel parentPanel) {
        this.parentPanel = parentPanel;
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0421\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0438 \u044e\u0440.\u043b\u0438\u0446 \u0441 \u0434\u043e\u0441\u0442\u0443\u043f\u043e\u043c \u043a \u0441\u0435\u0442\u0438 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442");
        this.initObjectTypeComboBox();
        Font font = new Font("Arial", 0, 11);
        for (BGUComboBox<IdTitle> comboBox : this.boxes) {
            comboBox.setFont(font);
        }
        this.objectTypes.setFont(font);
        this.objectTypes.addItemListener(e -> {
            IdTitle selectedType = (IdTitle)this.objectTypes.getSelectedItem();
            if (e.getStateChange() == 1 && selectedType != null && selectedType.getId() > 0) {
                try {
                    this.setDataObjectParamsBoxes(selectedType.getId());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0);
        this.add((Component)BGSwingUtilites.createHelpLabel((String)"\u041f\u043e \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f\u043c\u0438 \u043a \u0421\u041e\u0420\u041c, \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u044b \u0441\u0432\u044f\u0437\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043e \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430\u0445 \u0441\u0432\u043e\u0438\u0445 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u0432-\u044e\u0440.\u043b\u0438\u0446, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0435\u0441\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0441\u0435\u0442\u0438 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442", (int)-1), constraints);
        constraints.fill = 2;
        this.add((Component)this.getFromSuper, constraints);
        this.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430"), constraints);
        this.add((Component)this.objectTypes, constraints);
        this.add((Component)new JLabel("\u0424\u0430\u043c\u0438\u043b\u0438\u044f \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430"), constraints);
        this.add((Component)this.objLastName, constraints);
        this.add((Component)new JLabel("\u0418\u043c\u044f \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430"), constraints);
        this.add((Component)this.objFirstName, constraints);
        this.add((Component)new JLabel("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430"), constraints);
        this.add((Component)this.objMiddleName, constraints);
        this.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f"), constraints);
        this.add((Component)this.objBirthday, constraints);
        this.add((Component)new JLabel("\u0422\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"), constraints);
        this.add((Component)this.objDocumentType, constraints);
        this.add((Component)new JLabel("\u0421\u0435\u0440\u0438\u044f"), constraints);
        this.add((Component)this.objDocumentSerial, constraints);
        this.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440"), constraints);
        this.add((Component)this.objDocumentNumber, constraints);
        this.add((Component)new JLabel("\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d"), constraints);
        this.add((Component)this.objDocumentWhoGive, constraints);
        this.add((Component)new JLabel("\u041a\u043e\u0433\u0434\u0430 \u0432\u044b\u0434\u0430\u043d"), constraints);
        this.add((Component)this.objDocumentWhenGive, constraints);
        this.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439"), constraints);
        this.add((Component)this.objAddressStruct, constraints);
        this.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u043d\u0435\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 "), constraints);
        this.add((Component)this.objAddressUnstruct, constraints);
        this.add((Component)new JLabel("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430"), constraints);
        this.add((Component)this.objPhoneNumber, constraints);
    }

    private void initObjectTypeComboBox() {
        try {
            this.objectTypesList.clear();
            this.objectTypesList.addAll(this.getSormService().listObjectType());
            ArrayList<IdTitle> types = new ArrayList<IdTitle>();
            types.add(this.SEPARATOR);
            types.addAll(this.objectTypesList);
            this.objectTypes.setData(types);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void setDataObjectParamsBoxes(int objectTypeId) throws Exception {
        this.objectParams.clear();
        this.objectParams.add(this.SEPARATOR);
        if (objectTypeId > 0) {
            this.objectParams.addAll(this.getSormService().listObjectParamsByObjectType(objectTypeId));
        }
        for (BGUComboBox<IdTitle> comboBox : this.boxes) {
            comboBox.setData(this.objectParams);
        }
    }

    protected void refresh(Preferences config) throws Exception {
        int selectedObjectTypeId = config.getInt("sorm.upload.staff.typeobject", -1);
        this.setDataObjectParamsBoxes(selectedObjectTypeId);
        this.objectTypes.setSelectedItem((Object)this.objectTypesList.stream().filter(type -> type.getId() == selectedObjectTypeId).findFirst().orElse(this.SEPARATOR));
        this.objLastName.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.lastname", -1)));
        this.objFirstName.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.firstname", -1)));
        this.objMiddleName.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.middlename", -1)));
        this.objBirthday.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.birthday", -1)));
        this.objDocumentType.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.documenttype", -1)));
        this.objDocumentSerial.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.documentserial", -1)));
        this.objDocumentNumber.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.documentnumber", -1)));
        this.objDocumentWhoGive.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.documentwhogive", -1)));
        this.objDocumentWhenGive.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.docemuntwhengive", -1)));
        this.objAddressUnstruct.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.addressunstruct", -1)));
        this.objAddressStruct.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.addressstruct", -1)));
        this.objPhoneNumber.setSelectedItem((Object)this.getObjectParamenetrFromConfig(config.getInt("sorm.upload.staff.phonenumber", -1)));
        this.getFromSuper.setSelected(config.getInt("sorm.upload.staff.getfromsuper", 0) == 1);
    }

    private IdTitle getObjectParamenetrFromConfig(int objParameterId) {
        if (objParameterId < 0) {
            return this.SEPARATOR;
        }
        return this.objectParams.stream().filter(param -> param.getId() == objParameterId).findFirst().orElse(this.SEPARATOR);
    }

    protected void buildConfig(Preferences config) {
        config.set("sorm.upload.staff.typeobject", String.valueOf(this.getSelectedIdOnCombobox(this.objectTypes)));
        config.set("sorm.upload.staff.lastname", String.valueOf(this.getSelectedIdOnCombobox(this.objLastName)));
        config.set("sorm.upload.staff.firstname", String.valueOf(this.getSelectedIdOnCombobox(this.objFirstName)));
        config.set("sorm.upload.staff.middlename", String.valueOf(this.getSelectedIdOnCombobox(this.objMiddleName)));
        config.set("sorm.upload.staff.birthday", String.valueOf(this.getSelectedIdOnCombobox(this.objBirthday)));
        config.set("sorm.upload.staff.documenttype", String.valueOf(this.getSelectedIdOnCombobox(this.objDocumentType)));
        config.set("sorm.upload.staff.documentserial", String.valueOf(this.getSelectedIdOnCombobox(this.objDocumentSerial)));
        config.set("sorm.upload.staff.documentnumber", String.valueOf(this.getSelectedIdOnCombobox(this.objDocumentNumber)));
        config.set("sorm.upload.staff.documentwhogive", String.valueOf(this.getSelectedIdOnCombobox(this.objDocumentWhoGive)));
        config.set("sorm.upload.staff.docemuntwhengive", String.valueOf(this.getSelectedIdOnCombobox(this.objDocumentWhenGive)));
        config.set("sorm.upload.staff.addressunstruct", String.valueOf(this.getSelectedIdOnCombobox(this.objAddressUnstruct)));
        config.set("sorm.upload.staff.addressstruct", String.valueOf(this.getSelectedIdOnCombobox(this.objAddressStruct)));
        config.set("sorm.upload.staff.phonenumber", String.valueOf(this.getSelectedIdOnCombobox(this.objPhoneNumber)));
        config.set("sorm.upload.staff.getfromsuper", this.getFromSuper.isSelected() ? "1" : "0");
    }

    private int getSelectedIdOnCombobox(BGUComboBox<IdTitle> comboBox) {
        if (comboBox == null || comboBox.getSelectedItem() == null) {
            return -1;
        }
        return ((IdTitle)comboBox.getSelectedItem()).getId();
    }

    private SormService getSormService() {
        if (this.sormService == null) {
            this.sormService = (SormService)this.parentPanel.getClientContext().getPort(SormService.class, this.parentPanel.getClientContext().getModuleId());
        }
        return this.sormService;
    }
}

