/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import bsh.BshClassManager;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.This;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.common.io.ThreadedPrintStream;

public class ScriptInstance {
    private static final Logger logger = LogManager.getLogger();
    private static ScriptValidator validator = null;
    private static This bshHelper = null;
    private Script script;
    protected Interpreter interpreter;
    protected This thiz;
    protected ThreadedPrintStream out;
    protected ThreadedPrintStream err;
    private int checkCount = 0;

    public static synchronized void validateScript(Script f) throws ValidationException {
        try {
            if (validator == null) {
                Interpreter i = new Interpreter();
                InputStream is = ScriptInstance.class.getResourceAsStream("/ru/bitel/bgbilling/kernel/script/server/bsh/bshHelper.bsh");
                i.eval((Reader)new InputStreamReader(is, "UTF-8"));
                validator = (ScriptValidator)i.getInterface(ScriptValidator.class);
            }
            validator.validateScript(new StringReader(f.getScript()));
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static synchronized This getBshHelper() throws EvalError {
        This result = bshHelper;
        if (result == null) {
            Interpreter it = new Interpreter();
            InputStream is = ScriptInstance.class.getResourceAsStream("/ru/bitel/bgbilling/kernel/script/server/bsh/bshHelper.bsh");
            it.eval((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
            bshHelper = result = it.getNameSpace().getGlobal(it);
        }
        return result;
    }

    public static synchronized boolean methodExist(Script f, String method) {
        try {
            return Boolean.TRUE.equals(ScriptInstance.getBshHelper().invokeMethod("methodExist", new Object[]{new StringReader(f.getScript()), method}));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static synchronized Set<String> methodNames(Script f) {
        try {
            return (Set)ScriptInstance.getBshHelper().invokeMethod("methodNames", new Object[]{new StringReader(f.getScript())});
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public ScriptInstance(Script script) {
        if (script == null) {
            throw new IllegalArgumentException();
        }
        this.script = script;
    }

    public Script getScript() {
        return this.script;
    }

    public String toString() {
        return this.script.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(PrintStream out, PrintStream err, Map<String, Object> vars) throws EvalError {
        Interpreter it = new Interpreter();
        it.getNameSpace().importCommands("/ru/bitel/bgbilling/kernel/script/server/bsh/commands");
        it.getNameSpace().importPackage("ru.bitel.bgbilling.server.util");
        this.out = new ThreadedPrintStream(System.out);
        this.err = new ThreadedPrintStream(System.err);
        try {
            this.out.startCapture(out);
            this.err.startCapture(err);
            out = this.out;
            err = this.err;
            it.setOut(out);
            it.setErr(err);
            logger.debug("Eval script " + this.toString());
            if (vars != null) {
                for (Map.Entry<String, Object> e : vars.entrySet()) {
                    it.set(e.getKey(), e.getValue());
                }
            }
            this.interpreter = it;
            this.thiz = it.getNameSpace().getGlobal(it);
            Object object = it.eval((Reader)new StringReader(this.script.getScript()), it.getNameSpace(), this.script.toString());
            return object;
        }
        finally {
            this.out.stopCapture();
            this.err.stopCapture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String method, Object[] args, PrintStream out, PrintStream err) throws EvalError {
        try {
            logger.info("Invoke method " + this.toString() + " : " + method);
            this.out.startCapture(out);
            this.err.startCapture(err);
            Object object = this.thiz.invokeMethod(method, args);
            return object;
        }
        finally {
            this.out.stopCapture();
            this.err.stopCapture();
        }
    }

    public Object invoke(String method, Object[] args) throws EvalError {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream outPrintStream = new PrintStream(out);
        PrintStream errPrintStream = new PrintStream(err);
        Object result = this.invoke(method, args, outPrintStream, errPrintStream);
        outPrintStream.flush();
        errPrintStream.flush();
        if (out.size() > 0) {
            logger.info(out.toString());
        }
        if (err.size() > 0) {
            logger.error(err.toString());
        }
        if (this.checkCount < 100) {
            ++this.checkCount;
            StringBuilder sb = new StringBuilder();
            DeprecatedCheker.checkOnDeprecated(this.interpreter, this, sb);
            if (sb.length() > 0) {
                logger.warn((CharSequence)sb);
            }
        }
        return result;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public void recycle() {
        this.interpreter = null;
        this.thiz = null;
        this.err = null;
        this.out = null;
        this.checkCount = 0;
    }

    public static interface ScriptValidator {
        public void validateScript(Reader var1) throws ValidationException;
    }

    public static class ValidationException
    extends Exception {
        private int beginLine;
        private int beginColumn;
        private int endLine;
        private int endColumn;

        public ValidationException() {
        }

        public ValidationException(String message, Throwable cause) {
            super(message, cause);
        }

        public ValidationException(String message) {
            super(message);
        }

        public int getBeginLine() {
            return this.beginLine;
        }

        public void setBeginLine(int beginLine) {
            this.beginLine = beginLine;
        }

        public int getBeginColumn() {
            return this.beginColumn;
        }

        public void setBeginColumn(int beginColumn) {
            this.beginColumn = beginColumn;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public void setEndLine(int endLine) {
            this.endLine = endLine;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        public void setEndColumn(int endColumn) {
            this.endColumn = endColumn;
        }
    }

    public static class DeprecatedCheker {
        private static final Field resolvedStaticMethodsField;
        private static final Field resolvedObjectMethodsField;

        private static void check(String name, Collection<?> col, StringBuilder sb) {
            for (Object o : new ArrayList(col)) {
                String warn;
                Method m = (Method)o;
                boolean classDeprecated = m.getDeclaringClass().getAnnotation(Deprecated.class) != null;
                if (!classDeprecated && m.getAnnotation(Deprecated.class) == null) continue;
                if (classDeprecated) {
                    warn = name + ": using deprecated class [" + m.getDeclaringClass().getName() + "]";
                    logger.warn(warn);
                    sb.append(warn).append("\n");
                    continue;
                }
                warn = name + ": using deprecated method [" + m.toString() + "]";
                logger.warn(warn);
                sb.append(warn).append("\n");
            }
        }

        public static void checkOnDeprecated(Interpreter it, ScriptInstance function, StringBuilder warnings) {
            DeprecatedCheker.checkOnDeprecated(it, function.toString(), warnings);
        }

        public static void checkOnDeprecated(Interpreter it, String name, StringBuilder warnings) {
            if (resolvedObjectMethodsField != null && resolvedStaticMethodsField != null) {
                BshClassManager classManager = it.getClassManager();
                try {
                    Hashtable resolvedStaticMethods = (Hashtable)resolvedStaticMethodsField.get(classManager);
                    Hashtable resolvedObjectMethods = (Hashtable)resolvedObjectMethodsField.get(classManager);
                    resolvedStaticMethods = (Hashtable)resolvedStaticMethods.clone();
                    resolvedObjectMethods = (Hashtable)resolvedObjectMethods.clone();
                    DeprecatedCheker.check(name, resolvedStaticMethods.values(), warnings);
                    DeprecatedCheker.check(name, resolvedObjectMethods.values(), warnings);
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }

        static {
            Field resolvedStaticMethods = null;
            Field resolvedObjectMethods = null;
            try {
                resolvedStaticMethods = BshClassManager.class.getDeclaredField("resolvedStaticMethods");
                resolvedStaticMethods.setAccessible(true);
                resolvedObjectMethods = BshClassManager.class.getDeclaredField("resolvedObjectMethods");
                resolvedObjectMethods.setAccessible(true);
                resolvedStaticMethods.getType().asSubclass(Hashtable.class);
                resolvedObjectMethods.getType().asSubclass(Hashtable.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            resolvedStaticMethodsField = resolvedStaticMethods;
            resolvedObjectMethodsField = resolvedObjectMethods;
        }
    }
}

