/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscriptionReal;

public class IpResourceSubscriptionRealDao
extends AbstractIdDao<IpResourceSubscriptionReal> {
    public IpResourceSubscriptionRealDao(Connection con, int mid) {
        super(con, mid, "inv_ip_resource_subscription_real");
    }

    protected IpResourceSubscriptionReal getFromRS(ResultSet rs) throws SQLException {
        return IpResourceSubscriptionReal.builder().setId(rs.getInt("id")).setAddressFrom(rs.getBytes("addressFrom")).setAddressTo(rs.getBytes("addressTo")).setDateFrom(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("dateFrom"))).setDateTo(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("dateTo"))).setSubscriberId(rs.getInt("subscriberId")).setSubscriberTitle(rs.getString("subscriberTitle")).build();
    }

    protected void updateImpl(IpResourceSubscriptionReal ipResourceSubscriptionReal) throws SQLException {
        String querySet = "addressFrom=?, addressTo=?, dateFrom=?, dateTo=?, subscriberId=?, subscriberTitle=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)ipResourceSubscriptionReal, querySet);){
            int paramIndex = 1;
            ps.setBytes(paramIndex++, ipResourceSubscriptionReal.getAddressFrom());
            ps.setBytes(paramIndex++, ipResourceSubscriptionReal.getAddressTo());
            ps.setDate(paramIndex++, TimeUtils.convertDateToSqlDate((Date)ipResourceSubscriptionReal.getDateFrom()));
            ps.setDate(paramIndex++, TimeUtils.convertDateToSqlDate((Date)ipResourceSubscriptionReal.getDateTo()));
            ps.setInt(paramIndex++, ipResourceSubscriptionReal.getSubscriberId());
            ps.setString(paramIndex++, ipResourceSubscriptionReal.getSubscriberTitle());
            this.executeUpdate((Id)ipResourceSubscriptionReal, paramIndex, ps);
        }
    }

    public IpResourceSubscriptionReal findFromDate(int subscriberId, byte[] addressFrom, byte[] addressTo, Date dateFrom) throws SQLException {
        if (addressTo == null) {
            addressTo = addressFrom;
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("SELECT *  FROM " + this.tableName + " as subscription  WHERE 1=1 AND (subscription.dateTo IS NULL OR subscription.dateTo>=?)");
        sb.append(" AND (subscription.addressFrom<=?) AND (subscription.addressTo>=?)");
        sb.append(" AND subscription.subscriberId = " + subscriberId);
        IpResourceSubscriptionReal result = null;
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)dateFrom));
            ps.setBytes(2, addressTo);
            ps.setBytes(3, addressFrom);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }
}

