/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.range;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.TariffOptionDeactivateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class RangeTreeNode<R extends AbstractTariffRequest<S>, W extends TariffWorkerContext, S extends ServiceCost>
extends TariffTreeNode<R, TariffContext, TreeContext, W> {
    public static final int TYPE_ABSOLUTELY = 1;
    public static final int TYPE_TARIFF = 2;
    public static final int TYPE_TARIFF_AND_STATUS = 3;
    public static final int TYPE_TARIFF_OPTION = 4;
    public static final int TYPE_TARIFF_OPTION_COUNT = 5;
    protected int periodMode;
    protected int proportionType;
    protected Integer tariffOptionId;
    protected long maxAmount;
    protected boolean tariffOptionDeactivate;
    protected int labelId;

    public RangeTreeNode(int id, ParameterMap params) {
        super(id, params);
        int amountType = params.getInt("type", -1);
        long amount = params.getLong("amount", -1L);
        this.maxAmount = amountType >= 0 && amount >= 0L ? this.getServiceAmount(amountType, amount) : amount;
        this.periodMode = params.getInt("mode", 0);
        this.proportionType = params.getInt("modeType", 0);
        this.tariffOptionId = params.getInt("tariffOptionId", 0);
        this.tariffOptionDeactivate = params.getInt("tariffOptionDeactivate", 0) > 0;
        this.labelId = params.getInt("labelId", 0);
    }

    public int getPeriodMode() {
        return this.periodMode;
    }

    public int getProportionType() {
        return this.proportionType;
    }

    public Integer getTariffOptionId() {
        return this.tariffOptionId;
    }

    public long getMaxAmount() {
        return this.maxAmount;
    }

    public boolean isTariffOptionDeactivate() {
        return this.tariffOptionDeactivate;
    }

    public int getLabelId() {
        return this.labelId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(Long treeNodeId, Long parentTreeNodeId, R req, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, W workerContext) {
        Object cost = ((AbstractTariffRequest)req).serviceCost;
        this.getLogger().debug("RangeTreeNode: labelId={}; maxAmount={}; cost={}", new Object[]{this.labelId, this.maxAmount, cost});
        if (cost == null) {
            this.getLogger().debug("RangeTreeNode: cost == null");
            return 0;
        }
        if (((ServiceCost)cost).amountNull) {
            this.getLogger().debug("RangeTreeNode: cost.amountNull == true");
            return 0;
        }
        int result = 0;
        try {
            ContractTariffOptionList.OptionItem contractTariffOption;
            this.getLogger().debug("RangeTreeNode: periodMode={}", (Object)this.periodMode);
            if (this.periodMode == 5) {
                ContractTariffOptionList.OptionItem contractOption;
                Map<Integer, ContractTariffOptionList.OptionItem> options = ((AbstractTariffRequest)req).getTariffOptionMap();
                if (options == null || (contractOption = options.get(this.tariffOptionId)) == null) return 0;
                contractTariffOption = contractOption;
            } else {
                contractTariffOption = null;
            }
            this.getLogger().debug("RangeTreeNode: contractTariffOption={}", contractTariffOption);
            result = this.processRange(treeNodeId, req, holder, ctx, treeContext, workerContext, contractTariffOption);
            return this.postExecute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, result);
        }
        catch (BGException ex) {
            this.logError(ex);
        }
        return this.postExecute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext, result);
    }

    private int processRange(Long treeNodeId, R req, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, W workerContext, ContractTariffOptionList.OptionItem contractTariffOption) throws BGException {
        int result;
        long delta;
        Object cost = ((AbstractTariffRequest)req).serviceCost;
        long amount = ((ServiceCost)cost).getAmount();
        int contractTariffOptionId = contractTariffOption != null ? contractTariffOption.contractOptionId : 0;
        this.getLogger().debug("RangeTreeNode:processRange contractTariffOptionId={}; amount={}; cost={}", new Object[]{contractTariffOptionId, amount, cost});
        if (this.maxAmount != 0L) {
            long periodMillisTo;
            long periodMillisFrom;
            if (this.proportionType == 1) {
                periodMillisFrom = ((AbstractTariffRequest)req).accountingPeriodMillisFrom;
                periodMillisTo = ((AbstractTariffRequest)req).accountingPeriodMillisTo;
            } else {
                switch (this.periodMode) {
                    case 2: 
                    case 12: {
                        Calendar time = (Calendar)((AbstractTariffRequest)req).getTime().clone();
                        TimeUtils.clear_HOUR_MIN_MIL_SEC(time);
                        time.set(5, 1);
                        periodMillisFrom = time.getTimeInMillis();
                        time.add(2, 1);
                        time.add(14, -1);
                        periodMillisTo = time.getTimeInMillis();
                        break;
                    }
                    case 3: 
                    case 13: {
                        Calendar time = (Calendar)((AbstractTariffRequest)req).getTime().clone();
                        TimeUtils.clear_HOUR_MIN_MIL_SEC(time);
                        periodMillisFrom = time.getTimeInMillis();
                        time.add(5, 1);
                        time.add(14, -1);
                        periodMillisTo = time.getTimeInMillis();
                        break;
                    }
                    case 4: 
                    case 14: {
                        Calendar time = (Calendar)((AbstractTariffRequest)req).getTime().clone();
                        TimeUtils.clear_MIN_MIL_SEC(time);
                        periodMillisFrom = time.getTimeInMillis();
                        time.add(11, 1);
                        time.add(14, -1);
                        periodMillisTo = time.getTimeInMillis();
                        break;
                    }
                    case 5: 
                    case 15: {
                        periodMillisFrom = contractTariffOption.timeFrom;
                        periodMillisTo = contractTariffOption.timeTo;
                        break;
                    }
                    default: {
                        periodMillisFrom = ((AbstractTariffRequest)req).accountingPeriodMillisFrom;
                        periodMillisTo = ((AbstractTariffRequest)req).accountingPeriodMillisTo;
                    }
                }
            }
            long maxAmount = this.calculateProportion(req, contractTariffOption, periodMillisFrom, periodMillisTo);
            long takedAmount = this.addRangedTraffic(ctx, workerContext, req, contractTariffOptionId, treeNodeId, maxAmount, amount);
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("maxAmount = {}; takedAmount = {}", (Object)maxAmount, (Object)takedAmount);
            }
            this.getLogger().debug("RangeTreeNode:processRange takedAmount={}; amount={}; maxAmount={}", new Object[]{takedAmount, amount, maxAmount});
            if (takedAmount > 0L) {
                delta = amount - takedAmount;
                amount = takedAmount;
                this.getLogger().debug("RangeTreeNode:processRange delta={}; amount={}", (Object)delta, (Object)amount);
                result = 1;
            } else if (takedAmount == 0L) {
                assert (amount == 0L);
                delta = 0L;
                result = 1;
            } else if (takedAmount == -1L) {
                delta = 0L;
                result = 0;
            } else {
                ++takedAmount;
                if (amount >= 0L) {
                    delta = amount;
                    amount = takedAmount;
                } else {
                    delta = 0L;
                    amount = takedAmount;
                }
                result = 1;
            }
        } else {
            delta = 0L;
            result = 1;
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("delta = {}; result = {}; result == RESULT_OK = {}", new Object[]{delta, result, result == 1});
        }
        if (result == 1) {
            int serviceId = ((ServiceCost)cost).getServiceId();
            ((ServiceCost)cost).setAmount(amount);
            this.executeChildren(treeNodeId, (AbstractTariffRequest<?>)req, holder, ctx, treeContext, workerContext);
            this.getLogger().debug("RangeTreeNode:processRange serviceId={}; delta={}; cost={}", new Object[]{serviceId, delta, cost});
            ServiceCost newCost = ((ServiceCost)cost).newCost();
            newCost.setServiceId(serviceId);
            newCost.setAmount(delta);
            newCost.setCost(BigDecimal.ZERO);
            if (delta == 0L) {
                newCost.amountNull = true;
            }
            ((AbstractTariffRequest)req).addServiceCost((ServiceCost)newCost);
            ((AbstractTariffRequest)req).serviceCost = newCost;
        } else if (this.tariffOptionDeactivate && contractTariffOptionId > 0 && ctx.realtime) {
            assert (this.periodMode == 5);
            this.getLogger().info("Sending event to deactivate option {} for contract {}", (Object)contractTariffOptionId, (Object)((AbstractTariffRequest)req).contractId);
            ((ServerContext)workerContext).publishAfterCommit(new TariffOptionDeactivateEvent(((AbstractTariffRequest)req).contractId, 0, contractTariffOptionId));
        }
        return result;
    }

    private long calculateProportion(R req, ContractTariffOptionList.OptionItem contractTariffOption, long periodMillisFrom, long periodMillisTo) {
        return switch (this.proportionType) {
            case 2 -> {
                float part = ((AbstractTariffRequest)req).getTariffTreeSetEntry().getPartOnPeriod(periodMillisFrom, periodMillisTo);
                if ((double)part < 0.0 || (double)part > 1.0) {
                    this.getLogger().error("Part t " + part);
                }
                yield (long)((float)this.maxAmount * part);
            }
            case 3 -> {
                float part = ((AbstractTariffRequest)req).getTariffTreeSetEntry().getPartOnPeriod(periodMillisFrom, periodMillisTo, ((AbstractTariffRequest)req).suspendedPeriodList);
                if ((double)part < 0.0 || (double)part > 1.0) {
                    this.getLogger().error("Part t&s " + part);
                }
                yield (long)((float)this.maxAmount * part);
            }
            case 4 -> {
                float part = TimeUtils.getPart(contractTariffOption.timeFrom, contractTariffOption.timeTo, periodMillisFrom, periodMillisTo);
                if ((double)part < 0.0 || (double)part > 1.0) {
                    this.getLogger().error("Part o " + part);
                }
                yield (long)((float)this.maxAmount * part);
            }
            case 5 -> {
                ((AbstractTariffRequest)req).getContractTariffOptions().count(contractTariffOption.id, periodMillisFrom, periodMillisTo);
                float part = TimeUtils.getPart(contractTariffOption.timeFrom, contractTariffOption.timeTo, periodMillisFrom, periodMillisTo);
                if ((double)part < 0.0 || (double)part > 1.0) {
                    this.getLogger().error("Part o " + part);
                }
                yield (long)((float)this.maxAmount * part);
            }
            default -> this.maxAmount;
        };
    }

    protected long addRangedTraffic(TariffContext ctx, W workerContext, R req, int contractTariffOptionId, long treeNodeId, long maxAmount, long amount) throws BGException {
        return ctx.rangedTrafficManager.addRangedTraffic((TariffWorkerContext)workerContext, ((AbstractTariffRequest)req).contractId, ((AbstractTariffRequest)req).accountingPeriodId, contractTariffOptionId, treeNodeId, this.periodMode, 0, ((AbstractTariffRequest)req).getTime(), maxAmount, amount, ctx.rangedTrafficManager, null, null);
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, R req, TariffContext context, TreeContext treeContext, W workerContext) {
        throw new UnsupportedOperationException();
    }
}

