/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class UserManager
extends AbstractIdDao<User> {
    public UserManager(Connection con) {
        super(Objects.requireNonNull(con, "'con' must be not null"), 0, "user");
    }

    protected void updateImpl(User user) throws SQLException {
        Objects.requireNonNull(user);
        boolean update = user.getId() > 0 || user.getId() == -1;
        String querySet = " SET login=?, name=?, email=?, descr=?, pswd=?, status=?, contract_pid=?, contract_cid=?, config=?, menu_id=?, role_id=?";
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + querySet + (update ? " WHERE id=?" : ", dt=now()");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            Object config = Utils.maskNull((String)user.getConfig());
            config = ((String)config).replace("need.change.password=true", "").replace("need.change.password=false", "");
            config = ((String)config).replace("disable.save.password=true", "").replace("disable.save.password=false", "");
            if (user.isNeedChangePassword()) {
                config = (String)config + "\nneed.change.password=true";
            }
            if (user.isDisableSavePassword()) {
                config = (String)config + "\ndisable.save.password=true";
            }
            user.setConfig(((String)config).replaceAll("\\n{2,}", "\n"));
            int index = 1;
            ps.setString(index++, user.getLogin());
            ps.setString(index++, user.getName());
            ps.setString(index++, user.getEmail());
            ps.setString(index++, user.getDescription());
            ps.setString(index++, user.getPassword());
            ps.setInt(index++, user.getStatus());
            ps.setInt(index++, user.getContractPid());
            ps.setInt(index++, user.getContractCid());
            ps.setString(index++, user.getConfig());
            ps.setInt(index++, user.getMenuId());
            ps.setInt(index++, user.getRoleId());
            this.executeUpdate((Id)user, index, ps);
        }
    }

    protected User getFromRS(ResultSet rs) throws SQLException {
        User user = new User();
        user.setId(rs.getInt("id"));
        user.setLogin(rs.getString("login"));
        user.setName(rs.getString("name"));
        user.setEmail(rs.getString("email"));
        user.setDescription(rs.getString("descr"));
        user.setPassword(rs.getString("pswd"));
        user.setStatus(rs.getInt("status"));
        user.setDate(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("dt")));
        user.setContractPid(rs.getInt("contract_pid"));
        user.setContractCid(rs.getInt("contract_cid"));
        user.setTitle(user.getLogin() + " [ " + user.getName() + " ]");
        user.setConfig(rs.getString("config"));
        user.setNeedChangePassword(user.getConfig().contains("need.change.password=true"));
        user.setDisableSavePassword(user.getConfig().contains("disable.save.password=true"));
        user.setMenuId(rs.getInt("menu_id"));
        user.setRoleId(rs.getInt("role_id"));
        return user;
    }

    public Map<Integer, User> getUsersMap() throws SQLException {
        HashMap<Integer, User> result = new HashMap<Integer, User>();
        String query = "SELECT * FROM " + this.tableName;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    User user = this.getFromRS(rs);
                    result.put(user.getId(), user);
                }
            }
            User user = new User();
            user.setName("\u0421\u0435\u0440\u0432\u0435\u0440");
            user.setTitle("\u0421\u0435\u0440\u0432\u0435\u0440");
            user.setId(0);
            result.put(user.getId(), user);
            user = new User();
            user.setName("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
            user.setTitle("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
            user.setId(-1);
            result.put(user.getId(), user);
        }
        return result;
    }

    public void findSearchResult(SearchResult<User> searchResult) throws BGException, BGMessageException {
        int roleId;
        if (searchResult == null) {
            return;
        }
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        String filterField = searchResult.optAttribute("field").orElse("none");
        if (Stream.of("login", "name", "email", "descr").filter(filterField::equals).count() == 0L) {
            filterField = null;
        }
        String filterStatus = searchResult.getAttribute("status");
        String groupId = searchResult.getAttribute("groupId");
        StringBuilder query = new StringBuilder();
        query.append("SELECT SQL_CALC_FOUND_ROWS user.*, title FROM " + this.tableName + " LEFT JOIN contract ON contract.id = user.contract_cid WHERE true" + (String)(filterField != null ? " AND " + filterField + " LIKE ?" : ""));
        if (filterStatus != null && !filterStatus.equals("-1")) {
            query.append(" AND user.status=?");
        }
        if (!groupId.equals("-1")) {
            query.append(" AND user.id IN (SELECT uid FROM bgs_user_group WHERE gid=?)");
        }
        if ((roleId = Utils.parseInt((String)searchResult.getAttribute("roleId"))) > 0) {
            query.append(" AND role_id=?");
        }
        query.append(" ORDER BY name");
        query.append(this.sqlLimit(page));
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            int index = 1;
            if (filterField != null) {
                ps.setString(index++, "%" + searchResult.optAttribute("value").orElse("") + "%");
            }
            if (filterStatus != null && !filterStatus.equals("-1")) {
                ps.setInt(index++, Integer.valueOf(filterStatus));
            }
            if (!groupId.equals("-1")) {
                ps.setInt(index++, Integer.valueOf(groupId));
            }
            if (roleId > 0) {
                ps.setInt(index++, roleId);
            }
            try (ResultSet resultSet = ps.executeQuery();){
                while (resultSet.next()) {
                    list.add(this.getFromRS(resultSet));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
        }
        catch (Exception ex) {
            throw new BGMessageException(ex.getMessage());
        }
    }

    public boolean checkLogin(String login, int userID) throws SQLException {
        boolean result = false;
        String query = "SELECT COUNT(*) FROM " + this.tableName + " WHERE login=? AND id<>?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, login);
            ps.setInt(index++, userID);
            try (ResultSet rs = ps.executeQuery();){
                result = rs.next() && rs.getInt(1) > 0;
            }
        }
        return result;
    }

    public List<User> list() throws SQLException {
        return this.list("", "name", new Object[0]);
    }

    public User getUserByLogin(String login) throws SQLException {
        return (User)((Object)this.get("login=?", new Object[]{login}));
    }
}

