/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class MegogoSubscriptionDao
extends AbstractIdDao<MegogoSubscription> {
    public static final String MEGOGO_SUBSCRIPTION_TABLE_NAME = "megogo_subscription";

    public MegogoSubscriptionDao(Connection con, int moduleId) {
        super(con, moduleId, MEGOGO_SUBSCRIPTION_TABLE_NAME);
    }

    public List<Integer> getMainSubscriptionsServiceIds() throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        String query = "SELECT sid FROM " + this.tableName + " WHERE type=1";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(rs.getInt("sid"));
            }
        }
        return list;
    }

    public List<MegogoSubscription> getSubscriptionList(Boolean used, int type) throws SQLException {
        Object request = "SELECT s.id as serId, s.title, s.isusing, ms.* FROM service AS s ";
        if (used == null || used.booleanValue()) {
            request = (String)request + " LEFT ";
        }
        request = (String)request + "JOIN " + this.tableName + " AS ms ON s.id=ms.sid WHERE mid=" + this.moduleId + (used != null ? " AND s.isusing=?" : "");
        if (type > 0 && type < 3) {
            request = (String)request + " AND type=" + type;
        }
        request = (String)request + " ORDER BY ms.type, ms.id";
        try (PreparedStatement ps = this.con.prepareStatement((String)request);){
            List list;
            block15: {
                if (used != null) {
                    ps.setBoolean(1, used);
                }
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getListFromRS(rs);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    public MegogoSubscription getByServiceId(int serviceId) throws SQLException {
        String query = "SELECT s.id as serId, s.title, s.isusing, ms.* FROM " + this.tableName + " AS ms LEFT JOIN service AS s ON ms.sid=s.id WHERE ms.sid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, serviceId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    MegogoSubscription megogoSubscription = this.getFromRS(rs);
                    return megogoSubscription;
                }
            }
        }
        return null;
    }

    protected MegogoSubscription getFromRS(ResultSet rs) throws SQLException {
        MegogoSubscription megogoService = new MegogoSubscription();
        megogoService.setId(rs.getInt("id"));
        megogoService.setSid(rs.getInt("sid"));
        megogoService.setTitle(rs.getString("title"));
        if (megogoService.getSid() == 0) {
            megogoService.setSid(rs.getInt("serId"));
        }
        megogoService.setKey(rs.getString("megogoKey"));
        megogoService.setUsed(rs.getBoolean("isusing"));
        megogoService.setComment(rs.getString("comment"));
        megogoService.setLm((Date)rs.getTimestamp("lm"));
        megogoService.setUserId(rs.getInt("userId"));
        megogoService.setType(rs.getInt("type"));
        return megogoService;
    }

    protected void updateImpl(MegogoSubscription subscription) throws SQLException {
        String querySet = "sid=?, type=?, megogoKey=?, comment=?, userId=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)subscription, querySet);){
            int index = 1;
            ps.setInt(index++, subscription.getSid());
            ps.setInt(index++, subscription.getType());
            ps.setString(index++, subscription.getKey());
            ps.setString(index++, subscription.getComment());
            ps.setInt(index++, subscription.getUserId());
            this.executeUpdate((Id)subscription, index, ps);
        }
    }
}

