/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocSendLog;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentSendMode;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class BillDocSendLogDao
extends AbstractDao<BillDocSendLog> {
    public BillDocSendLogDao(Connection con, int moduleId) {
        super(con, "bill_doc_send_log", moduleId);
    }

    public void searchBillDocSendLog(SearchResult<BillDocSendLog> searchResult, int contractId, String status) throws SQLException {
        ResultSet rs;
        int index;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        boolean anyStatus = status == null || "any".equals(status);
        String queryWhere = " true" + this.queryPeriod(period, "send_time") + (anyStatus ? "" : " AND send_status=?") + (contractId > 0 ? " AND contract_id=?" : "");
        String query = "SELECT * FROM " + this.tableName + " WHERE " + queryWhere + " ORDER BY send_time" + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = 1;
            index = this.psSetPeriod(ps, index, period);
            if (!anyStatus) {
                ps.setString(index++, status);
            }
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = "SELECT count(*), sum(doc_sum) FROM " + this.tableName + " WHERE " + queryWhere;
        ps = this.con.prepareStatement(query);
        try {
            index = 1;
            index = this.psSetPeriod(ps, index, period);
            if (!anyStatus) {
                ps.setString(index++, status);
            }
            if (contractId > 0) {
                ps.setInt(index++, contractId);
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                    searchResult.setSum(rs.getBigDecimal(2));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    protected BillDocSendLog getFromRS(ResultSet rs) throws SQLException {
        return new BillDocSendLog().setId(Utils.UUID_fromBytes((byte[])rs.getBytes("id")).toString()).setContractId(rs.getInt("contract_id")).setDocumentType(DocumentType.valueOf((String)rs.getString("doc_type"))).setDocumentId(rs.getInt("doc_id")).setDocumentSum(rs.getBigDecimal("doc_sum")).setSendTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("send_time"))).setSendMode(DocumentSendMode.valueOf((String)rs.getString("send_mode"))).setSendAddress(rs.getString("send_address")).setSendStatus(rs.getString("send_status")).setSendStatusMessage(rs.getString("send_status_message")).setSendUserId(rs.getInt("send_user_id"));
    }

    protected void updateImpl(BillDocSendLog billDocSendLog) throws SQLException {
        Objects.requireNonNull(billDocSendLog);
        boolean update = billDocSendLog.getId() != null;
        String querySet = " contract_id=?, doc_type=?, doc_id=?, doc_sum=?, send_time=?, send_mode=?, send_address=?, send_status=?, send_status_message=?, send_user_id=?";
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET " + querySet + (update ? " WHERE id=?" : ", id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (!update) {
                billDocSendLog.setId(Utils.randomUUIDv7().toString());
            }
            int index = 1;
            ps.setInt(index++, billDocSendLog.getContractId());
            ps.setString(index++, billDocSendLog.getDocumentType().name());
            ps.setInt(index++, billDocSendLog.getDocumentId());
            ps.setBigDecimal(index++, billDocSendLog.getDocumentSum());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)billDocSendLog.getSendTime()));
            ps.setString(index++, billDocSendLog.getSendMode().name());
            ps.setString(index++, billDocSendLog.getSendAddress());
            ps.setString(index++, billDocSendLog.getSendStatus());
            ps.setString(index++, billDocSendLog.getSendStatusMessage());
            ps.setInt(index++, billDocSendLog.getSendUserId());
            ps.setBytes(index++, Utils.UUID_asBytes((UUID)UUID.fromString(billDocSendLog.getId())));
            ps.executeUpdate();
        }
    }
}

