/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.chronopay.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMode;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.chronopay.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.chronopay.server.service.ChronoPayServiceImpl;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.chronopay.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), ChronoPayServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "chronopay", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        return Arrays.asList(PaymentMethod.CARD);
    }

    public PaymentMode getPaymentMode() {
        return PaymentMode.FORM;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

