/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.common.model.Period;

public class ServiceDao
extends AbstractDirectoryIdDao<Service> {
    public ServiceDao(Connection con) {
        super(con, 0, "service");
    }

    @Override
    public Service get(String title) throws BGException {
        return null;
    }

    @Override
    public List<Service> list() throws BGException {
        return this.list(null, "mid, title", new Object[0]);
    }

    public List<Service> listUsing() throws BGException {
        return this.list("isusing", "mid, title", new Object[0]);
    }

    public List<Service> list(int moduleId) throws BGException {
        return this.list("mid=?", "title", moduleId);
    }

    public List<Service> listUsing(int moduleId) throws BGException {
        return this.list("mid=?, isusing", "mid, title", new Object[0]);
    }

    @Override
    protected void updateImpl(Service service) throws BGException, SQLException {
        boolean update = service.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, mid=?, isusing=?, unit=?, config=?, active_date_from=?, active_date_to=? " + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, service.getTitle());
            ps.setInt(index++, service.getModuleId());
            ps.setBoolean(index++, service.isUsing());
            ps.setInt(index++, service.getUnit());
            ps.setString(index++, service.getConfig());
            ps.setDate(index++, service.getActivePeriod() != null ? TimeUtils.convertDateToSqlDate(service.getActivePeriod().getDateFrom()) : null);
            ps.setDate(index++, service.getActivePeriod() != null ? TimeUtils.convertDateToSqlDate(service.getActivePeriod().getDateTo()) : null);
            this.executeUpdate(service, index, ps);
        }
    }

    @Override
    protected Service getFromRS(ResultSet rs) throws SQLException {
        return Service.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setModuleId(rs.getInt("mid")).setUsing(rs.getInt("isusing") == 1).setUnit(rs.getInt("unit")).setConfig(rs.getString("config")).setActivePeriod(new Period(rs.getDate("active_date_from"), rs.getDate("active_date_to"))).build();
    }
}

