/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import bitel.billing.module.common.ComboBoxItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.tariff.client.TariffLabelPanel;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanelEditor;
import ru.bitel.bgbilling.kernel.tariff.client.TariffVarsPanel;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlanData;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class TariffPanel
extends BGTabPanel {
    private static final String TARIFF_LIST = "list";
    public static final String TAB_ID = "newTariffPlanEditor";
    private JTabbedPane tabbedPane = new JTabbedPane();
    JComboBox<ComboBoxItem> usedFilterComboBox = new JComboBox();
    private JButton copyTariff = new JButton(ClientUtils.getIcon("copy"));
    private BGTextField titleText = new BGTextField();
    private BGControlPanelPages pages = new BGControlPanelPages();
    private BGControlPanelListSelect tariffModuleList = new BGControlPanelListSelect();
    private CardLayout cardLayout1 = new CardLayout();
    private JPanel rightPanel = new JPanel(this.cardLayout1);
    private JLabel countLabel = new JLabel();
    TariffPlanModel tariffModel = new TariffPlanModel();
    BGUTable tariffTable = new BGUTable(this.tariffModel);
    TariffLabelPanel labelPanel;
    TariffPanelEditor tariffPanelEditor;

    public TariffPanel() {
        super(TAB_ID, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0445 \u043f\u043b\u0430\u043d\u043e\u0432");
        this.module = "tariff";
        this.tryCall(() -> this.jbInit());
        this.trySetData();
        this.copyTariff.setMargin(new Insets(2, 2, 2, 2));
        this.copyTariff.addActionListener(e -> this.copyItem());
        BGClientBase.getFrame().getTabbedPane().addChangeListener(new TabListener(this));
    }

    @Override
    public boolean onClosing() {
        if (!this.tariffPanelEditor.isShowing() || !this.tariffPanelEditor.isNeedFlush()) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0422\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e. \u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0);
        switch (result) {
            case 0: {
                this.tariffPanelEditor.flush.perform();
                break;
            }
        }
        return true;
    }

    private void jbInit() throws Exception {
        this.init = false;
        this.labelPanel = new TariffLabelPanel(this);
        this.labelPanel.setLabelTreeData();
        ComboBoxItem[] items = new ComboBoxItem[]{new ComboBoxItem(2, "\u043d\u0435 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c"), new ComboBoxItem(1, "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d"), new ComboBoxItem(0, "\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d")};
        this.usedFilterComboBox = new JComboBox<ComboBoxItem>(items){
            {
                this.addActionListener(event -> {
                    TariffPanel.this.initPages();
                    TariffPanel.this.trySetData();
                });
            }
        };
        this.rightPanel.add((Component)this.getTariffListPanel(), TARIFF_LIST);
        this.tariffPanelEditor = new TariffPanelEditor(this);
        BGEditor editor = new BGEditor("table");
        editor.addForm(new BGSplitPaneNoBorder(1, this.getFilterPanel(), (Component)this.rightPanel, 400L), "table");
        editor.addForm(this.tariffPanelEditor);
        TariffVarsPanel tariffVarsPanel = new TariffVarsPanel(this.getKernelContext(), () -> this.getContext().getPort(TariffService.class));
        this.tabbedPane.add((Component)editor, "\u0422\u0430\u0440\u0438\u0444\u044b");
        this.tabbedPane.add((Component)tariffVarsPanel, "\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 (\u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0435)");
        this.tabbedPane.addChangeListener(e -> {
            if (this.tabbedPane.getSelectedIndex() == 1) {
                tariffVarsPanel.loadTariffVars();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTariffListPanel() {
        this.tariffTable.setSelectionMode(0);
        this.tariffTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2 && TariffPanel.this.tariffTable.isEnabled()) {
                    TariffPanel.this.tariffPanelEditor.performAction("edit");
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b "));
        panel.add((Component)this.copyTariff, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 5, 3), 0, 0));
        panel.add((Component)this.countLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 15), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 5, 3), 0, 0));
        panel.add((Component)new JScrollPane(this.tariffTable), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        this.titleText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    TariffPanel.this.initPages();
                    TariffPanel.this.trySetData();
                } else {
                    super.keyTyped(event);
                }
            }
        });
        this.initPages();
        this.pages.addToHandler(a -> this.trySetData());
        Dimension dimension = new Dimension(100, 200);
        this.tariffModuleList.setMinimumSize(dimension);
        this.tariffModuleList.setPreferredSize(dimension);
        this.tariffModuleList.addPropertyChangeListener(e -> {
            if ("itemChange".equals(e.getPropertyName()) && this.tariffModuleList.isEnabled()) {
                this.initPages();
                this.trySetData();
            }
        });
        int y = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430:"), new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)this.titleText, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 5, 3), 0, 0));
        panel.add((Component)new JLabel("\u0424\u043b\u0430\u0433 \"\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f\":"), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 5, 3), 0, 0));
        panel.add(this.usedFilterComboBox, new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 3), 0, 0));
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u0438:"), new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)this.tariffModuleList, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.labelPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 1.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    @Override
    public void setData() throws Exception {
        Request request = new Request().setModule(this.module).setAction("ListTariffPlans").setPage(this.pages).setAttribute("showUsed", ((ComboBoxItem)this.usedFilterComboBox.getSelectedItem()).getObject().toString()).setAttribute("moduleId", this.tariffModuleList.getListValues()).setAttribute("labelIds", Utils.toString(this.labelPanel.filterLabelTree.getSelectedIds())).setAttribute("titleMask", this.titleText.getText()).setAttribute("contractCount", "true");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element tariffPlans = XMLUtils.selectElement(doc, "//tariffPlans");
            this.tariffModel.setData(XMLUtils.selectElements(tariffPlans, "//item"));
            this.pages.setPageInfo(tariffPlans);
            this.countLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + tariffPlans.getAttribute("recordCount"));
        }
        if (((DefaultListModel)this.tariffModuleList.getList().getModel()).getSize() == 0) {
            this.tariffModuleList.getList().setData(this.getContext().getWebService(TariffService.class).tariffModulesList().stream().map(a -> new BGUListItem((IdTitle)a)).toList());
        }
        this.showTariffTable();
    }

    public void initPages() {
        this.pages.init();
    }

    private void showTariffTable() {
        this.cardLayout1.show(this.rightPanel, TARIFF_LIST);
    }

    @Override
    public void newItem() {
        this.tariffPanelEditor.performAction("new");
    }

    @Override
    public void copyItem() {
        this.tariffPanelEditor.performAction("copy");
    }

    @Override
    public void editItem() {
        this.tariffPanelEditor.performAction("edit");
    }

    @Override
    public void deleteItem() {
        this.tariffPanelEditor.performAction("delete");
    }

    public ContractLabelService getContractLabelService() {
        return this.getContext().getPort(ContractLabelService.class);
    }

    class TariffPlanModel
    extends BGTableModel<TariffPlanData> {
        private static final String FIELD_ID = "id";
        private static final String FIELD_TITLE = "title";
        private static final String FIELD_COMMENT = "comment";
        private static final String FIELD_COUNT_CHILD = "countChild";
        private static final String FIELD_COUNT_ACTIVE = "countActive";
        private static final String FIELD_COUNT_ALL = "countAll";

        public TariffPlanModel() {
            super("tariffPlan");
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 400, -1, FIELD_TITLE, true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 500, -1, FIELD_COMMENT);
            this.addColumn("\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u043e \u0422\u041f", -1, 100, -1, FIELD_COUNT_CHILD, true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 (\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445)", -1, 100, -1, FIELD_COUNT_ACTIVE, true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 (\u0432\u0441\u0435\u0433\u043e)", -1, 100, -1, FIELD_COUNT_ALL, true, DecimalTableCellRenderer.INTEGER());
        }

        @Override
        public void setData(Iterable<Element> rowsElement) {
            ArrayList<TariffPlanData> data = new ArrayList<TariffPlanData>();
            for (Element item : rowsElement) {
                TariffPlanData tariffPlan = new TariffPlanData();
                tariffPlan.setId(Utils.parseInt(item.getAttribute(FIELD_ID), -1));
                tariffPlan.setTitle(item.getAttribute(FIELD_TITLE));
                tariffPlan.setCountChild(Utils.parseInt(item.getAttribute(FIELD_COUNT_CHILD), 0));
                tariffPlan.setCountActive(Utils.parseInt(item.getAttribute(FIELD_COUNT_ACTIVE), 0));
                tariffPlan.setCountAll(Utils.parseInt(item.getAttribute(FIELD_COUNT_ALL), 0));
                tariffPlan.setComment(item.getAttribute(FIELD_COMMENT));
                data.add(tariffPlan);
            }
            this.setData(data, true);
        }
    }

    static class TabListener
    implements ChangeListener {
        private WeakReference<TariffPanel> ref;
        private boolean selected;

        public TabListener(TariffPanel panel) {
            this.ref = new WeakReference<TariffPanel>(panel);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(() -> this.stateChanged());
        }

        public void stateChanged() {
            TariffPanel panel = (TariffPanel)this.ref.get();
            if (panel == null) {
                BGClientBase.getFrame().getTabbedPane().removeChangeListener(this);
                return;
            }
            int index = BGClientBase.getFrame().getTabbedPane().indexOfComponent(panel);
            if (index < 0 && !BGClientBase.getFrame().getTabbedPane().getTabList().contains(panel)) {
                BGClientBase.getFrame().getTabbedPane().removeChangeListener(this);
                return;
            }
            if (index == BGClientBase.getFrame().getTabbedPane().getSelectedIndex()) {
                this.selected = true;
            } else if (this.selected) {
                this.selected = false;
                if (!panel.tariffPanelEditor.isNeedFlush()) {
                    return;
                }
                int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0422\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e. \u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                switch (result) {
                    case 0: {
                        panel.tariffPanelEditor.flush.perform();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        BGClientBase.getFrame().getTabbedPane().setSelectedIndex(index);
                    }
                }
            }
        }
    }
}

