/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.tariff.server.bean.RoundRule;
import ru.bitel.common.Utils;

public class VoiceTariffConfig {
    private int freeLimit;
    private Integer scale;
    private boolean useForAuth;
    private boolean useRound = false;
    private List<RoundRule> ruleList = new ArrayList<RoundRule>();

    public VoiceTariffConfig(String data) {
        String[] parts = data.split(";");
        if (parts.length >= 3) {
            this.useForAuth = parts[0].equals("1");
            this.freeLimit = Utils.parseInt(parts[1], 0);
            this.loadRuleList(parts[2]);
            if (parts.length > 3) {
                try {
                    this.scale = Integer.valueOf(parts[3]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (parts.length > 4) {
                this.useRound = parts[4].equals("1");
            }
        }
    }

    private void loadRuleList(String data) {
        String[] parts = data.split(",");
        int size = parts.length;
        for (int i = 0; i < size; ++i) {
            String[] fromToQuantum = parts[i].split(":");
            if (fromToQuantum.length != 3) continue;
            RoundRule rule = new RoundRule(Utils.parseInt(fromToQuantum[0], 0), Utils.parseInt(fromToQuantum[1], 0), Utils.parseInt(fromToQuantum[2], 1));
            this.ruleList.add(rule);
        }
    }

    public boolean isUseForAuth() {
        return this.useForAuth;
    }

    public boolean isUseRound() {
        return this.useRound;
    }

    public int getFreeLimit() {
        return this.freeLimit;
    }

    public BigDecimal roundCost(BigDecimal cost, int defaultScale) {
        return cost.setScale(this.scale != null && this.scale >= 0 ? this.scale : defaultScale, RoundingMode.HALF_EVEN);
    }

    public int getRoundQuantum(int sessionTime) {
        int result = 1;
        for (RoundRule rule : this.ruleList) {
            if (!rule.isCoinside(sessionTime)) continue;
            result = rule.getQuantum();
            break;
        }
        return result;
    }

    public int getRoundTime(int sessionTime) {
        if (sessionTime <= this.getFreeLimit()) {
            sessionTime = 0;
        } else {
            int quantum = this.getRoundQuantum(sessionTime);
            if (sessionTime % quantum > 0) {
                sessionTime = (sessionTime / quantum + 1) * quantum;
            }
        }
        return sessionTime;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(200);
        result.append("VoipTariffConfig freeLimit: ");
        result.append(this.freeLimit);
        result.append("; useForAuth: ");
        result.append(this.useForAuth);
        result.append("; useRound: ");
        result.append(this.useRound);
        result.append("; rulesCount: ");
        result.append(this.ruleList.size());
        return result.toString();
    }
}

