/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mtsbank.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.mtsbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.mtsbank.server.event.MTSbankAutopaymentEvent;
import ru.bitel.common.model.SearchResult;

public class MTSBankAutopaymentTask
extends TaskBase {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            this.doAutopayment(con, AutopaymentMode.WEEK, "autopayment.mode.week.sum");
            this.doAutopayment(con, AutopaymentMode.MONTH, "autopayment.mode.month.sum");
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    private void doAutopayment(Connection con, AutopaymentMode mode, String key) throws Exception {
        AutopaymentManager autopaymentManager = new AutopaymentManager(con, this.moduleId);
        SearchResult searchResult = new SearchResult();
        autopaymentManager.searchCurrentAutopayment(searchResult, this.getStartTime(), mode);
        for (Autopayment autopayment : searchResult.getList()) {
            BigDecimal sum = autopayment.getSum();
            if (sum == null) continue;
            EventProcessor.getInstance().publish((Event)new MTSbankAutopaymentEvent(this.moduleId, autopayment.getContractId(), mode, sum));
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c MTSBank. \u0417\u0430\u0434\u0430\u0447\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 (\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u044b\u0439 \u0438 \u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c). \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }
}

