/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UnregRequestRecord;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class UserRecordLogDao
extends AbstractDao<UnregRequestRecord> {
    private static final String TABLE_UNREGISTRATION = "bgs_request_unregistration";

    public UserRecordLogDao(Connection con) {
        super(con, TABLE_UNREGISTRATION, 0);
    }

    public void searchUnregRequestRecordList(SearchResult<UnregRequestRecord> searchResult) throws Exception {
        Objects.requireNonNull(searchResult);
        List<UnregRequestRecord> list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM bgs_request_unregistration ORDER BY last_time DESC" + this.sqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
    }

    @Override
    protected UnregRequestRecord getFromRS(ResultSet rs) throws SQLException {
        try {
            return this.ormFromResultSet(rs, UnregRequestRecord.class);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    protected void updateImpl(UnregRequestRecord record) throws SQLException {
        int index;
        Objects.requireNonNull(record);
        boolean update = false;
        String querySet = " SET module_id=?, action=?, service=?, operation=?, contract_id=?, user_id=?, last_time=?";
        String query = "UPDATE bgs_request_unregistration" + querySet + " WHERE true" + (record.getAction() != null ? " AND action=?" : "") + (record.getService() != null ? " AND service=?" : "") + (record.getOperation() != null ? " AND operation=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            index = 1;
            ps.setString(index++, record.getModuleId());
            ps.setString(index++, record.getAction());
            ps.setString(index++, record.getService());
            ps.setString(index++, record.getOperation());
            ps.setInt(index++, record.getContractId());
            ps.setInt(index++, record.getUserId());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(record.getLastTime()));
            if (record.getAction() != null) {
                ps.setString(index++, record.getAction());
            }
            if (record.getService() != null) {
                ps.setString(index++, record.getService());
            }
            if (record.getOperation() != null) {
                ps.setString(index++, record.getOperation());
            }
            update = ps.executeUpdate() > 0;
        }
        if (!update) {
            query = "INSERT INTO bgs_request_unregistration" + querySet;
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setString(index++, record.getModuleId());
                ps.setString(index++, record.getAction());
                ps.setString(index++, record.getService());
                ps.setString(index++, record.getOperation());
                ps.setInt(index++, record.getContractId());
                ps.setInt(index++, record.getUserId());
                ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(record.getLastTime()));
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public void clearUnregRequestRecordList() throws SQLException {
        String query = "DELETE FROM bgs_request_unregistration";
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public void deleteUnregRequestRecord(UnregRequestRecord record) throws SQLException {
        String query = "DELETE FROM bgs_request_unregistration WHERE true" + (record.getAction() != null ? " AND action=?" : "") + (record.getModuleName() != null ? " AND moduleName=?" : "") + (record.getService() != null ? " AND service=?" : "") + (record.getOperation() != null ? " AND operation=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            if (record.getAction() != null) {
                ps.setString(index++, record.getAction());
            }
            if (record.getModuleName() != null) {
                ps.setString(index++, record.getModuleName());
            }
            if (record.getService() != null) {
                ps.setString(index++, record.getService());
            }
            if (record.getOperation() != null) {
                ps.setString(index++, record.getOperation());
            }
            ps.executeUpdate();
        }
    }

    public void clearUnregRequestActionRecord(List<String> recordIds) throws SQLException {
        String query = "DELETE FROM bgs_request_unregistration WHERE module_id=? AND action=?";
        this.clearUnregRequestServiceRecord(query, recordIds);
    }

    public void clearUnregRequestServiceRecord(List<String> recordIds) throws SQLException {
        String query = "DELETE FROM bgs_request_unregistration WHERE service=? AND operation=?";
        this.clearUnregRequestServiceRecord(query, recordIds);
    }

    private void clearUnregRequestServiceRecord(String query, List<String> recordIds) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (String recordId : recordIds) {
                String[] data = recordId.split("_");
                int index = 1;
                ps.setString(index++, data[1]);
                ps.setString(index++, data[2]);
                ps.executeUpdate();
            }
        }
    }
}

