/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.sequence.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.sequence.common.bean.BGSequence;
import ru.bitel.bgbilling.kernel.sequence.common.bean.enums.BGSequenceMode;
import ru.bitel.bgbilling.kernel.sequence.common.bean.enums.BGSequenceType;
import ru.bitel.common.TimeUtils;

public class BGSequenceDao
extends AbstractIdDao<BGSequence> {
    public BGSequenceDao(Connection con) {
        super(con, 0, "counter_sequence");
    }

    public List<BGSequence> list(BGSequenceType sequenceType) throws SQLException {
        return this.list("sequence_type=?", "title", sequenceType.name());
    }

    @Override
    protected BGSequence getFromRS(ResultSet rs) throws SQLException {
        return new BGSequence(rs.getInt("id"), rs.getString("title")).setCounter(rs.getLong("counter")).setResetDate(TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("reset_date"))).setSequenceMode(BGSequenceMode.valueOf(rs.getString("sequence_mode"))).setSequenceType(BGSequenceType.valueOf(rs.getString("sequence_type")));
    }

    @Override
    protected void updateImpl(BGSequence sequence) throws SQLException {
        String querySet = "title=?, reset_date=?, sequence_mode=?, sequence_type=?";
        try (PreparedStatement ps = this.prepareStatement(sequence, querySet);){
            int index = 1;
            ps.setString(index++, sequence.getTitle());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(sequence.getResetDate()));
            ps.setString(index++, sequence.getSequenceMode().name());
            ps.setString(index++, sequence.getSequenceType().name());
            this.executeUpdate(sequence, index, ps);
        }
    }
}

