/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelContractSelect;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class VoiceOperatorPanel
extends BGUPanel {
    private OperatorTableModel operatorTableModel;

    protected void jbInit() throws Exception {
        this.operatorTableModel = new OperatorTableModel(OperatorTableModel.class.getName());
        BGUTable operatorTable = new BGUTable((TableModel)((Object)this.operatorTableModel));
        operatorTable.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)operatorTable)), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)operatorTable, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.operatorTableModel.setData(((VoiceOperatorService)((ClientContext)this.getContext()).getWebService(VoiceOperatorService.class)).voiceOperatorList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new VoiceOperatorEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440", new VoiceOperator()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.operatorTableModel, VoiceOperatorEditorDialog.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            VoiceOperator currentOperator = (VoiceOperator)this.operatorTableModel.getSelectedRow();
            if (currentOperator == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430 " + currentOperator.getTitle() + "?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430", 0) == 0) {
                ((VoiceOperatorService)((ClientContext)this.getContext()).getWebService(VoiceOperatorService.class)).voiceOperatorDelete(currentOperator.getId());
                this.performAction("refresh");
            }
        });
    }

    class OperatorTableModel
    extends BGTableModel<VoiceOperator> {
        public OperatorTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430", -1, -1, -1, "contractTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class VoiceOperatorEditorDialog
    extends BGEditorDialog<VoiceOperator> {
        private BGTextField operatorTitle;
        private BGControlPanelContractSelect contractSelect;
        private BGTextField comment;
        private JCheckBox useCustomGeoDict;

        public VoiceOperatorEditorDialog(String title, VoiceOperator data) {
            super(title, (Object)data);
            this.operatorTitle = new BGTextField(50);
            this.contractSelect = new BGControlPanelContractSelect(false, true, true);
            this.comment = new BGTextField(50);
            this.useCustomGeoDict = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0435\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438 \u0433\u0435\u043e\u043a\u043e\u0434\u043e\u0432");
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
            this.panel.add((Component)this.operatorTitle, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 3), 0, 0));
            this.panel.add((Component)this.contractSelect, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 3), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 3), 0, 0));
            this.panel.add((Component)this.comment, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.useCustomGeoDict, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.operatorTitle.setText(((VoiceOperator)this.data).getTitle());
            this.contractSelect.setContracts(String.valueOf(((VoiceOperator)this.data).getContractId()), ((VoiceOperator)this.data).getContractTitle());
            this.useCustomGeoDict.setSelected(((VoiceOperator)this.data).isUseCustomGeoDict());
            this.comment.setText(((VoiceOperator)this.data).getComment());
        }

        public boolean doApply() throws Exception {
            String title = this.operatorTitle.getText();
            if (Utils.isBlankString((String)title)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430!");
                return false;
            }
            String contract = this.contractSelect.getContracts();
            if (Utils.isBlankString((String)contract)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440, \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440!");
                return false;
            }
            ((VoiceOperator)this.data).setContractId(Utils.parseInt((String)contract, (int)0));
            ((VoiceOperator)this.data).setUseCustomGeoDict(this.useCustomGeoDict.isSelected());
            ((VoiceOperator)this.data).setTitle(title);
            ((VoiceOperator)this.data).setComment(this.comment.getText());
            ((VoiceOperatorService)((ClientContext)VoiceOperatorPanel.this.getContext()).getWebService(VoiceOperatorService.class)).voiceOperatorUpdate((VoiceOperator)this.data);
            VoiceOperatorPanel.this.performAction("refresh");
            return true;
        }
    }
}

