/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountPort;
import ru.bitel.bgbilling.modules.voice.common.event.VoiceAccountModifiedEvent;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceAccountDeviceStateModifiedEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.CopyOnWriteListMap;
import ru.bitel.common.util.CopyOnWriteRangeListMap;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

public class VoiceAccountRuntimeMap
extends BGLogger
implements EventListener<Event> {
    private final ConcurrentMap<Integer, VoiceAccountRuntime> accountMap = new ConcurrentHashMap<Integer, VoiceAccountRuntime>();
    private final CopyOnWriteListMap<Integer, VoiceAccountRuntime> contractMap = new CopyOnWriteListMap(128, 4);
    private final Ranger<VoiceAccountRuntime, Long> periodRanger = new Ranger<VoiceAccountRuntime, Long>(this){

        public Long getMinValue(VoiceAccountRuntime r) {
            return r.getDateFromMillis() > 0L ? Long.valueOf(r.getDateFromMillis()) : null;
        }

        public Long getMaxValue(VoiceAccountRuntime r) {
            return r.getDateToMillis() > 0L ? Long.valueOf(r.getDateToMillis()) : null;
        }
    };
    private CopyOnWriteRangeListMap<Long, VoiceAccountRuntime, Long> numberMap = new CopyOnWriteRangeListMap(this.periodRanger, 128, 1);
    private CopyOnWriteRangeListMap<DeviceNumber, VoiceAccountRuntime, Long> deviceNumberMap = new CopyOnWriteRangeListMap(this.periodRanger, 128, 1);
    private final CopyOnWriteRangeListMap<String, VoiceAccountRuntime, Long> loginMap = new CopyOnWriteRangeListMap(this.periodRanger, 128, 1);
    private CopyOnWriteRangeListMap<String, VoiceAccountRuntime, Long> portMap = new CopyOnWriteRangeListMap(this.periodRanger, 128, 1);
    private List<Integer> subContractGroupOrder = new ArrayList<Integer>();
    private Date dateFrom;
    private VoiceApplication application;
    private static VoiceAccountRuntimeMap intance = null;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public static VoiceAccountRuntimeMap getInstance(ConnectionSet connectionSet, VoiceApplication application) throws BGException {
        return VoiceAccountRuntimeMap.getInstance(connectionSet, application, TimeUtils.getStartMonth((Date)new Date()));
    }

    public static VoiceAccountRuntimeMap getInstance(ConnectionSet connectionSet, VoiceApplication application, Date month) throws BGException {
        return VoiceAccountRuntimeMap.getInstance(connectionSet.getConnection(), application, month);
    }

    public static VoiceAccountRuntimeMap getInstance(Connection connection, VoiceApplication application, Date month) throws BGException {
        if (intance == null) {
            intance = new VoiceAccountRuntimeMap(application);
            intance.load(connection, TimeUtils.getStartMonth((Date)month));
        }
        return intance;
    }

    protected VoiceAccountRuntimeMap(VoiceApplication application) throws BGException {
        this.application = application;
        EventProcessor ep = EventProcessor.getInstance();
        ep.addListener((EventListener)this, VoiceAccountModifiedEvent.class, application.getModuleId(), null);
        ep.addListener((EventListener)this, VoiceAccountDeviceStateModifiedEvent.class, application.getModuleId(), null);
        ep.addListener((EventListener)this, ContractTariffChangedEvent.class);
        ep.addListener((EventListener)this, ContractModifiedEvent.class);
        ep.addListener((EventListener)this, ContractStatusModifiedEvent.class);
    }

    public void load(Connection con, Date dateFrom) throws BGException {
        this.getLogger().info("loading accounts");
        this.dateFrom = dateFrom;
        this.accountMap.clear();
        this.numberMap.clear();
        this.loginMap.clear();
        this.parseContractGroupOrder();
        try (VoiceAccountDao accountDao = new VoiceAccountDao(con, this.application.getModuleId());
             TariffModuleTreeSetDao tariffModuleTreeDao = new TariffModuleTreeSetDao(con);){
            for (VoiceAccount account : accountDao.list()) {
                this.addRuntimeInternal(this.createRuntimeInternal(con, tariffModuleTreeDao, account));
            }
        }
    }

    private void parseContractGroupOrder() {
        ModuleSetup moduleConfig = this.application.getSetup().getModuleSetup(Integer.valueOf(this.application.getModuleId()));
        String groupOrder = moduleConfig.get("radius.agent.sub.contract.order");
        this.subContractGroupOrder = Utils.toIntegerList((String)groupOrder);
    }

    public VoiceAccountRuntime createRuntime(Connection con, VoiceAccount account) throws BGException {
        try (TariffModuleTreeSetDao tariffModuleTreeDao = new TariffModuleTreeSetDao(con);){
            VoiceAccountRuntime voiceAccountRuntime = this.createRuntimeInternal(con, tariffModuleTreeDao, account);
            return voiceAccountRuntime;
        }
    }

    private VoiceAccountRuntime createRuntimeInternal(Connection con, TariffModuleTreeSetDao tariffModuleTreeDao, VoiceAccount account) throws BGException {
        VoiceAccountRuntime accountRuntime = new VoiceAccountRuntime(account);
        this.loadTariffs(con, tariffModuleTreeDao, accountRuntime);
        return accountRuntime;
    }

    public void loadTariffs(Connection con, TariffModuleTreeSetDao tariffModuleTreeDao, VoiceAccountRuntime accountRuntime) throws BGException {
        VoiceAccount account = (VoiceAccount)accountRuntime.getAccount();
        accountRuntime.setTariffTreeSet(tariffModuleTreeDao.getRealtimeTariffTreeSet(account.getContractId(), this.dateFrom, "voice", this.application.getModuleId(), this.application.getModuleId(), account.getId()));
        this.loadSubContract(con, tariffModuleTreeDao, accountRuntime);
    }

    public void loadSubContract(Connection con, TariffModuleTreeSetDao tariffModuleTreeDao, VoiceAccountRuntime accountRuntime, Contract contract) throws BGException {
        boolean isSuper;
        boolean isIndependSub = false;
        int superContractId = 0;
        if (contract == null) {
            contractId = ((VoiceAccount)accountRuntime.getAccount()).getContractId();
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(con, Integer.valueOf(contractId));
            if (contractRuntime == null) {
                this.getLogger().error("contractRuntime is null for contractId");
                return;
            }
            isSuper = contractRuntime.isSuper();
            superContractId = contractRuntime.getIndependentSuperContractId() > 0 ? contractRuntime.getIndependentSuperContractId() : contractId;
        } else {
            contractId = contract.getId();
            isSuper = contract.isSuper();
            isIndependSub = contract.isIndependSub();
            superContractId = isIndependSub ? contract.getSuperCid() : contractId;
        }
        ArrayList<VoiceAccountRuntime.ContractInfo> subContracts = new ArrayList<VoiceAccountRuntime.ContractInfo>();
        if (isSuper || isIndependSub) {
            try (ContractDao contractDao = new ContractDao(con, 0);){
                List subListIndep = contractDao.getSubContracts(superContractId, 1);
                this.sortByGroupOrder(subListIndep);
                for (Contract sub : subListIndep) {
                    VoiceAccountRuntime.ContractInfo info = new VoiceAccountRuntime.ContractInfo(accountRuntime);
                    info.contractId = sub.getId();
                    info.tariffTreeSet = tariffModuleTreeDao.getRealtimeTariffTreeSet(sub.getId(), this.dateFrom, "voice", this.application.getModuleId(), -1, ((VoiceAccount)accountRuntime.getAccount()).getId());
                    info.status = sub.getStatus();
                    subContracts.add(info);
                }
            }
        }
        accountRuntime.setSubContracts(subContracts);
    }

    public void loadSubContract(Connection con, TariffModuleTreeSetDao tariffModuleTreeDao, VoiceAccountRuntime accountRuntime) throws BGException {
        this.loadSubContract(con, tariffModuleTreeDao, accountRuntime, null);
    }

    private void sortByGroupOrder(List<Contract> subListIndep) {
        Collections.sort(subListIndep, new Comparator<Contract>(){

            @Override
            public int compare(Contract left, Contract right) {
                for (Integer gr : VoiceAccountRuntimeMap.this.subContractGroupOrder) {
                    boolean rightInGroup;
                    boolean leftInGroup = (left.getGroups() & (long)(1 << gr)) > 0L;
                    boolean bl = rightInGroup = (right.getGroups() & (long)(1 << gr)) > 0L;
                    if (leftInGroup && rightInGroup) {
                        return 0;
                    }
                    if (leftInGroup) {
                        return -1;
                    }
                    if (!rightInGroup) continue;
                    return 1;
                }
                return -1;
            }
        });
    }

    public VoiceAccountRuntime addRuntime(Connection con, VoiceAccount account) throws BGException {
        return this.onAccountModified(con, account);
    }

    private void addRuntimeInternal(VoiceAccountRuntime accountRuntime) throws BGException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("accountRuntime = {}", (Object)accountRuntime);
            this.getLogger().trace("accountRuntime.getAccount() = {}", accountRuntime.getAccount());
            this.getLogger().trace("accountRuntime.getAccount().getId() = {}", (Object)((VoiceAccount)accountRuntime.getAccount()).getId());
            this.getLogger().trace("accountRuntime.getAccount().getLogin() = {}", (Object)((VoiceAccount)accountRuntime.getAccount()).getLogin());
            this.getLogger().trace("accountRuntime.getAccount().getNumber() = {}", (Object)((VoiceAccount)accountRuntime.getAccount()).getNumber());
        }
        this.accountMap.put(((VoiceAccount)accountRuntime.getAccount()).getId(), accountRuntime);
        if (((VoiceAccount)accountRuntime.getAccount()).getNumber() > 0L) {
            this.numberMap.add((Object)((VoiceAccount)accountRuntime.getAccount()).getNumber(), (Object)accountRuntime);
        }
        this.addToContractMap(accountRuntime);
        if (!Utils.isEmptyString((String)((VoiceAccount)accountRuntime.getAccount()).getLogin())) {
            this.loginMap.add((Object)((VoiceAccount)accountRuntime.getAccount()).getLogin(), (Object)accountRuntime);
        }
        for (VoiceAccountPort port : ((VoiceAccount)accountRuntime.getAccount()).getPortList()) {
            this.portMap.add((Object)port.getPort(), (Object)accountRuntime);
        }
        this.deviceNumberMap.add((Object)new DeviceNumber(((VoiceAccount)accountRuntime.getAccount()).getDeviceId(), ((VoiceAccount)accountRuntime.getAccount()).getNumber()), (Object)accountRuntime);
    }

    public void addToContractMap(VoiceAccountRuntime accountRuntime) {
        this.contractMap.add((Object)((VoiceAccount)accountRuntime.getAccount()).getContractId(), (Object)accountRuntime);
        for (VoiceAccountRuntime.ContractInfo contractInfo : accountRuntime.getSubContracts()) {
            this.contractMap.add((Object)contractInfo.contractId, (Object)accountRuntime);
        }
    }

    private VoiceAccountRuntime onAccountModified(Connection con, VoiceAccount account) throws BGException {
        if (!this.application.getDeviceIds().contains(account.getDeviceId())) {
            this.getLogger().info("remove runtime(id = " + account.getId() + ") from not existing device: " + account.getDeviceId());
            this.removeRuntime(account.getId());
            return null;
        }
        VoiceAccountRuntime runtime = (VoiceAccountRuntime)((Object)this.accountMap.get(account.getId()));
        if (runtime == null) {
            this.getLogger().info("Adding new accountRuntime: " + account.getId());
            runtime = this.createRuntime(con, account);
            this.addRuntimeInternal(runtime);
        } else {
            this.getLogger().info("Reload accountRuntime: " + account.getId());
            this.removeRuntime(account.getId());
            runtime.setAccount(account);
            this.addRuntimeInternal(runtime);
        }
        return runtime;
    }

    public VoiceAccountRuntime removeRuntime(int accountId) {
        this.getLogger().info("Removing accountRuntime: {}", (Object)accountId);
        VoiceAccountRuntime oldInstance = (VoiceAccountRuntime)((Object)this.accountMap.remove(accountId));
        if (oldInstance == null) {
            this.getLogger().warn("accountRuntime is null for {}", (Object)accountId);
            return null;
        }
        this.removeFromContractRuntime(oldInstance);
        if (((VoiceAccount)oldInstance.getAccount()).getNumber() > 0L) {
            this.numberMap.remove((Object)((VoiceAccount)oldInstance.getAccount()).getNumber(), (Object)oldInstance);
        }
        if (!Utils.isEmptyString((String)((VoiceAccount)oldInstance.getAccount()).getLogin())) {
            this.loginMap.remove((Object)((VoiceAccount)oldInstance.getAccount()).getLogin(), (Object)oldInstance);
        }
        for (VoiceAccountPort port : ((VoiceAccount)oldInstance.getAccount()).getPortList()) {
            this.portMap.remove((Object)port.getPort(), (Object)oldInstance);
        }
        this.deviceNumberMap.remove((Object)new DeviceNumber(((VoiceAccount)oldInstance.getAccount()).getDeviceId(), ((VoiceAccount)oldInstance.getAccount()).getNumber()), (Object)oldInstance);
        return oldInstance;
    }

    public void removeFromContractRuntime(VoiceAccountRuntime oldInstance) {
        this.contractMap.remove((Object)((VoiceAccount)oldInstance.getAccount()).getContractId(), (Object)oldInstance);
        for (VoiceAccountRuntime.ContractInfo contractInfo : oldInstance.getSubContracts()) {
            this.contractMap.remove((Object)contractInfo.contractId, (Object)oldInstance);
        }
    }

    public void removeRuntimeWithDelay(final int accountId) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                VoiceAccountRuntimeMap.this.removeRuntime(accountId);
            }
        }, 1L, TimeUnit.DAYS);
    }

    public VoiceAccountRuntime get(int id) {
        return (VoiceAccountRuntime)((Object)this.accountMap.get(id));
    }

    public VoiceAccountRuntime findByNumber(Long number, Date date) {
        VoiceAccountRuntime result = null;
        result = (VoiceAccountRuntime)((Object)this.numberMap.get((Object)number, (Comparable)Long.valueOf(date.getTime())));
        return result;
    }

    public VoiceAccountRuntime searchByLogin(String login, Date date) {
        VoiceAccountRuntime result = null;
        result = (VoiceAccountRuntime)((Object)this.loginMap.get((Object)login, (Comparable)Long.valueOf(date.getTime())));
        return result;
    }

    public VoiceAccountRuntime searchByDeviceAndNumber(final int deviceId, Long number, Date date, final boolean deep) {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("deviceId = {}", (Object)deviceId);
            this.getLogger().trace("number = {}", (Object)number);
            this.getLogger().trace("date = {}", (Object)date);
            this.getLogger().trace("deep = {}", (Object)deep);
        }
        VoiceDeviceRuntime device = this.application.getDeviceRuntimeMap().get(deviceId);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("device = {}", (Object)device);
            if (device != null) {
                this.getLogger().trace("device.getDevice() = {}", (Object)device.getDevice());
                if (device.getDevice() != null) {
                    this.getLogger().trace("device.getDevice().getParentId() = {}", (Object)device.getDevice().getParentId());
                }
                this.getLogger().trace("device.descendantIds = {}", device.descendantIds);
            }
        }
        final VoiceDeviceRuntime parent = this.application.getDeviceRuntimeMap().get(device.getDevice().getParentId());
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("parent = {}", (Object)parent);
            if (parent != null) {
                this.getLogger().trace("parent.getDevice() = {}", (Object)parent.getDevice());
                if (parent.getDevice() != null) {
                    this.getLogger().trace("parent.getDevice().getId() = {}", (Object)parent.getDevice().getId());
                }
            }
        }
        final Set<Integer> descendantIds = device.descendantIds;
        return (VoiceAccountRuntime)((Object)this.numberMap.get((Object)number, (Comparable)Long.valueOf(date.getTime()), (Matcher)new Matcher<VoiceAccountRuntime>(){

            public boolean matched(VoiceAccountRuntime accountRuntime) {
                int accountDeviceId = ((VoiceAccount)accountRuntime.getAccount()).getDeviceId();
                if (VoiceAccountRuntimeMap.this.getLogger().isTraceEnabled()) {
                    VoiceAccountRuntimeMap.this.getLogger().trace("accountDeviceId = {}", (Object)accountDeviceId);
                }
                return accountDeviceId == deviceId || deep && descendantIds.contains(accountDeviceId) || parent != null && parent.getDevice().getId() == accountDeviceId;
            }
        }));
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof VoiceAccountModifiedEvent) {
            VoiceAccountModifiedEvent modEvent = (VoiceAccountModifiedEvent)e;
            if (modEvent.getNewAccount() != null) {
                this.onAccountModified(ctx.getConnection(), modEvent.getNewAccount());
            } else {
                this.removeRuntimeWithDelay(modEvent.getOldAccount().getId());
            }
        } else if (e instanceof VoiceAccountDeviceStateModifiedEvent) {
            this.omAccountDeviceStateModified(ctx.getConnection(), (VoiceAccountDeviceStateModifiedEvent)e);
        } else if (e instanceof ContractTariffChangedEvent) {
            this.onTariffListChanged(ctx.getConnection(), e);
        } else if (e instanceof ContractModifiedEvent) {
            this.onContractModifiedEvent(ctx.getConnection(), e.getContractId());
        } else if (e instanceof ContractStatusModifiedEvent) {
            this.onContractStatusModifiedEvent(ctx.getConnection(), e);
        }
    }

    private void onContractStatusModifiedEvent(Connection connection, Event e) throws BGException {
        Contract contract;
        try (ContractDao contractDao = new ContractDao(connection, 0);){
            contract = (Contract)contractDao.get(e.getContractId());
        }
        if (contract == null) {
            return;
        }
        if (contract.isIndependSub()) {
            this.onContractModifiedEvent(connection, contract.getSuperCid());
        }
    }

    private void onContractModifiedEvent(Connection connection, int contractId) throws BGException {
        List accountList;
        Contract contract;
        try (ContractDao contractDao = new ContractDao(connection, 0);){
            contract = (Contract)contractDao.get(contractId);
        }
        if (contract == null) {
            return;
        }
        if (contract.isIndependSub()) {
            this.contractMap.remove((Object)contract.getId());
            List superAccountList = this.contractMap.get((Object)contract.getSuperCid());
            if (superAccountList != null) {
                superAccountList.forEach(a -> this.contractMap.add((Object)contract.getId(), (Object)a));
            }
        }
        if ((accountList = this.contractMap.get((Object)contractId)) != null) {
            for (VoiceAccountRuntime accountRuntime : accountList) {
                if (contract.isIndependSub() || ((VoiceAccount)accountRuntime.getAccount()).getContractId() == contractId) continue;
                this.contractMap.remove((Object)contractId);
                return;
            }
            try (TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(connection);){
                for (VoiceAccountRuntime accountRuntime : accountList) {
                    this.loadSubContract(connection, treeSetDao, accountRuntime, contract);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            if (accountList.isEmpty()) {
                this.contractMap.remove((Object)contractId);
            }
        }
    }

    private void omAccountDeviceStateModified(Connection connection, VoiceAccountDeviceStateModifiedEvent e) {
        VoiceAccountRuntime runtime = (VoiceAccountRuntime)((Object)this.accountMap.get(e.getAccountId()));
        if (runtime == null) {
            this.getLogger().error("omAccountDeviceStateModified: AccountRuntime is null for " + e.getAccountId());
            return;
        }
        ((VoiceAccount)runtime.getAccount()).setDeviceState(e.getState());
    }

    private void onTariffListChanged(Connection connection, Event e) {
        List accountList = this.contractMap.get((Object)e.getContractId());
        if (accountList != null) {
            try (TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(connection);){
                for (VoiceAccountRuntime accountRuntime : accountList) {
                    this.loadTariffs(connection, treeSetDao, accountRuntime);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public VoiceAccountRuntime findByPort(String port, Date time) {
        return (VoiceAccountRuntime)((Object)this.portMap.get((Object)port, (Comparable)Long.valueOf(time.getTime())));
    }

    static final class DeviceNumber {
        final int deviceId;
        final long number;

        public DeviceNumber(int deviceId, long number) {
            this.deviceId = deviceId;
            this.number = number;
        }

        public DeviceNumber(VoiceAccount account) {
            this(account.getDeviceId(), account.getNumber());
        }

        public int hashCode() {
            return (int)((long)(31 * (31 + this.deviceId)) + this.number);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            DeviceNumber other = (DeviceNumber)obj;
            return this.deviceId == other.deviceId && this.number == other.number;
        }
    }
}

