/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.dba.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.dba.server.bean.TableConfigItem;
import ru.bitel.bgbilling.modules.dba.server.bean.TableConfigManager;
import ru.bitel.bgbilling.modules.dba.server.bean.TableRefManager;
import ru.bitel.common.XMLUtils;

public class ActionTableConfigTree
extends ActionBase {
    public void doAction() throws Exception {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        TableRefManager tableRefManager = new TableRefManager();
        TableConfigManager tableConfigManager = new TableConfigManager(this.con, this.mid);
        Element tableRef = this.createElement(this.rootNode, "table_ref");
        Map<String, Document> docMap = tableRefManager.getModulesDocMap();
        ArrayList<BGModule> moduleList = new ArrayList<BGModule>();
        moduleList.addAll(ModuleCache.getInstance().getModulesList());
        BGModule kernelModule = new BGModule();
        kernelModule.setId(0);
        kernelModule.setTitle("\u042f\u0434\u0440\u043e");
        kernelModule.setName("kernel");
        moduleList.add(0, kernelModule);
        for (BGModule module : moduleList) {
            int mid = module.getId();
            String title = module.getTitle();
            Element moduleEl = this.rootNode.getOwnerDocument().createElement("module");
            moduleEl.setAttribute("id", String.valueOf(mid));
            moduleEl.setAttribute("title", title);
            Document doc = docMap.get(module.getName());
            if (doc == null) continue;
            Element data = XMLUtils.getElement((Document)doc, (String)"data");
            NodeList childs = data.getChildNodes();
            int size = childs.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = childs.item(i);
                moduleEl.appendChild(moduleEl.getOwnerDocument().importNode(child, true));
            }
            tableRef.appendChild(moduleEl);
        }
        Element config = this.createElement(this.rootNode, "table_conf");
        List<TableConfigItem> itemList = tableConfigManager.getConfigItemList();
        for (TableConfigItem item : itemList) {
            Element itemEl = this.createElement(config, "item");
            itemEl.setAttribute("mid", String.valueOf(item.getModuleId()));
            itemEl.setAttribute("tid", String.valueOf(item.getTableId()));
            itemEl.setAttribute("data", item.getData());
        }
    }
}

