/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.enaza.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.enaza.common.bean.EnazaTransaction;
import ru.bitel.common.TimeUtils;

public class EnazaTransactionDao {
    private Connection con;
    private String tableName;

    public EnazaTransactionDao(Connection con, int mid) {
        this.con = con;
        this.tableName = "enaza_transaction_" + mid;
    }

    public EnazaTransaction get(long orderId) throws BGException {
        EnazaTransaction result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE order_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, orderId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private EnazaTransaction getFromRS(ResultSet rs) throws SQLException {
        EnazaTransaction transaction = new EnazaTransaction();
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setAmount(rs.getBigDecimal("amount"));
        transaction.setContractGroupId(rs.getBigDecimal("contract_group_id"));
        transaction.setDescription(rs.getString("descr"));
        transaction.setServiceId(rs.getString("service_id"));
        transaction.setVat(rs.getInt("vat"));
        transaction.setProductType(rs.getBigDecimal("product_type"));
        transaction.setPriceCategory(rs.getBigDecimal("price_category"));
        transaction.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dt")));
        transaction.setChargeId(rs.getInt("charge_id"));
        transaction.setStatus(rs.getInt("status"));
        transaction.setOrderId(rs.getBigDecimal("order_id"));
        return transaction;
    }

    public void update(EnazaTransaction enazaTransaction) throws BGException {
        String setFields = " SET contract_id=?, amount=?, contract_group_id=?, descr=?, service_id=?, vat=?, product_type=?, price_category=?, dt=?, charge_id=?, status=?";
        try {
            String query = "UPDATE " + this.tableName + setFields + " WHERE order_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            this.setPsParams(enazaTransaction, ps);
            boolean needInsert = ps.executeUpdate() == 0;
            ps.close();
            if (needInsert) {
                query = "INSERT INTO " + this.tableName + setFields + ", order_id=?";
                ps = this.con.prepareStatement(query);
                this.setPsParams(enazaTransaction, ps);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void setPsParams(EnazaTransaction enazaTransaction, PreparedStatement ps) throws SQLException {
        int index = 1;
        ps.setInt(index++, enazaTransaction.getContractId());
        ps.setBigDecimal(index++, enazaTransaction.getAmount());
        ps.setBigDecimal(index++, enazaTransaction.getContractGroupId());
        ps.setString(index++, enazaTransaction.getDescription());
        ps.setString(index++, enazaTransaction.getServiceId());
        ps.setInt(index++, enazaTransaction.getVat());
        ps.setBigDecimal(index++, enazaTransaction.getProductType());
        ps.setBigDecimal(index++, enazaTransaction.getPriceCategory());
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)enazaTransaction.getDate()));
        ps.setInt(index++, enazaTransaction.getChargeId());
        ps.setInt(index++, enazaTransaction.getStatus());
        ps.setBigDecimal(index++, enazaTransaction.getOrderId());
    }

    public void deleteForContract(int contractId) throws BGException {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE contract_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<EnazaTransaction> getList(int cid) throws BGException {
        ArrayList<EnazaTransaction> result = new ArrayList<EnazaTransaction>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE contract_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                EnazaTransaction enazaTransaction = this.getFromRS(rs);
                result.add(enazaTransaction);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

