/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeTemplateEditPanel;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.common.templates.CustomTemplate;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.SearchResult;

public class DynamicCodeTemplatePanel
extends BGUTabPanel {
    private BGUTable templateTable;
    protected CustomTemplateTableModel model;
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages page = new BGControlPanelPages();
    protected DynamicCodeTemplateEditPanel templateEditPanel;
    protected JPanel tablePanel;
    protected DynamicCodeService dynCodeService;

    public DynamicCodeTemplatePanel(ClientContext clientContext) {
        super(clientContext);
        this.dynCodeService = (DynamicCodeService)clientContext.getPort(DynamicCodeService.class);
        this.page.setKey(((Object)((Object)this)).getClass().getName());
    }

    protected void jbInit() {
        this.model = new CustomTemplateTableModel();
        this.templateTable = new BGUTable((TableModel)((Object)this.model));
        this.templateTable.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)this.templateTable, (BGUPanel)this, (String)"edit");
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, new Insets(3, 0, 0, 0), 0, 0));
        this.tablePanel.add((Component)new JScrollPane((Component)this.templateTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.templateEditPanel = new DynamicCodeTemplateEditPanel(this);
        this.templateEditPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add(this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.templateEditPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.performAction("refresh");
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addToHandler(a -> this.performAction("refresh"));
        JPanel pagePanel = new JPanel(new GridBagLayout());
        pagePanel.add((Component)this.recordCountLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        pagePanel.add((Component)this.page, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 3), 0, 0));
        return pagePanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult<CustomTemplate> customTemplateResult = this.dynCodeService.getTemplateList(this.page.getPage());
            this.model.setData(customTemplateResult.getList());
            this.page.setPage(customTemplateResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + customTemplateResult.getPage().getRecordCount());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.templateEditPanel.fillPanelEditor(null));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (this.model.getSelectedRow() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435");
                return;
            }
            this.templateEditPanel.fillPanelEditor((CustomTemplate)((Object)((Object)this.model.getSelectedRow())));
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            CustomTemplate template = (CustomTemplate)((Object)((Object)this.model.getSelectedRow()));
            if (template == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435");
                return;
            }
            if (ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430")) {
                this.dynCodeService.deleteTemplate(template.getId());
                this.performAction("refresh");
            }
        });
    }

    protected JPanel getTablePanel() {
        return this.tablePanel;
    }

    class CustomTemplateTableModel
    extends BGTableModel<CustomTemplate> {
        private Directory<UserInfo> userDirectory;

        public CustomTemplateTableModel() {
            super(CustomTemplateTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 200, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 200, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435", 100, 100, 100, "extension", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Column.DateTime.class, 170, 170, 170, "createDate", true);
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", Column.DateTime.class, 170, 170, 170, "lastModificationDate", true);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 120, 150, 200, "user", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(CustomTemplate template, int column) throws Exception {
            switch (column) {
                case 6: {
                    UserInfo user = this.getUserDirectory().get(template.getUserId());
                    return user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
            }
            return super.getValue((Object)template, column);
        }

        private Directory<UserInfo> getUserDirectory() {
            if (this.userDirectory == null) {
                try {
                    this.userDirectory = ((ClientContext)DynamicCodeTemplatePanel.this.getContext()).getDirectory(UserInfo.class, 0);
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            return this.userDirectory;
        }
    }
}

