/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.dashboard.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.dashboard.common.bean.DashboardItem;
import ru.bitel.bgbilling.kernel.contract.dashboard.common.bean.DashboardItemType;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.WebAmountToBePaidEvent;
import ru.bitel.common.Utils;

public class ActionDashboard
extends AbstractAction {
    public ActionDashboard() {
        super("contract");
    }

    @Override
    public void execute() throws BGException {
        this.setResultParam("contentType", (Object)ActionResultContentType.jsp);
        this.setResultParam("jspPage", "contract/dashboard.jsp");
    }

    public void paths() throws BGException {
        this.requestDispatcher(this.moduleName, "dashboard_paths");
    }

    public void list() throws BGException {
        ArrayList<DashboardItem> dashboardPaths = new ArrayList<DashboardItem>();
        String key = this.context.getRequest().getParameter("key");
        if (key != null && !"group0".equals(key)) {
            List dashboardItems = (List)this.context.getRequest().getAttribute("dashboardItems");
            this.setResultParam("dashboardItems", this.getListForKey(dashboardItems, "group0", key));
            this.getDashboardPaths(dashboardItems, key, dashboardPaths);
        }
        DashboardItem dashboardItem = DashboardItem.builder().setTitle("\u0413\u041b\u0410\u0412\u041d\u0410\u042f").setKey("group0").build();
        dashboardPaths.add(0, dashboardItem);
        this.context.getRequest().getSession().setAttribute("dashboardPaths", dashboardPaths);
        this.balance();
        BigDecimal ammountToBePaid = BigDecimal.ZERO;
        WebAmountToBePaidEvent event = new WebAmountToBePaidEvent(this.contractId, ammountToBePaid);
        EventProcessor.getInstance().request(event);
        this.setResultParam("ammountToBePaid", event.getAmount());
        Optional.ofNullable(this.setup.get("web.payment.external.url", null)).ifPresent(a -> this.setResultParam("extPaymentUrl", a));
        this.requestDispatcher(this.moduleName, "dashboard_list");
    }

    private boolean getDashboardPaths(List<DashboardItem> dashboardItems, String key, List<DashboardItem> dashboardPaths) {
        for (DashboardItem dashboardItem : dashboardItems) {
            if (key.equals(dashboardItem.getKey())) {
                dashboardPaths.add(0, dashboardItem);
                return true;
            }
            if (dashboardItem.getItemType() != DashboardItemType.FOLDER || !this.getDashboardPaths(dashboardItem.getSubItems(), key, dashboardPaths)) continue;
            dashboardPaths.add(0, dashboardItem);
            return true;
        }
        return false;
    }

    private List<DashboardItem> getListForKey(List<DashboardItem> dashboardItems, String parentKey, String key) {
        for (DashboardItem dashboardItem : dashboardItems) {
            List<DashboardItem> list;
            if (key.equals(dashboardItem.getKey())) {
                if (parentKey != null) {
                    this.setResultParam("dashboardParentGroupKey", parentKey);
                }
                return dashboardItem.getSubItems();
            }
            if (dashboardItem.getItemType() != DashboardItemType.FOLDER || (list = this.getListForKey(dashboardItem.getSubItems(), dashboardItem.getKey(), key)) == null) continue;
            return list;
        }
        return null;
    }

    private void balance() throws BGException {
        ConvergenceBalanceManager convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
        ConvergenceBalance convergenceBalance = convergenceBalanceManager.getBalance(this.context.getConnectionSet(), this.contractId, System.currentTimeMillis());
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        String acceptLanguage = this.context.getRequest().getHeader("Accept-Language");
        if (Utils.notBlankString((String)acceptLanguage)) {
            locale = new Locale(acceptLanguage.split(",")[0].split(";")[0].split("-")[0]);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        this.setResultParam("balanceSum", numberFormat.format(convergenceBalance.getBalance()));
    }
}

