/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.paycashshopservice;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.soap.SOAPFaultException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.Connection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mobimoney.common.paycashshopservice.PaycashShop;
import ru.bitel.bgbilling.modules.mobimoney.common.service.MobiService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.XMLUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mobimoney.common.paycashshopservice.PaycashShop")
public class MobiMoneyWSImpl
extends AbstractService
implements PaycashShop {
    private MobiService service;

    @PostConstruct
    public void init() throws BGException {
        try {
            this.service = (MobiService)this.context.newService(MobiService.class, this.moduleId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void paymentContract(String paymentId, String account, int currency, XMLGregorianCalendar paymentTime, String payerAddress, String shopParams, String userParams, boolean demo, Holder<Float> sum, Holder<String> payeeRegData, Holder<String> contract, Holder<Integer> paymentDelay) {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Connected with Mobi.Money (paymentContract method)...");
                this.getLogger().debug("Parsing incoming params: " + userParams);
            }
            Map<String, String> incomingParams = this.parseParams(URLDecoder.decode(userParams, "UTF-8"));
            if (System.getProperty("mobiMoneyDebug") != null) {
                System.out.println("userParams = " + userParams);
                for (Map.Entry<String, String> entry : incomingParams.entrySet()) {
                    System.out.println("\t" + entry.getKey() + " = " + entry.getValue());
                }
            }
            if (incomingParams.containsKey("sum") && incomingParams.containsKey("account")) {
                int contractId = this.service.checkContract(incomingParams.get("account"));
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Find contract with id=" + contractId);
                }
                if (contractId > 0) {
                    if (!this.service.checkPayment(contractId, paymentId)) {
                        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setTransactionId(paymentId)).setStatus(TransactionStatus.INCOMPLETE.getCode())).setSum(new BigDecimal(incomingParams.get("sum")))).build();
                        this.service.updateTransaction(transaction);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Created new transaction with id=" + transaction.getId());
                        }
                        sum.value = Float.valueOf(transaction.getSum().floatValue());
                        contract.value = this.getXMLAnswer(incomingParams, "contract");
                        paymentDelay.value = 0;
                        payeeRegData.value = "";
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Sending answer to Mobi.Money");
                            this.getLogger().debug("Sum: " + String.valueOf(sum.value));
                            this.getLogger().debug("Contract: " + (String)contract.value);
                            this.getLogger().debug("PaymentDelay: " + String.valueOf(paymentDelay.value));
                            this.getLogger().debug("PayeeRegData: " + (String)payeeRegData.value);
                        }
                    } else {
                        this.getLogger().error("Found transaction with the same creation date");
                        this.throwSOAPException("already_paid", "\u041a\u043e\u043d\u0442\u0440\u0430\u043a\u0442 \u0443\u0436\u0435 \u043e\u043f\u043b\u0430\u0447\u0435\u043d");
                    }
                } else {
                    this.getLogger().error("Incorrect incoming client parameters!");
                    this.throwSOAPException("incorrect_request", "\u041a\u043b\u0438\u0435\u043d\u0442 \u0443\u043a\u0430\u0437\u0430\u043b \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
                }
            }
        }
        catch (BGException ex) {
            this.logError(ex);
            this.throwSOAPException("error", "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public void paymentAuthorization(String paymentId, String payeeRegData1, Holder<String> payeeRegDataEx, XMLGregorianCalendar paymentTime, int currency, float sum, float creditSum, String account, float accountEstimatedSum, String payerAccount, XMLGregorianCalendar authorizationTime, boolean isRepeat, String shopParams, boolean demo, Holder<String> replyResource, Holder<Boolean> replyResourceIsFailure, Holder<XMLGregorianCalendar> shopTime) {
        block12: {
            try {
                Transaction transaction;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Connected with Mobi.Money (paymentAuthorization method)...");
                    this.getLogger().debug("Found transaction with id=" + paymentId);
                }
                if ((transaction = this.service.getTransaction(paymentId)).getId() > 0 && transaction.getStatus().equals(TransactionStatus.INCOMPLETE.getCode())) {
                    transaction.setStatus(TransactionStatus.COMPLETED.getCode());
                    transaction.setTransactionDate(new Date());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Updating transaction...");
                    }
                    this.service.updateTransaction(transaction);
                    HashMap<String, String> incomingParams = new HashMap<String, String>();
                    incomingParams.put("account", transaction.getContractTitle());
                    incomingParams.put("sum", String.valueOf(sum));
                    replyResource.value = this.getXMLAnswer(incomingParams, "success");
                    replyResourceIsFailure.value = false;
                    shopTime.value = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                    Payment payment = Payment.builder().setDate(transaction.getTransactionDate()).setTypeId(this.getModuleSetup().getInt("mobimoney.payment.type.id", -1)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.getModuleSetup().get("mobimoney.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 MobiMoney [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
                    new PaymentDao(this.getConnection()).update((Object)payment);
                    ServerUtils.commitConnection((Connection)this.getConnection());
                    try (BalanceUtils balanceUtils = new BalanceUtils(this.getConnection());){
                        balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                    }
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    break block12;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Transaction id=" + paymentId + " not found!");
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                this.throwSOAPException("error", "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
            }
        }
    }

    public void paymentCancellation(String paymentID, int paymentResult, String paymentResultStr, String payeeRegData, String payeeRegDataEx, String shopParams, boolean demo) {
        try {
            Transaction transaction;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Connected with Mobi.Money (paymentCancellation method)...");
            }
            if ((transaction = this.service.getTransaction(paymentID)).getId() > 0 && transaction.getStatus().equals(TransactionStatus.INCOMPLETE.getCode())) {
                transaction.setStatus(TransactionStatus.CANCELLED.getCode());
                this.service.updateTransaction(transaction);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Transaction cancelled ( code= " + paymentResult + " - " + paymentResultStr + ")");
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            this.throwSOAPException("error", "\u0422\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
        }
    }

    public void arbitraryMessage(String messageType, String message, String shopParams, Holder<String> responseMessage) {
    }

    public void paymentsConfirmation(String approvalResult, String registerID, String payments, String shopParams) {
    }

    private Map<String, String> parseParams(String shopParams) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] params = shopParams.split("&");
        if (params.length > 0) {
            for (String str : params) {
                String[] paramsParts = str.split("=");
                if (paramsParts.length != 2) continue;
                result.put(paramsParts[0], paramsParts[1]);
            }
        }
        return result;
    }

    public String getXMLAnswer(Map<String, String> incomingParams, String rootName) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element rootElement = doc.createElement(rootName);
        doc.appendChild(rootElement);
        Element element = XMLUtils.createElement((Element)rootElement, (String)"param");
        element.setAttribute("id", "account");
        element.setAttribute("ref", "account");
        element.setAttribute("label", "\u041d\u043e\u043c\u0435\u0440 \u043b\u0438\u0446\u0435\u0432\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430");
        element.setTextContent(incomingParams.get("account"));
        element = XMLUtils.createElement((Element)rootElement, (String)"param");
        element.setAttribute("id", "sum");
        element.setAttribute("ref", "sum");
        element.setAttribute("label", "\u0421\u0443\u043c\u043c\u0430");
        element.setTextContent(incomingParams.get("sum"));
        return XMLUtils.serializeToString((Node)doc, (boolean)false);
    }

    private void throwSOAPException(String faultcode, String faultstring) {
        try {
            Document doc = XMLUtils.newDocument();
            Element rootElement = doc.createElement("error");
            doc.appendChild(rootElement);
            Element element = XMLUtils.createElement((Element)rootElement, (String)"param");
            element.setAttribute("id", "errorCode");
            element.setAttribute("label", "\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438");
            element.setTextContent(faultcode);
            element = XMLUtils.createElement((Element)rootElement, (String)"param");
            element.setAttribute("id", "errorDescr");
            element.setAttribute("label", "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
            element.setTextContent(faultstring);
            SOAPFault fault = SOAPFactory.newInstance().createFault();
            fault.setFaultCode(faultcode);
            fault.setFaultString(XMLUtils.serializeToString((Node)doc, (boolean)false));
            throw new SOAPFaultException(fault);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem at service-side!");
        }
    }
}

