/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.jws.WebService;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostGroupService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostGroupDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostGroupService")
public class ForpostGroupServiceImpl
extends AbstractService
implements ForpostGroupService {
    public SearchResult<ForpostTMCAO<ForpostGroup>> searchForpostGroups(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setSort(sort);
        try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
            forpostGroupDao.searchForpostGroups((SearchResult<ForpostTMCAO<ForpostGroup>>)searchResult);
        }
        return searchResult;
    }

    public SearchResult<ForpostGroup> searchForpostAccountGroups(int accountId) throws BGException {
        SearchResult searchResult = new SearchResult();
        try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
            forpostGroupDao.searchForpostAccountGroups((SearchResult<ForpostGroup>)searchResult, accountId);
        }
        return searchResult;
    }

    public void doSync() throws BGException {
        if ("test".equals(this.getModuleSetup().get("forpost.mode", ""))) {
            throw new BGMessageException("\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c, \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u0441\u044f");
        }
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
             ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            for (int accountId : forpostAccountDao.getIds()) {
                forpostGroupDao.doSync(accountId, forpostManager.getAccountGroups(null, null, accountId, null, null, null));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void doSyncForpostGroups(int accountId) throws BGException {
    }

    public ForpostGroup getDefaultForpostGroup() throws BGException {
        return new ForpostGroup();
    }

    public int addForpostGroup(ForpostGroup forpostGroup) throws BGException, BGMessageException {
        int n;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Name", forpostGroup.getName());
        params.put("AccountID", String.valueOf(forpostGroup.getAccountId()));
        if (forpostGroup.getParentId() > 0) {
            params.put("ParentID", String.valueOf(forpostGroup.getParentId()));
        }
        ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);
        try {
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addAccountGroup(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int groupId = responseId.getId();
            for (ForpostGroup remoteForpostGroup : new ForpostManager(this.moduleId).getAccountGroups(groupId, null, null, null, null, null)) {
                if (groupId != remoteForpostGroup.getId()) continue;
                remoteForpostGroup.setId(groupId);
                remoteForpostGroup.setParentId(forpostGroup.getParentId());
                remoteForpostGroup.setName(forpostGroup.getName());
                forpostGroup = remoteForpostGroup;
            }
            forpostGroupDao.update(forpostGroup);
            n = groupId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostGroupDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostGroupDao.close();
        return n;
    }

    public void updateForpostGroup(ForpostGroup forpostGroup) throws BGException, BGMessageException {
    }

    public void updateForpostGroupParam(int forpostGroupId, String name, String value) throws BGException, BGMessageException {
        try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
            ForpostGroup forpostGroup = forpostGroupDao.getForpostGroup(forpostGroupId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostGroup.getId()));
            params.put(name, value);
            switch (name) {
                case "Name": {
                    forpostGroup.setName(value);
                    break;
                }
                case "ParentID": {
                    forpostGroup.setParentId(Utils.parseInt((String)value));
                    break;
                }
                default: {
                    forpostGroup.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editAccountGroup(forpostGroup.getId(), forpostGroup.getName(), forpostGroup.getParentId());
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostGroupDao.update(forpostGroup);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void deleteForpostGroup(int id) throws BGException, BGMessageException {
        try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteAccountGroup(id);
            if (responseStatus.getErrorCode() > 0) {
                if (responseStatus.getErrorCode() == 1) {
                    // empty if block
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostGroupDao.deleteForpostGroup(id);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteForpostAccountGroups(int accountId) throws BGException, BGMessageException {
    }
}

