/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.voice;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.tariff.voice.ServiceConfigGeographicCode;
import bitel.billing.module.tariff.voice.table.CodeModel;
import bitel.billing.module.tariff.voice.table.CodeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class CodeEditor
extends JPanel {
    private ServiceConfigGeographicCode panel;
    private BGIntTextField codeField = new BGIntTextField();
    private BGComboBox<ComboBoxItem> destCombo = new BGComboBox();
    private BGTextField destField = new BGTextField();
    private BGIntTextField startLevel = new BGIntTextField();
    private BGIntTextField endLevel = new BGIntTextField();
    private boolean dirListActual = false;
    private CodeNode node;

    public CodeEditor(ServiceConfigGeographicCode codeEditor) {
        this.panel = codeEditor;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.startLevel.setMinValue(0L);
        this.startLevel.setMaxValue(100L);
        this.endLevel.setMinValue(0L);
        this.endLevel.setMaxValue(100L);
        this.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.add((Component)new JLabel("\u041a\u043e\u0434:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.codeField, new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u041d\u0430\u0447. \u0443\u0440\u043e\u0432\u0435\u043d\u044c:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.startLevel, new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("\u041a\u043e\u043d. \u0443\u0440\u043e\u0432\u0435\u043d\u044c:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.endLevel, new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        JButton createDestButton = new JButton("+");
        createDestButton.setMargin(new Insets(2, 5, 2, 5));
        createDestButton.setToolTipText("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
        this.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.destCombo, new GridBagConstraints(3, 0, 2, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u0421\u043e\u0437\u0434. \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.destField, new GridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)createDestButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.destCombo.setPreferredSize(new Dimension(300, 24));
        createDestButton.addActionListener(e -> this.createDest());
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.add((Component)okCancel, new GridBagConstraints(0, 3, 6, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 5, 5), 0, 0));
    }

    public void startEdit(CodeNode node) {
        this.node = node;
        try {
            if (!this.dirListActual) {
                this.panel.loadDest(this.destCombo);
                this.dirListActual = true;
            }
            this.codeField.setText("");
            this.startLevel.setText("");
            this.endLevel.setText("");
            this.codeField.setEnabled(true);
            if (node != null) {
                this.codeField.setEnabled(false);
                ClientUtils.setComboBoxSelection(this.destCombo, String.valueOf(node.destId));
                this.startLevel.setText(node.levelStart);
                this.endLevel.setText(node.levelEnd);
                this.codeField.setText(node.prefix);
            }
            this.setVisible(true);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void createDest() {
        String title = this.destField.getText();
        if (Utils.isBlankString(title)) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            return;
        }
        try {
            this.panel.createDest(title, this.destCombo);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        }
    }

    private void stopEdit(boolean save) {
        if (save) {
            CodeNode node;
            ComboBoxItem item = this.destCombo.getSelectedItem();
            if (item == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435!");
                return;
            }
            String code = this.codeField.getText();
            int destId = Utils.parseInt((String)item.getObject());
            String title = item.toString();
            if (Utils.isBlankString(code)) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d \u043f\u0440\u0435\u0444\u0438\u043a\u0441");
                return;
            }
            CodeNode parentNode = null;
            CodeModel model = (CodeModel)this.panel.getTree().getTree().getModel();
            if (this.node == null) {
                parentNode = ((CodeNode)model.getRoot()).findParentNode(code);
            }
            if ((node = this.node) == null) {
                node = new CodeNode();
            }
            if (Utils.notBlankString(this.startLevel.getText()) ^ Utils.notBlankString(this.endLevel.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0438\u0431\u043e \u043e\u0431\u0430 \u0443\u0440\u043e\u0432\u043d\u044f \u043b\u0438\u0431\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e!");
                return;
            }
            node.prefix = code;
            node.destId = destId;
            node.dest = title;
            node.levelStart = this.startLevel.getText();
            node.levelEnd = this.endLevel.getText();
            if (this.panel.updateCode(node) && this.node == null) {
                parentNode.insertCodeNode(node);
                TreePath path = new TreePath(node.getPath());
                this.panel.getTree().getTree().expandPath(path);
                this.panel.getTree().getTree().setSelectionPath(path);
                this.panel.getTree().repaint();
            }
            this.panel.getTree().updateUI();
        }
        this.setVisible(false);
    }
}

