/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResource;

public class VlanResourceDao
extends AbstractIdDao<VlanResource> {
    public VlanResourceDao(Connection con, int moduleId) {
        super(con, moduleId, "inv_vlan_resource");
    }

    protected VlanResource getFromRS(ResultSet rs) throws SQLException {
        VlanResource result = new VlanResource();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setVlanFrom(rs.getInt("vlanFrom"));
        result.setVlanTo(rs.getInt("vlanTo"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setComment(rs.getString("comment"));
        result.setCategoryId(rs.getInt("categoryId"));
        return result;
    }

    protected void updateImpl(VlanResource vlanResource) throws SQLException {
        if (vlanResource.getVlanTo() < 0 || vlanResource.getVlanFrom() < 0 || vlanResource.getVlanTo() < vlanResource.getVlanFrom() || Utils.isBlankString((String)vlanResource.getTitle())) {
            throw new BGRuntimeException();
        }
        String querySet = "title=?, vlanFrom=?, vlanTo=?, dateFrom=?, dateTo=?, comment=?, categoryId=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)vlanResource, querySet);){
            int index = 1;
            ps.setString(index++, vlanResource.getTitle());
            ps.setInt(index++, vlanResource.getVlanFrom());
            ps.setInt(index++, vlanResource.getVlanTo());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)vlanResource.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)vlanResource.getDateTo()));
            ps.setString(index++, vlanResource.getComment());
            ps.setInt(index++, vlanResource.getCategoryId());
            this.executeUpdate((Id)vlanResource, index, ps);
        }
    }

    public List<VlanResource> list() throws SQLException {
        return this.list(null, "id", new Object[0]);
    }

    public List<VlanResource> list(int categoryId) throws SQLException {
        return this.list("categoryId=?", "id", new Object[]{categoryId});
    }

    public List<VlanResource> list(Set<Integer> categoryIds) throws SQLException {
        if (categoryIds.size() == 0) {
            return new ArrayList<VlanResource>();
        }
        return this.list("categoryId IN (" + Utils.toString(categoryIds) + ")", "id", new Object[0]);
    }

    public List<VlanResource> list(Set<Integer> categoryIds, Date dateFrom, Date dateTo) throws SQLException {
        if (categoryIds.size() == 0) {
            return new ArrayList<VlanResource>();
        }
        String filter = "categoryId IN (" + Utils.toString(categoryIds) + ") ";
        if (dateFrom != null) {
            filter = filter + " AND (dateFrom is NULL or dateFrom <= ?)";
        }
        if (dateTo != null) {
            filter = filter + " AND (dateTo is NULL or dateTo >= ?)";
        }
        if (dateFrom == null && dateTo == null) {
            return this.list(filter, "id", new Object[0]);
        }
        if (dateFrom != null && dateTo == null) {
            return this.list(filter, "id", new Object[]{dateFrom});
        }
        if (dateFrom == null && dateTo != null) {
            return this.list(filter, "id", new Object[]{dateTo});
        }
        return this.list(filter, "id", new Object[]{dateFrom, dateTo});
    }
}

