/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.vepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vepay.common.service.VepayService;
import ru.bitel.bgbilling.modules.vepay.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.vepay.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.vepay.server.event.VepayAutopaymentEvent;
import ru.bitel.bgbilling.modules.vepay.server.event.VepayCheckEvent;
import ru.bitel.bgbilling.modules.vepay.server.event.VepaySumEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.vepay.common.service.VepayService")
public class VepayServiceImpl
extends AbstractService
implements VepayService {
    @Resource
    private ContractAutopaymentService contractAutopaymentService;
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws Exception {
        SearchResult transactionSearchResult = new SearchResult(searchParam.getPeriod(), searchParam.getPage(), searchParam.getSort());
        this.manager.searchTransaction(transactionSearchResult, searchParam);
        return transactionSearchResult;
    }

    public void checkTransactions(int contractId) throws Exception {
    }

    public Autopayment autopaymentGet(int contractId) throws BGException {
        return (Autopayment)this.tryReturn(() -> new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId));
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException {
        this.beginAutopaymentTransaction(contractId, amount, url, mode, paramsHolder, null);
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder, ContractAutopaymentMode autopaymentMode) throws BGException {
        this.tryCall(() -> {
            if (contractId <= 0 && this.moduleId <= 0) {
                throw new BGIllegalArgumentException();
            }
            BigDecimal sum = Optional.ofNullable(amount).map(a -> a.setScale(2, RoundingMode.HALF_EVEN)).orElse(null);
            if (sum == null || sum.compareTo(BigDecimal.ZERO) <= 0) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
            }
            if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
                throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.", "contractModule.notEnabled");
            }
            if (mode != null) {
                mode.value = "redirect";
            }
            ModuleSetup moduleSetup = this.getModuleSetup();
            VepaySumEvent event = new VepaySumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((VepaySumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
            if (autopaymentMode == null) {
                BigDecimal sumMin = moduleSetup.getBigDecimal("vepay.sum.min", new BigDecimal(100));
                BigDecimal sumMax = moduleSetup.getBigDecimal("vepay.sum.max", new BigDecimal(5000));
                if (sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                    throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
                }
            }
            Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
            String successUrl = (String)params.get("successUrl");
            String failureUrl = (String)params.get("failureUrl");
            if (Utils.isBlankString((String)successUrl)) {
                successUrl = moduleSetup.get("vepay.url.success", "");
            }
            if (Utils.isBlankString((String)failureUrl)) {
                failureUrl = moduleSetup.get("vepay.url.fail", "");
            }
            int autopaymentId = 0;
            if (autopaymentMode != null) {
                Autopayment autopayment;
                if (autopaymentMode.getMode() != AutopaymentMode.OFF) {
                    this.contractAutopaymentService.contractAutopaymentModeCheck(contractId, autopaymentMode);
                }
                if ((autopayment = AutopaymentManager.registerAutopayment((Connection)this.getConnection(), (int)this.moduleId, (AbstractAutopaymentManager)new AutopaymentManager(this.getConnection(), this.moduleId), (int)contractId, (ContractAutopaymentMode)autopaymentMode, null)) != null && autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentId = autopayment.getId();
                }
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
            String description = "";
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(contractId));
            description = moduleSetup.get("vepay.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractRuntime.getContractTitle());
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(new Date())).setParameters(autopaymentId > 0 ? "autopaymentId=" + autopaymentId : null)).build();
            transactionManager.update(transaction);
            dataMap.put("redirectURL", transactionManager.doPaymentRequest(transaction, sum, description, successUrl, failureUrl, autopaymentId > 0));
            url.value = Optional.ofNullable(dataMap.get("redirectURL")).map(a -> String.valueOf(a)).orElse(null);
            if (paramsHolder != null) {
                paramsHolder.value = new MapHolder(dataMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> String.valueOf(e.getValue()))));
            }
        });
    }

    public void autopaymentDeactivate(int contractId) throws BGException {
        this.tryCall(() -> AutopaymentManager.unregisterAutopayment((Connection)this.getConnection(), (int)contractId, (AbstractAutopaymentManager)new AutopaymentManager(this.getConnection(), this.moduleId), (int)contractId));
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
        this.getLogger().debug("endTransaction");
        EventProcessor.getInstance().publish((Event)new VepayCheckEvent(this.moduleId, 0));
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("doManualAutopayment [contractId = {}, sum = {}]", (Object)contractId, (Object)sum);
        }
        if (contractId > 0) {
            this.tryCall(() -> {
                Autopayment autopayment = new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("autopayment = {}", (Object)autopayment);
                    this.getLogger().debug("autopayment.getMode() = {}", (Object)autopayment.getMode());
                }
                if (autopayment != null && autopayment.getMode() == AutopaymentMode.AUTO && sum != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Publish VepayAutopaymentEvent [moduleId = {}, contractId = {}, sum = {}]", new Object[]{this.moduleId, contractId, sum});
                    }
                    EventProcessor.getInstance().publish((Event)new VepayAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO, sum));
                }
            });
        }
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return null;
    }
}

