/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class VoiceOperatorDao
extends AbstractIdDao<VoiceOperator> {
    private static final String TABLE_OPERATOR = "voice_operator";

    public VoiceOperatorDao(Connection con, int moduleId) {
        super(con, moduleId, TABLE_OPERATOR);
    }

    protected VoiceOperator getFromRS(ResultSet rs) throws SQLException {
        VoiceOperator result = new VoiceOperator();
        result.setId(rs.getInt("operator.id"));
        result.setTitle(rs.getString("operator.title"));
        result.setContractId(rs.getInt("operator.contractId"));
        result.setContractTitle(rs.getString("contract.title"));
        result.setComment(rs.getString("operator.comment"));
        result.setUseCustomGeoDict(rs.getBoolean("useCustomGeoDict"));
        return result;
    }

    protected void updateImpl(VoiceOperator voiceOperator) throws SQLException {
        String querySet = "title=?, contractId=?, comment=?, useCustomGeoDict=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)voiceOperator, querySet);){
            int index = 1;
            ps.setString(index++, voiceOperator.getTitle());
            ps.setInt(index++, voiceOperator.getContractId());
            ps.setString(index++, voiceOperator.getComment());
            ps.setBoolean(index++, voiceOperator.isUseCustomGeoDict());
            this.executeUpdate((Id)voiceOperator, index, ps);
        }
        catch (SQLException ex) {
            int errorCode = ex.getErrorCode();
            if (errorCode == 1062) {
                throw new BGRuntimeException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c/\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c, \u0442.\u043a. \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + voiceOperator.getContractId() + ". \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u043c\u0435\u043d\u044f\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
            }
            throw new SQLException(ex);
        }
    }

    public List<VoiceOperator> list() throws SQLException {
        ArrayList<VoiceOperator> result = new ArrayList<VoiceOperator>();
        String query = "SELECT operator.*, contract.title FROM " + this.tableName + " operator LEFT JOIN contract ON contract.id=operator.contractId ORDER BY operator.id";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        return result;
    }

    protected int deleteImpl(int id) throws SQLException {
        int result = 0;
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=" + id);){
            result = ps.executeUpdate();
        }
        return result;
    }

    protected VoiceOperator getImpl(int id) throws SQLException {
        VoiceOperator result = null;
        String query = "SELECT operator.*, contract.title FROM " + this.tableName + " operator LEFT JOIN contract ON contract.id=operator.contractId WHERE operator.id = " + id;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        return result;
    }
}

