/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;

public class CardActionCardManager {
    private Connection con;
    private int mid;
    private String tableName;

    public CardActionCardManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.tableName = "card_action_card_" + mid;
    }

    public void updateCards(int cardActionId, List<Long> cards) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM " + this.tableName + " WHERE action_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cardActionId);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO " + this.tableName + " (action_id, card_id) VALUES (?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cardActionId);
            for (Long card : cards) {
                ps.setLong(2, card);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Long> getCards(int cardActionId) {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "SELECT card_id FROM " + this.tableName + " WHERE action_id=? ORDER BY card_id";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cardActionId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getLong(1));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean checkCanUndo(CardAction action) {
        boolean result = false;
        try {
            String query = "SELECT COUNT(*) FROM " + this.tableName + " AS action_card INNER JOIN card_data_" + this.mid + " AS card ON action_card.card_id=card.id AND action_card.action_id=? AND card.status!=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, action.getId());
            if (action.getType() == 1) {
                ps.setInt(2, 1);
            } else {
                ps.setInt(2, 0);
            }
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) == 0;
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Float, Integer> getCostGroups(int cardAction) {
        TreeMap<Float, Integer> result = new TreeMap<Float, Integer>();
        try {
            String query = "SELECT card.summa, COUNT(*) FROM card_data_" + this.mid + " AS card INNER JOIN " + this.tableName + " AS action_card ON card.id=action_card.card_id WHERE action_card.action_id=? GROUP BY card.summa";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cardAction);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.put(Float.valueOf(rs.getFloat(1)), rs.getInt(2));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

