/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.modules.inet.common.bean.CircuitIdAdapter;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;

public class InetConnection
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6177348368541546652L;
    public static final int TYPE_NOT_FROM_START = 1;
    public static final int TYPE_SPLITTED = 2;
    public static final int TYPE_CLOSED_BY_TIMEOUT = 4;
    public static final int TYPE_DEVICE_STATE_CHANGED = 8;
    public static final int CREATED_BY_LOG_PROCESS = 16;
    public static final int TYPE_DISABLE_AT_START = 32;
    public static final int TYPE_FLOW = 256;
    public static final int TYPE_RADIUS = 512;
    public static final int TYPE_DHCPv4 = 1024;
    public static final int TYPE_DHCPv6 = 2048;
    public static final int TYPE_IP_SUBSCRIPTION = 4096;
    public static final int TYPE_RADIUSv4 = 8192;
    public static final int TYPE_RADIUSv6 = 16384;
    public static final int TYPE_RADIUS_DUAL_STACK = 25088;
    public static final int TYPE_DHCP_DUAL_STACK = 3072;
    public static final int STATUS_WAIT = 0;
    public static final int STATUS_ALIVE = 1;
    public static final int STATUS_SUSPENDED = 2;
    public static final int STATUS_CLOSED = 3;
    public static final int STATUS_FINISHED = 4;
    private int contractId;
    private int servId;
    private long id;
    private long parentConnectionId;
    private int deviceId;
    private int devicePort;
    private int agentDeviceId;
    private String acctSessionId;
    private String username;
    private String calledStationId;
    private String callingStationId;
    private Object circuitId;
    private int ipResourceId;
    private byte[] inetAddressBytes;
    private int prefixResourceId;
    private byte[] prefix;
    private short prefixLength;
    private int delegatedPrefixResourceId;
    private byte[] delegatedPrefix;
    private short delegatedPrefixLength;
    private Date connectionStart;
    private Date connectionStop;
    private List<IpNet> routeList;
    private int type;
    private int accessCode;
    private volatile short deviceState;
    private volatile Set<Integer> deviceOptions;
    private volatile int connectionStatus;

    public InetConnection() {
    }

    public InetConnection(InetSessionLog session) {
        this.setContractId(session.getContractId());
        this.setServId(session.getServId());
        this.setConnectionStart(session.getSessionStart());
        this.setId(session.getConnectionId());
        this.setParentConnectionId(session.getParentConnectionId());
        this.setDeviceId(session.getDeviceId());
        this.setDevicePort(session.getDevicePort());
        this.setAgentDeviceId(session.getAgentDeviceId());
        this.setAcctSessionId(session.getAcctSessionId());
        this.setUsername(session.getUsername());
        this.setCalledStationId(session.getCalledStationId());
        this.setCallingStationId(session.getCallingStationId());
        this.setCircuitId(session.getCircuitId());
        this.setIpResourceId(session.getIpResourceId());
        this.setInetAddressBytes(session.getInetAddressBytes());
        this.setPrefixResourceId(session.getPrefixResourceId());
        this.setPrefix(session.getPrefix());
        this.setPrefixLength(session.getPrefixLength());
        this.setDelegatedPrefixResourceId(session.getDelegatedPrefixResourceId());
        this.setDelegatedPrefix(session.getDelegatedPrefix());
        this.setDelegatedPrefixLength(session.getDelegatedPrefixLength());
        this.setRouteList(session.getRouteList());
        this.setConnectionStatus(session.getStatus());
        this.setType(session.getType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InetConnection other = (InetConnection)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    @XmlAttribute
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @XmlAttribute(name="start")
    public Date getConnectionStart() {
        return this.connectionStart;
    }

    public void setConnectionStart(Date connectionStart) {
        this.connectionStart = connectionStart;
    }

    @XmlAttribute(name="stop")
    public Date getConnectionStop() {
        return this.connectionStop;
    }

    public void setConnectionStop(Date connectionStop) {
        this.connectionStop = connectionStop;
    }

    @XmlAttribute(name="cid")
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute(name="servId")
    public int getServId() {
        return this.servId;
    }

    public void setServId(int inetServId) {
        this.servId = inetServId;
    }

    @XmlAttribute(name="parConId")
    public long getParentConnectionId() {
        return this.parentConnectionId;
    }

    public void setParentConnectionId(long parentConnectionId) {
        this.parentConnectionId = parentConnectionId;
    }

    @XmlAttribute
    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    @XmlAttribute
    public int getDevicePort() {
        return this.devicePort;
    }

    public void setDevicePort(int devicePort) {
        this.devicePort = devicePort;
    }

    @XmlAttribute
    public int getAgentDeviceId() {
        return this.agentDeviceId;
    }

    public void setAgentDeviceId(int agentDeviceId) {
        this.agentDeviceId = agentDeviceId;
    }

    @XmlAttribute(name="acctSessId")
    public String getAcctSessionId() {
        return this.acctSessionId;
    }

    public void setAcctSessionId(String acctSessionId) {
        this.acctSessionId = acctSessionId;
    }

    @XmlAttribute
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @XmlAttribute(name="cdsId")
    public String getCalledStationId() {
        return this.calledStationId;
    }

    public void setCalledStationId(String calledStationId) {
        this.calledStationId = calledStationId;
    }

    @XmlAttribute(name="cnsId")
    public String getCallingStationId() {
        return this.callingStationId;
    }

    public void setCallingStationId(String callingStationId) {
        this.callingStationId = callingStationId;
    }

    @XmlAttribute(name="crctId")
    @XmlJavaTypeAdapter(value=CircuitIdAdapter.class)
    public Object getCircuitId() {
        return this.circuitId;
    }

    public void setCircuitId(Object circuitId) {
        if (circuitId instanceof String) {
            String s = (String)circuitId;
            if (s.length() > 0) {
                try {
                    Integer i = Integer.parseInt(s);
                    this.circuitId = i;
                }
                catch (Exception ex) {
                    this.circuitId = circuitId;
                }
            } else {
                this.circuitId = null;
            }
        } else {
            this.circuitId = circuitId;
        }
    }

    @XmlAttribute(name="ipResId")
    public int getIpResourceId() {
        return this.ipResourceId;
    }

    public void setIpResourceId(int ipResourceId) {
        this.ipResourceId = ipResourceId;
    }

    @XmlAttribute(name="ip")
    public byte[] getInetAddressBytes() {
        return this.inetAddressBytes;
    }

    public void setInetAddressBytes(byte[] inetAddressBytes) {
        this.inetAddressBytes = inetAddressBytes;
    }

    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="route")})
    public List<IpNet> getRouteList() {
        return this.routeList;
    }

    public void setRouteList(List<IpNet> routeList) {
        this.routeList = routeList;
    }

    @XmlAttribute
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @XmlAttribute
    public int getAccessCode() {
        return this.accessCode;
    }

    public void setAccessCode(int accessCode) {
        this.accessCode = accessCode;
    }

    @XmlAttribute
    public int getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(int status) {
        this.connectionStatus = status;
    }

    @XmlAttribute(name="devState")
    public short getDeviceState() {
        return this.deviceState;
    }

    public void setDeviceState(short deviceState) {
        this.deviceState = deviceState;
    }

    @XmlAttribute(name="devOpts")
    public Set<Integer> getDeviceOptions() {
        return this.deviceOptions;
    }

    public void setDeviceOptions(Set<Integer> deviceOptions) {
        this.deviceOptions = deviceOptions;
    }

    public String toString() {
        return new StringBuilder(64).append("InetConnection [id=").append(this.id).append('-').append(this.parentConnectionId).append(',').append(" iface=").append(this.deviceId).append(':').append(this.devicePort).append(',').append(" sessId=").append(this.acctSessionId).append(',').append(" start=").append(TimeUtils.format((Date)this.connectionStart, (String)"dd.MM.yyyy HH:mm:ss")).append(',').append(" uname=").append(this.username).append(',').append(" addr=").append(IpAddress.toString((byte[])this.inetAddressBytes)).append(']').toString();
    }

    public static void setType(InetConnection connection, int type, boolean set) {
        connection.type = set ? (connection.type |= type) : (connection.type &= ~type);
    }

    public static boolean isType(InetConnection connection, int type) {
        return (connection.type & type) > 0;
    }

    public InetConnection clone() {
        InetConnection result;
        try {
            result = (InetConnection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.inetAddressBytes != null) {
            result.inetAddressBytes = Arrays.copyOf(this.inetAddressBytes, this.inetAddressBytes.length);
        }
        if (this.prefix != null) {
            result.prefix = Arrays.copyOf(this.prefix, this.prefix.length);
        }
        if (this.delegatedPrefix != null) {
            result.delegatedPrefix = Arrays.copyOf(this.delegatedPrefix, this.delegatedPrefix.length);
        }
        if (this.deviceOptions != null) {
            result.deviceOptions = new HashSet<Integer>(this.deviceOptions);
        }
        if (this.routeList != null) {
            result.routeList = new ArrayList<IpNet>(this.routeList);
        }
        return result;
    }

    @XmlAttribute
    public int getPrefixResourceId() {
        return this.prefixResourceId;
    }

    public void setPrefixResourceId(int prefixResourceId) {
        this.prefixResourceId = prefixResourceId;
    }

    @XmlAttribute
    public byte[] getPrefix() {
        return this.prefix;
    }

    public void setPrefix(byte[] prefix) {
        this.prefix = prefix;
    }

    @XmlAttribute
    public short getPrefixLength() {
        return this.prefixLength;
    }

    public void setPrefixLength(short prefixLength) {
        this.prefixLength = prefixLength;
    }

    @XmlAttribute
    public int getDelegatedPrefixResourceId() {
        return this.delegatedPrefixResourceId;
    }

    public void setDelegatedPrefixResourceId(int delegatedPrefixResourceId) {
        this.delegatedPrefixResourceId = delegatedPrefixResourceId;
    }

    @XmlAttribute
    public byte[] getDelegatedPrefix() {
        return this.delegatedPrefix;
    }

    public void setDelegatedPrefix(byte[] delegatedPrefix) {
        this.delegatedPrefix = delegatedPrefix;
    }

    @XmlAttribute
    public short getDelegatedPrefixLength() {
        return this.delegatedPrefixLength;
    }

    public void setDelegatedPrefixLength(short delegatedPrefixLength) {
        this.delegatedPrefixLength = delegatedPrefixLength;
    }
}

