package ru.bitel.bgbilling.modules.megogo.dyn.reports.aggregateMonthReport;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoSubscription;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport.CSVFillerDataFields;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport.ReportResult;
import ru.bitel.common.Utils;

public class MegogoAggregateMonthReport
    implements CSVFillerDataFields
{
	@Override
	public void fillReport( Connection con, BGReportFilter filter, ReportResult result, Map<String, String> fields )
	    throws Exception
	{
		Calendar date = filter.getCalendarParam( "month" );
		int year = date.get( Calendar.YEAR );
		int month = date.get( Calendar.MONTH ) + 1;
		String mid = filter.getStringParam( "mid" );
		List<Map<String, String>> data = new ArrayList<Map<String, String>>( 1000 );
		
		Map<String, String> mapWrap = new HashMap<>();
		String wrapService = filter.getStringParam( "megogo.aggregateMonthReport.wrapService" ); // 4=3,3=6 где первое число код услуги модуля megogo, а второй заменяемый код услуги npay
		if( Utils.notBlankString( wrapService ) )
		{
			mapWrap = Utils.stringToPairsHash( wrapService );
		}
		
		Map<String, MegogoSubscription> serMap = new LinkedHashMap<>();
		try ( var ps = con.prepareStatement( "SELECT sid,type, comment from megogo_subscription_" + mid + " ORDER BY type,id" ) )
		{
			ResultSet rs = ps.executeQuery();
			while( rs.next() )
			{
				MegogoSubscription m = new MegogoSubscription();
				m.setSid( rs.getInt( "sid" ) );
				m.setTitle( rs.getString( "comment" ) );
				m.setType( rs.getInt( "type" ) );
				m.setComment( Utils.formatBigDecimalSumm( BigDecimal.ZERO ) );
				String sid = rs.getString( "sid" );
				if( mapWrap.get( sid ) != null )// замена реального кода наработки
				{
					sid = mapWrap.get( sid );
				}
				serMap.put( sid, m );
			}
		}
		
		String sidsStr = Utils.toString( serMap.keySet(), "," );
		
		int countMain = 0, countOptional = 0;
		BigDecimal sumMain = BigDecimal.ZERO, sumOptional = BigDecimal.ZERO;
		String query = "SELECT sid, SUM(ROUND(t1.summa, 2)) as sum, COUNT(sid) as count FROM contract_account AS t1 WHERE sid IN (" + sidsStr + ") AND t1.yy=" + year + " AND t1.mm=" + month + " GROUP BY t1.sid";
		try ( var ps = con.prepareStatement( query ) )
		{
			ResultSet rs = ps.executeQuery();
			while( rs.next() )
			{
				MegogoSubscription sub = serMap.get( rs.getString( "sid" ) );
				if( sub != null )
				{ // Чтобы не вводить новый бин или мап, просто использую существующие поля не по назначению. Userid как кол-во, а comment - общая сумма.
					int count = rs.getInt( "count" );
					BigDecimal sum = rs.getBigDecimal( "sum" );
					sub.setUserId( count );
					sub.setComment( Utils.formatBigDecimalSumm( sum ) );
					
					if( sub.getType() == MegogoSubscription.SUBSCRIPTION_TYPE_MAIN )
					{
						countMain += count;
						sumMain = sumMain.add( sum );
					}
					else
					{
						countOptional += count;
						sumOptional = sumOptional.add( sum );
					}
				}
			}
		}
		
		for( MegogoSubscription sub : serMap.values() )
		{
			Map<String, String> row = new HashMap<String, String>();
			
			row.put( "subscription", sub.getTitle() );
			row.put( "countActive", sub.getUserId() + "" );
			row.put( "sum", sub.getComment() );
			
			data.add( row );
		}
		
		data.add( new HashMap<String, String>() );
		Map<String, String> row = new HashMap<String, String>();
		row.put( "subscription", "Итого" );
		row.put( "countActive", " Основных = " + countMain + " , Дополнительных = " + countOptional );
		row.put( "sum", " Основных = " + Utils.formatBigDecimalSumm( sumMain ) + " , Дополнительных = " + Utils.formatBigDecimalSumm( sumOptional ) );
		data.add( row );
		
		fields.put( "subscription", "Продукт##-1" );
        fields.put( "countActive", "Кол-во активных договоров##-1" );				
        fields.put( "sum", "Сумма##-1" );
        
        result.setData( data );
	}

}
