/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RecordAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.SearchResult;

public class RequestRecordLogDao
extends AbstractIdDao<RequestRecordLog> {
    public RequestRecordLogDao(Connection con) {
        super(con, 0, "bgs_request_record");
    }

    protected RequestRecordLog getFromRS(ResultSet rs) throws SQLException {
        RequestRecordLog log = new RequestRecordLog();
        log.setStartRecordingTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("start_record_time")));
        Timestamp stopTime = rs.getTimestamp("stop_record_time");
        log.setEndRecordingTime(stopTime != null ? TimeUtils.convertTimestampToDate((Timestamp)stopTime) : null);
        log.setUserId(rs.getInt("user_id"));
        log.setId(rs.getInt("id"));
        log.setTitle(rs.getString("title"));
        log.setAllActionsCount(rs.getInt("all_actions_count"));
        log.setActions(this.actionsFromJsonArray(rs.getString("actions")));
        return log;
    }

    protected void updateImpl(RequestRecordLog requestRecordLog) throws SQLException {
        String querySet = "start_record_time=?, stop_record_time=?, all_actions_count=?, actions=?, title=?, user_id=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)requestRecordLog, querySet);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)requestRecordLog.getStartRecordingTime()));
            ps.setTimestamp(index++, requestRecordLog.getEndRecordingTime() != null ? TimeUtils.convertDateToTimestamp((Date)requestRecordLog.getEndRecordingTime()) : null);
            ps.setInt(index++, requestRecordLog.getAllActionsCount());
            ps.setString(index++, this.actionsToJsonArray(requestRecordLog.getActions()));
            ps.setString(index++, requestRecordLog.getTitle());
            ps.setInt(index++, requestRecordLog.getUserId());
            this.executeUpdate((Id)requestRecordLog, index, ps);
        }
    }

    private String actionsToJsonArray(Set<RecordAction> actions) {
        if (Utils.isEmptyCollection(actions)) {
            return "";
        }
        JSONArray arr = new JSONArray();
        for (RecordAction action : actions) {
            JSONObject json = new JSONObject();
            json.put("moduleId", (Object)action.getModuleId());
            json.put("operation", (Object)action.getOperation());
            json.put("description", (Object)action.getDescription());
            json.put("service", (Object)action.getService());
            json.put("actionId", (Object)action.getActionId());
            arr.put((Object)json);
        }
        return arr.toString();
    }

    private Set<RecordAction> actionsFromJsonArray(String jsonArray) {
        if (Utils.isBlankString((String)jsonArray)) {
            return new HashSet<RecordAction>();
        }
        HashSet<RecordAction> result = new HashSet<RecordAction>();
        JSONArray arr = new JSONArray(jsonArray);
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject json = arr.getJSONObject(i);
            RecordAction action = new RecordAction();
            action.setOperation(json.optString("operation"));
            action.setService(json.optString("service"));
            action.setModuleId(json.optString("moduleId"));
            action.setDescription(json.optString("description"));
            action.setActionId(json.optString("actionId"));
            result.add(action);
        }
        return result;
    }

    public void searchRequestRecordLogList(SearchResult<RequestRecordLog> searchResult) throws SQLException {
        Objects.requireNonNull(searchResult);
        searchResult.getList().addAll(this.list(null, "id", new Object[0]));
    }
}

