/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.MonitorStatusResult;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ContractStatusMonitorDao
extends AbstractDao<MonitorStatusResult> {
    protected static final String BALANCE_DUMP_TABLE = "contract_status_balance_dump";

    public ContractStatusMonitorDao(Connection con) {
        super(con, "contract_status", 0);
    }

    public Calendar createBalanceDump() throws SQLException {
        try (Statement st = this.con.createStatement();){
            st.executeUpdate("DROP TABLE IF EXISTS contract_status_balance_dump");
        }
        String query = "CREATE TABLE contract_status_balance_dump( UNIQUE(cid) ) SELECT cid, MAX(yy*12+(mm-1))%12 + 1 AS mm, FLOOR(MAX(yy*12+(mm-1)) / 12) AS yy FROM contract_balance WHERE ((yy*12) + mm)<=((?*12) + ?) GROUP BY cid";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Calendar calendar = TimeUtils.convertDateToCalendar(new Date());
            ps.setInt(1, calendar.get(1));
            ps.setInt(2, calendar.get(2) + 1);
            ps.executeUpdate();
        }
        return new GregorianCalendar();
    }

    public SearchResult<MonitorStatusResult> contractSearch(int saldoShowMode, int saldoAccountMonths, float serviceAccountMaxValue, String serviceAccountMaxServices, String status, int mode, boolean subContract, boolean balanceLimit, boolean balancePrevLimit, int statusPeriod, String statusPeriodUnit, Set<Integer> label, Set<Integer> notLabel, String saldoFrom, String saldoTo, BigDecimal saldoAcconuntsMore, String sort, Page page) throws SQLException {
        int mm;
        int yy;
        GregorianCalendar now;
        StringBuilder query = new StringBuilder();
        query.append("SELECT SQL_CALC_FOUND_ROWS contract.id, contract.title, contract.comment, contract.status, contract_status.date1, ");
        if (saldoShowMode == 1) {
            now = new GregorianCalendar();
            yy = now.get(1);
            mm = now.get(2) + 1;
            query.append("IF(");
            query.append("last_balance.yy=" + yy + " AND last_balance.mm=" + mm + ",");
            query.append("IFNULL(balance.summa1 + balance.summa2, 0),");
            query.append("IFNULL(balance.summa1 + balance.summa2 - balance.summa3 - balance.summa4, 0)");
            query.append(" ) AS saldo");
        } else if (saldoShowMode == 2) {
            query.append("IFNULL(balance.summa1 + balance.summa2 - balance.summa3 - balance.summa4, 0)");
            query.append(" AS saldo");
        }
        query.append(", contract_status.date2");
        if (saldoAccountMonths > 0) {
            query.append(", IFNULL(-SUM(balance2.summa3+balance2.summa4),0) as accounts ");
        }
        query.append(" FROM contract LEFT JOIN ");
        query.append(BALANCE_DUMP_TABLE);
        query.append(" AS last_balance ON contract.id=last_balance.cid ");
        query.append(" LEFT JOIN contract_balance AS balance");
        query.append(" ON contract.id=balance.cid AND balance.yy=last_balance.yy AND balance.mm=last_balance.mm");
        query.append(" LEFT JOIN contract_status ");
        query.append(" ON contract.id=contract_status.cid AND contract_status.date1<=CURDATE()");
        query.append(" AND (contract_status.date2 IS NULL OR contract_status.date2>=CURDATE())");
        if (saldoAccountMonths > 0) {
            int months = saldoAccountMonths;
            query.append(" LEFT JOIN contract_balance AS balance2 ON contract.id=balance2.cid AND (1=0");
            GregorianCalendar now2 = new GregorianCalendar();
            ((Calendar)now2).add(2, -1);
            now2.set(5, 1);
            int yy2 = now2.get(1);
            int mm2 = now2.get(2) + 1;
            query.append(" OR (balance2.yy=");
            query.append(yy2);
            query.append(" AND balance2.mm<=");
            query.append(mm2);
            query.append(" AND balance2.mm>");
            query.append(mm2 - months);
            query.append(")");
            if ((months -= mm2) > 0) {
                int monthsRest;
                int years = months / 12;
                if (years > 0) {
                    query.append(" OR (balance2.yy<");
                    query.append(yy2);
                    query.append(" AND balance2.yy>=");
                    query.append(yy2 - years);
                    query.append(")");
                }
                if ((monthsRest = months % 12) > 0) {
                    query.append(" OR (balance2.yy=");
                    query.append(yy2 - years - 1);
                    query.append(" AND balance2.mm>");
                    query.append(12 - monthsRest);
                    query.append(")");
                }
            }
            query.append(") ");
        }
        if (serviceAccountMaxValue >= 0.0f) {
            query.append(" LEFT JOIN contract_account ON contract.id=contract_account.cid");
            query.append(" AND contract_account.sid IN (").append(serviceAccountMaxServices).append(")");
            query.append(" AND (1=0 ");
            now = new GregorianCalendar();
            now.set(5, 1);
            yy = now.get(1);
            mm = now.get(2) + 1;
            int months = 2;
            while (months > 0) {
                if (mm > months) {
                    query.append(" OR (contract_account.yy=").append(yy);
                    query.append(" AND contract_account.mm>").append(mm - months).append(") ");
                } else {
                    query.append(" OR contract_account.yy=").append(yy).append(" ");
                }
                months -= mm;
                --yy;
                mm = 12;
            }
            query.append(")");
        }
        if (Utils.notBlankString(status)) {
            query.append(" WHERE contract.status IN (").append(status).append(" ) ");
        } else {
            query.append(" WHERE true");
        }
        if (mode >= 0) {
            query.append(" AND contract.mode=").append(mode);
        }
        if (subContract) {
            query.append(" AND (contract.scid<=0 OR (contract.scid>0 AND contract.sub_mode=1) ) ");
        } else {
            query.append(" AND contract.scid<=0 ");
        }
        query.append(" AND contract.del=0 ");
        query.append(" AND (contract.date2 IS NULL OR contract.date2>=CURDATE()) ");
        if (balanceLimit) {
            query.append("AND (balance.summa1+balance.summa2-balance.summa3-balance.summa4)<contract.closesumma ");
        }
        if (balancePrevLimit) {
            now = new GregorianCalendar();
            now.set(5, 1);
            yy = now.get(1);
            mm = now.get(2) + 1;
            query.append("AND ((balance.mm=" + mm + " AND balance.yy=" + yy);
            query.append(" AND (balance.summa1)<contract.closesumma)");
            query.append(" OR ((balance.mm!=" + mm + " OR balance.yy!=" + yy);
            query.append(") AND (balance.summa1+balance.summa2-balance.summa3-balance.summa4)<contract.closesumma)) ");
        }
        if (statusPeriod > 0) {
            query.append(" AND contract_status.date1<=DATE_SUB(CURDATE(), INTERVAL ");
            query.append(statusPeriod);
            if (statusPeriodUnit.equals("day")) {
                query.append(" DAY) ");
            } else {
                query.append(" MONTH) ");
            }
        }
        if (label != null && !label.isEmpty()) {
            query.append(" AND contract.id IN ( SELECT contract_id FROM contract_label_link WHERE label_id IN ( " + Utils.toString(label) + " ) )");
        }
        if (notLabel != null && !notLabel.isEmpty()) {
            query.append(" AND contract.id NOT IN ( SELECT contract_id FROM contract_label_link WHERE label_id IN ( " + Utils.toString(notLabel) + " ) )");
        }
        if (saldoAccountMonths > 0 || serviceAccountMaxValue >= 0.0f) {
            query.append(" GROUP BY contract.id ");
        }
        query.append(" HAVING 1>0");
        if (Utils.notBlankString(saldoFrom)) {
            query.append(" AND saldo>=");
            query.append(saldoFrom);
        }
        if (Utils.notBlankString(saldoTo)) {
            query.append(" AND saldo<=0");
            query.append(saldoTo);
        }
        if (saldoAccountMonths > 0) {
            query.append(" AND saldo < accounts - ");
            query.append(saldoAcconuntsMore.toPlainString());
        }
        if (serviceAccountMaxValue >= 0.0f) {
            query.append(" AND IFNULL(SUM(contract_account.summa),0)<=? ");
        }
        if (Utils.notBlankString(sort)) {
            query.append(" ORDER BY ").append(sort);
        }
        query.append(this.sqlLimit(page));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(query.toString());
        }
        List res = null;
        try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
            if (serviceAccountMaxValue >= 0.0f) {
                ps.setFloat(1, serviceAccountMaxValue);
            }
            try (ResultSet rs = ps.executeQuery();){
                res = this.getListFromRS(rs);
            }
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        return new SearchResult(page).setList(res);
    }

    @Override
    protected void updateImpl(MonitorStatusResult monitorStatusResult) throws SQLException {
    }

    @Override
    protected MonitorStatusResult getFromRS(ResultSet rs) throws SQLException {
        return new MonitorStatusResult().setContractId(rs.getInt(1)).setContractTitle(rs.getString(2)).setContractComment(rs.getString(3)).setStatus(StatusCache.getInstance().getStatusTitle(rs.getInt(4))).setStatusDate(TimeUtils.formatDate(rs.getDate(5))).setSaldo(Utils.formatCost(BigDecimal.valueOf(rs.getDouble(6)))).setStatusDateTo(TimeUtils.formatDate(rs.getDate(7)));
    }
}

