/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client.admin;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class BonusProgramManagerPanel
extends BGUPanel {
    private BGUTable programTable;
    private BonusProgramTableModel programTableModel;
    private CardLayout cardLayout = new CardLayout();
    private BGUComboBox<IdTitle> timeLagComboBox = new BGUComboBox();
    private BGUComboBox<IdTitle> activeTimeComboBox = new BGUComboBox();
    private BGUComboBox<KeyValue> programTypeComboBox = new BGUComboBox();
    private BGUComboBox<IdTitle> bonusTypePaymentComboBox = new BGUComboBox();
    private BGTextField titleTextField = new BGTextField(15);
    private BGIntTextField timeLagTextField = new BGIntTextField(12);
    private BGIntTextField activeTimeTextField = new BGIntTextField(12);
    private JPanel programPanel = new JPanel(new GridBagLayout());
    private JPanel programTypePanel = new JPanel(new GridBagLayout());
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGCalendarButton timeLagCalendarButton = new BGCalendarButton();
    private BGCalendarButton activeTimeCalendarButton = new BGCalendarButton();
    private BGButtonPanelRestoreOkCancelHelp okCancelHelp = new BGButtonPanelRestoreOkCancelHelp();
    private OperationProgramPanel operationProgramPanel = new OperationProgramPanel();
    private JPanel illusionPanel = new JPanel(new GridBagLayout());
    private List<IdTitle> timeLagItems = Arrays.asList(new IdTitle(1, "\u0414\u0435\u043d\u044c"), new IdTitle(2, "\u041a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439"), new IdTitle(3, "\u041d\u0430\u0447\u0430\u043b\u043e \u043d\u0435\u0434\u0435\u043b\u0438"), new IdTitle(4, "\u041d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430"), new IdTitle(5, "\u041d\u0430\u0447\u0430\u043b\u043e \u0433\u043e\u0434\u0430"));
    private List<IdTitle> activeTimeItems = Arrays.asList(new IdTitle(1, "\u0414\u0435\u043d\u044c"), new IdTitle(2, "\u041a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439"), new IdTitle(3, "\u041a\u043e\u043d\u0435\u0446 \u043d\u0435\u0434\u0435\u043b\u0438"), new IdTitle(4, "\u041a\u043e\u043d\u0435\u0446 \u043c\u0435\u0441\u044f\u0446\u0430"), new IdTitle(5, "\u041a\u043e\u043d\u0435\u0446 \u0433\u043e\u0434\u0430"));

    protected void jbInit() throws Exception {
        this.programTableModel = new BonusProgramTableModel();
        this.programTable = new BGUTable((TableModel)((Object)this.programTableModel));
        this.timeLagComboBox.setData(this.timeLagItems);
        this.activeTimeComboBox.setData(this.activeTimeItems);
        JPanel panel = new JPanel(this.cardLayout);
        panel.add("operationProgramPanel", this.operationProgramPanel);
        this.programTypePanel.setPreferredSize(new Dimension(100, 200));
        this.programTypePanel.setBorder(new TitledBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b"));
        this.programTypePanel.add((Component)new JScrollPane(panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.illusionPanel.add((Component)this.programTypePanel, new GridBagConstraints(4, 0, 1, 7, 0.7, 0.1, 10, 1, new Insets(0, 15, 0, 5), 0, 0));
        this.programPanel.setBorder(new TitledBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.programPanel.setVisible(false);
        this.programPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.titleTextField, new GridBagConstraints(1, 0, 2, 1, 0.3, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.illusionPanel, new GridBagConstraints(4, 0, 1, 7, 0.7, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.programTypeComboBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.period, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u0445\u043e\u0434\u0430"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.bonusTypePaymentComboBox, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u041c\u043e\u043c\u0435\u043d\u0442 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.timeLagComboBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.timeLagTextField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.timeLagCalendarButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.activeTimeComboBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.activeTimeTextField, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.activeTimeCalendarButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.okCancelHelp, new GridBagConstraints(0, 7, 5, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.programTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.programPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.cardLayout.show(panel, "operationProgramPanel");
        BGSwingUtilites.handleLDMouseClicked((Component)this.programTable, e -> {
            if (this.programTable.isEnabled()) {
                this.performAction("edit");
            }
        });
        this.timeLagComboBox.addActionListener(e -> this.setVisibleComboBox(this.timeLagComboBox, this.timeLagCalendarButton, this.timeLagTextField));
        this.activeTimeComboBox.addActionListener(e -> this.setVisibleComboBox(this.activeTimeComboBox, this.activeTimeCalendarButton, this.activeTimeTextField));
        this.programTypeComboBox.addActionListener(e -> {
            KeyValue item = (KeyValue)this.programTypeComboBox.getSelectedItem();
            if (item != null) {
                this.programTypePanel.setVisible(Utils.parseInt((String)item.getKey(), (int)-1) > -1);
            }
        });
        this.okCancelHelp.addActionListener(arg0 -> {
            try {
                if (arg0.getActionCommand().equals("ok")) {
                    BonusProgram program = new BonusProgram();
                    if (this.programTableModel.getSelectedRow() != null) {
                        program = (BonusProgram)this.programTableModel.getSelectedRow();
                    }
                    if (this.period.getDateCalendar1() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u0438\u0445\u043e\u0434\u0430", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    if (this.period.getDateCalendar2() != null && this.period.getDateCalendar1() != null && this.period.getDateCalendar1().compareTo(this.period.getDateCalendar2()) > 0) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0435\u0440\u0432\u0430\u044f \u0434\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    if (Utils.isBlankString((String)this.titleTextField.getText())) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    if (Optional.ofNullable((IdTitle)this.bonusTypePaymentComboBox.getSelectedItem()).map(a -> a.getId()).orElse(-1) < 1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    int timeLagItemId = Optional.ofNullable((IdTitle)this.timeLagComboBox.getSelectedItem()).map(a -> a.getId()).orElse(-1);
                    if (timeLagItemId == -1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    switch (timeLagItemId) {
                        case 1: {
                            if (this.timeLagCalendarButton.getCalendar() != null) {
                                program.setTimeLag(TimeUtils.format((Calendar)this.timeLagCalendarButton.getCalendar(), (String)"dd.MM.yyyy"));
                                break;
                            }
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                            return;
                        }
                        case 2: {
                            if (Utils.isBlankString((String)this.timeLagTextField.getText())) {
                                program.setTimeLag("0");
                                break;
                            }
                            program.setTimeLag(this.timeLagTextField.getText());
                            break;
                        }
                        case 3: {
                            program.setTimeLag("startWeek");
                            break;
                        }
                        case 4: {
                            program.setTimeLag("startMonth");
                            break;
                        }
                        case 5: {
                            program.setTimeLag("startYear");
                        }
                    }
                    int activeTimeItemId = Optional.ofNullable((IdTitle)this.activeTimeComboBox.getSelectedItem()).map(a -> a.getId()).orElse(-1);
                    if (activeTimeItemId == -1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    switch (activeTimeItemId) {
                        case 1: {
                            if (this.activeTimeCalendarButton.getCalendar() != null) {
                                program.setActiveTime(TimeUtils.format((Calendar)this.activeTimeCalendarButton.getCalendar(), (String)"dd.MM.yyyy"));
                                break;
                            }
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                            return;
                        }
                        case 2: {
                            if (Utils.isBlankString((String)this.activeTimeTextField.getText())) {
                                program.setActiveTime("0");
                                break;
                            }
                            program.setActiveTime(this.activeTimeTextField.getText());
                            break;
                        }
                        case 3: {
                            program.setActiveTime("endWeek");
                            break;
                        }
                        case 4: {
                            program.setActiveTime("endMonth");
                            break;
                        }
                        case 5: {
                            program.setActiveTime("endYear");
                        }
                    }
                    program.setTitle(this.titleTextField.getText().trim());
                    program.setPeriod(this.period.getPeriod());
                    program.setPaymentTypeId(Optional.ofNullable((IdTitle)this.bonusTypePaymentComboBox.getSelectedItem()).map(a -> a.getId()).orElse(0).intValue());
                    if (((KeyValue)this.programTypeComboBox.getSelectedItem()).getKey().equals(String.valueOf(1))) {
                        if (!this.operationProgramPanel.isCorrectData()) {
                            return;
                        }
                        program.setParams(this.operationProgramPanel.getParams());
                        program.setProgramTypeId(1);
                    } else {
                        program.setNameForDynamicClass(((KeyValue)this.programTypeComboBox.getSelectedItem()).getKey());
                        program.setProgramTypeId(2);
                    }
                    if (program.getId() > 0 && ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).checkProgramPeriodOnCrossing(program)) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043e\u0439 \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043f\u0435\u0440\u0438\u043e\u0434 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programUpdate(program);
                    this.programPanel.setVisible(false);
                    this.programTable.setEnabled(true);
                    this.performAction("refresh");
                } else if (arg0.getActionCommand().equals("cancel")) {
                    this.programPanel.setVisible(false);
                    this.programTable.setEnabled(true);
                } else if (arg0.getActionCommand().equals("reset")) {
                    this.setDataProgramTypePanel();
                }
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.programTypeComboBox.setData(((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programTypeMap().getMap().entrySet().stream().map(a -> new KeyValue((String)a.getKey(), (String)a.getValue())).toList());
            this.bonusTypePaymentComboBox.setData(((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).paymentTypeList(true).stream().map(IdTitle::toIdTitle).toList());
            this.programTableModel.setData(((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programList(null));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.performAction("refresh");
            this.programTable.setEnabled(false);
            this.programPanel.setVisible(true);
            this.period.setPeriod(null);
            this.programTypeComboBox.setSelectedIndex(-1);
            this.titleTextField.setText("");
            this.timeLagTextField.setText("");
            this.activeTimeTextField.setText("");
            this.setVisibleComboBox(this.timeLagComboBox, this.timeLagCalendarButton, this.timeLagTextField);
            this.setVisibleComboBox(this.activeTimeComboBox, this.activeTimeCalendarButton, this.activeTimeTextField);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.setDataProgramTypePanel());
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (this.programTableModel.getSelectedRow() != null) {
                int programId = ((BonusProgram)this.programTableModel.getSelectedRow()).getId();
                if (((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programInContractList(programId, null).size() == 0) {
                    try {
                        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443?", "", 2) == 0) {
                            ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programDelete(programId);
                        }
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((String)ex.getLocalizedMessage());
                    }
                    this.performAction("refresh");
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0435\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0443\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0443 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432!", "", 1);
                }
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430", "", 1);
            }
        });
    }

    private void setVisibleComboBox(BGUComboBox<IdTitle> comboBox, BGCalendarButton calendarButton, BGIntTextField textField) {
        if (((IdTitle)comboBox.getSelectedItem()).getId() == 1) {
            textField.setVisible(false);
            calendarButton.setVisible(true);
        } else if (((IdTitle)comboBox.getSelectedItem()).getId() == 2) {
            textField.setVisible(true);
            calendarButton.setVisible(false);
        } else {
            textField.setVisible(false);
            calendarButton.setVisible(false);
        }
    }

    private void setDataProgramTypePanel() {
        this.programTable.setEnabled(false);
        if (this.programTable.getSelectedRow() != -1) {
            String typeId;
            BonusProgram selectProgram;
            block25: {
                this.programPanel.setVisible(true);
                this.programTypePanel.setVisible(false);
                selectProgram = (BonusProgram)this.programTableModel.getSelectedRow();
                this.bonusTypePaymentComboBox.setSelectedItem((Object)selectProgram.getPaymentTypeId());
                this.period.setPeriod(selectProgram.getPeriod());
                typeId = null;
                if (selectProgram.getProgramTypeId() == 2) {
                    try {
                        if (((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programTypeMap().getMap().get(selectProgram.getNameForDynamicClass()) == null) {
                            ClientUtils.showErrorMessageDialog((String)("\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \n\u041a\u043b\u0430\u0441\u0441 " + selectProgram.getNameForDynamicClass() + " \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d! \u041f\u043e\u043f\u0440\u0430\u0432\u0442\u0435 \u0434\u0438\u043d. \u043a\u043b\u0430\u0441\u0441 \u0438/\u0438\u043b\u0438 \u043a\u043e\u043d\u0444\u0438\u0433. \u043f\u043b\u0430\u0433\u0438\u043d\u0430. \u0438\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u0442\u0438\u043f."));
                            break block25;
                        }
                        typeId = selectProgram.getNameForDynamicClass();
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                } else {
                    typeId = Integer.toString(selectProgram.getProgramTypeId());
                }
            }
            String id = typeId;
            this.programTypeComboBox.setSelectedItem((Object)this.programTypeComboBox.getData().stream().filter(a -> a.getKey().equals(id)).findFirst().orElse((KeyValue)this.programTypeComboBox.getData().get(0)));
            this.titleTextField.setText(selectProgram.getTitle());
            if (Utils.parseInt((String)selectProgram.getTimeLag(), (int)-1) != -1) {
                this.timeLagComboBox.setSelectedItem((Object)2);
                this.timeLagTextField.setText(selectProgram.getTimeLag());
            } else if (TimeUtils.parseDate((String)selectProgram.getTimeLag(), (String)"dd.MM.yyyy") != null) {
                this.timeLagComboBox.setSelectedItem((Object)1);
                this.timeLagCalendarButton.setLocalDate(TimeUtils.parseLocalDate((String)selectProgram.getTimeLag(), (String)"dd.MM.yyyy"));
            } else if (selectProgram.getTimeLag().equals("startWeek")) {
                this.timeLagComboBox.setSelectedItem((Object)3);
            } else if (selectProgram.getTimeLag().equals("startMonth")) {
                this.timeLagComboBox.setSelectedItem((Object)4);
            } else if (selectProgram.getTimeLag().equals("startYear")) {
                this.timeLagComboBox.setSelectedItem((Object)5);
            }
            if (Utils.parseInt((String)selectProgram.getActiveTime(), (int)-1) != -1) {
                this.activeTimeComboBox.setSelectedItem((Object)2);
                this.activeTimeTextField.setText(selectProgram.getActiveTime());
            } else if (TimeUtils.parseDate((String)selectProgram.getActiveTime(), (String)"dd.MM.yyyy") != null) {
                this.activeTimeComboBox.setSelectedItem((Object)1);
                this.activeTimeCalendarButton.setLocalDate(TimeUtils.parseLocalDate((String)selectProgram.getActiveTime(), (String)"dd.MM.yyyy"));
            } else if (selectProgram.getActiveTime().equals("endWeek")) {
                this.activeTimeComboBox.setSelectedItem((Object)3);
            } else if (selectProgram.getActiveTime().equals("endMonth")) {
                this.activeTimeComboBox.setSelectedItem((Object)4);
            } else if (selectProgram.getActiveTime().equals("endYear")) {
                this.activeTimeComboBox.setSelectedItem((Object)5);
            }
            if (selectProgram.getProgramTypeId() == 1) {
                this.operationProgramPanel.setData(selectProgram);
                this.programTypePanel.setVisible(true);
            }
        }
    }

    private class OperationProgramPanel
    extends JPanel {
        protected BGUComboBox<IdTitle> accrualPeriodComboBox = new BGUComboBox();
        protected BGIntTextField accrualPeriodDayTextField = new BGIntTextField(12);
        protected BGUComboBox<IdTitle> typeOperationComboBox = new BGUComboBox();
        protected BGFloatTextField minSumOperationTextField = new BGFloatTextField();
        protected BGFloatTextField minSumAllOperationTextField = new BGFloatTextField();
        protected BGUComboBox<IdTitle> typeCalculationComboBox = new BGUComboBox();
        protected BGFloatTextField rateCalculationTextField = new BGFloatTextField();
        protected JTextField rankCalculationTextField = new JTextField(12);
        protected JTextField operationIdTextField = new JTextField(12);

        public OperationProgramPanel() {
            this.accrualPeriodComboBox.setData(Arrays.asList(new IdTitle(1, "\u0415\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u044b\u0439"), new IdTitle(2, "\u041c\u0435\u0441\u044f\u0447\u043d\u044b\u0439"), new IdTitle(3, "\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439"), new IdTitle(4, "\u041c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0439")));
            this.typeOperationComboBox.setData(Arrays.asList(new IdTitle(1, "\u041f\u0440\u0438\u0445\u043e\u0434"), new IdTitle(2, "\u0420\u0430\u0441\u0445\u043e\u0434"), new IdTitle(3, "\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430")));
            this.typeCalculationComboBox.setData(Arrays.asList(new IdTitle(1, "\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u043d\u044b\u0439"), new IdTitle(2, "\u0410\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u044b\u0439"), new IdTitle(3, "\u041f\u043e\u0448\u0430\u0433\u043e\u0432\u044b\u0439"), new IdTitle(4, "\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439")));
            this.accrualPeriodDayTextField.setEditable(false);
            this.rankCalculationTextField.setVisible(false);
            JPanel typePanel = new JPanel(new GridBagLayout());
            typePanel.setBackground(Color.WHITE);
            typePanel.add((Component)this.typeCalculationComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            typePanel.add((Component)this.rateCalculationTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            typePanel.add((Component)this.rankCalculationTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(Color.WHITE);
            panel.add((Component)new JLabel("\u0422\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.typeOperationComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.accrualPeriodComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043d\u0438"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.accrualPeriodDayTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.minSumOperationTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.minSumAllOperationTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0422\u0438\u043f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043e\u0432"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)typePanel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("ID \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            panel.add((Component)this.operationIdTextField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.typeOperationComboBox.addActionListener(arg0 -> {
                if (((IdTitle)this.typeOperationComboBox.getSelectedItem()).getId() == 3) {
                    this.accrualPeriodComboBox.setSelectedItem((Object)2);
                    this.accrualPeriodComboBox.setEnabled(false);
                } else {
                    this.accrualPeriodComboBox.setEnabled(true);
                }
            });
            this.accrualPeriodComboBox.addActionListener(arg0 -> {
                if (((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId() == 3 || ((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId() == 2) {
                    this.accrualPeriodDayTextField.setEditable(true);
                } else {
                    this.accrualPeriodDayTextField.setEditable(false);
                    this.accrualPeriodDayTextField.setText("");
                }
                if (((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId() == 4) {
                    this.minSumAllOperationTextField.setEditable(false);
                    this.minSumAllOperationTextField.setText("");
                } else {
                    this.minSumAllOperationTextField.setEditable(true);
                }
            });
            this.typeCalculationComboBox.addActionListener(arg0 -> {
                boolean fVisible = false;
                if (((IdTitle)this.typeCalculationComboBox.getSelectedItem()).getId() == 4) {
                    fVisible = true;
                }
                this.rankCalculationTextField.setVisible(fVisible);
                this.rateCalculationTextField.setVisible(!fVisible);
            });
        }

        public void setData(BonusProgram program) {
            HashMap params = program.getParams();
            this.typeOperationComboBox.setSelectedItem((Object)Utils.parseInt((String)((String)params.get("typeOperation"))));
            this.accrualPeriodComboBox.setSelectedItem((Object)Utils.parseInt((String)((String)params.get("accrualPeriod"))));
            this.accrualPeriodDayTextField.setText("");
            if (params.get("accrualPeriod") != null && (((String)params.get("accrualPeriod")).equals("3") || ((String)params.get("accrualPeriod")).equals("2"))) {
                this.accrualPeriodDayTextField.setText((String)params.get("accrualPeriodDay"));
            }
            this.minSumOperationTextField.setText((String)params.get("minSumOperation"));
            this.minSumAllOperationTextField.setText((String)params.get("minSumOperationAll"));
            this.typeCalculationComboBox.setSelectedItem((Object)Utils.parseInt((String)((String)params.get("typeCalculation"))));
            if (((IdTitle)this.typeCalculationComboBox.getSelectedItem()).getId() == 4) {
                this.rankCalculationTextField.setText((String)params.get("valueCalculation"));
            } else {
                this.rateCalculationTextField.setText((String)params.get("valueCalculation"));
            }
            this.operationIdTextField.setText((String)params.get("operationTypeId"));
        }

        public boolean isCorrectData() {
            Matcher m;
            Pattern p;
            if (((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId() == 2) {
                if (Utils.parseInt((String)this.accrualPeriodDayTextField.getText(), (int)-1) < 1) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                    return false;
                }
                if (Utils.parseInt((String)this.accrualPeriodDayTextField.getText(), (int)-1) > 28 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u0435\u0441\u044f\u0446\u0430\u0445 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442\u044c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435! \u0412\u044b \u0432\u0441\u0435 \u0440\u0430\u0432\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c") != 0) {
                    return false;
                }
            }
            if (((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId() == 3 && Utils.parseInt((String)this.accrualPeriodDayTextField.getText(), (int)-1) < 1) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u043a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439 \u043c\u0435\u0436\u0434\u0443 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f\u043c\u0438 \u0431\u043e\u043d\u0443\u0441\u043e\u0432!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                return false;
            }
            if (((IdTitle)this.typeCalculationComboBox.getSelectedItem()).getId() != 4) {
                if (Utils.parseBigDecimal((String)this.rateCalculationTextField.getText(), (BigDecimal)new BigDecimal(-1)).compareTo(BigDecimal.ZERO) == -1) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - \"\u0422\u0438\u043f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043e\u0432\"!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                    return false;
                }
            } else {
                p = Pattern.compile("^(\\d+-\\d+)(,\\d+-\\d+)*");
                m = p.matcher(this.rankCalculationTextField.getText());
                if (!m.matches()) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - \"\u0422\u0438\u043f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043e\u0432\"(\u041f\u0440\u0438\u043c\u0435\u0440: 50-5,100-12,200-17)", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                    return false;
                }
            }
            if (!Utils.isBlankString((String)this.operationIdTextField.getText()) && !(m = (p = Pattern.compile("^(\\d+)(,\\d+)*")).matcher(this.operationIdTextField.getText())).matches()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - \"ID \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439\"(\u041f\u0440\u0438\u043c\u0435\u0440: \"50,3,6\" \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430)", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                return false;
            }
            return true;
        }

        public HashMap<String, String> getParams() {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("typeOperation", String.valueOf(((IdTitle)this.typeOperationComboBox.getSelectedItem()).getId()));
            params.put("accrualPeriod", String.valueOf(((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId()));
            if (((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId() == 3 || ((IdTitle)this.accrualPeriodComboBox.getSelectedItem()).getId() == 2) {
                params.put("accrualPeriodDay", this.accrualPeriodDayTextField.getText());
            }
            if (!Utils.isBlankString((String)this.minSumOperationTextField.getText())) {
                params.put("minSumOperation", this.minSumOperationTextField.getText());
            } else {
                params.put("minSumOperation", "0");
            }
            if (this.minSumAllOperationTextField.isEditable() && !Utils.isBlankString((String)this.minSumAllOperationTextField.getText())) {
                params.put("minSumOperationAll", this.minSumAllOperationTextField.getText());
            } else {
                params.put("minSumOperationAll", "0");
            }
            params.put("typeCalculation", String.valueOf(((IdTitle)this.typeCalculationComboBox.getSelectedItem()).getId()));
            if (((IdTitle)this.typeCalculationComboBox.getSelectedItem()).getId() == 4) {
                params.put("valueCalculation", this.rankCalculationTextField.getText());
            } else {
                params.put("valueCalculation", this.rateCalculationTextField.getText());
            }
            if (!Utils.isBlankString((String)this.operationIdTextField.getText())) {
                params.put("operationTypeId", this.operationIdTextField.getText());
            }
            return params;
        }
    }

    class BonusProgramTableModel
    extends BGTableModel<BonusProgram> {
        public BonusProgramTableModel() {
            super(BonusProgramTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 200, 200, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", -1, 350, 500, "specificationTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

