/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.ActionLogEntry;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;

public class BGActionLogManager
extends AbstractIdDao<ActionLogEntry> {
    private static final String TABLE = "server_current_actions";

    public BGActionLogManager(Connection con) {
        super(con, 0, TABLE);
    }

    public boolean isConnectionActive() {
        return ServerUtils.tableExists((Connection)this.con, (String)TABLE);
    }

    @Override
    protected ActionLogEntry getFromRS(ResultSet rs) throws SQLException {
        return new ActionLogEntry().setId(rs.getInt("id")).setAction(rs.getString("action")).setQuery(rs.getString("query")).setUserId(rs.getInt("uid")).setModuleId(rs.getInt("mid")).setModuleTitle(rs.getString("m_title"));
    }

    @Override
    protected void updateImpl(ActionLogEntry actionLogEntry) throws SQLException {
        Objects.requireNonNull(actionLogEntry);
        if (actionLogEntry.getId() > 0) {
            return;
        }
        String query = "INSERT INTO " + this.tableName + " SET action=?, query=?, uid=?, u_name=?, m_title=?, dtime=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, actionLogEntry.getAction());
            ps.setString(index++, actionLogEntry.getQuery());
            ps.setInt(index++, actionLogEntry.getUserId());
            ps.setString(index++, UserMap.getUser((Integer)actionLogEntry.getUserId()).getName());
            ps.setString(index++, actionLogEntry.getModuleTitle());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp(actionLogEntry.getDatetime()));
            ps.executeUpdate();
            actionLogEntry.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }
}

