/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.mobile;

import jakarta.servlet.http.HttpServletRequest;
import java.awt.Color;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileParamType;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReportType;

public abstract class MobileReport {
    protected Connection con;
    private HttpServletRequest request;
    private Map<String, String> map;
    protected int grafType;
    private int numColor;
    private static List<Color> colorList;
    public static final int LinearChartType = 1;
    public static final int PieChartType = 2;
    public static final int HistogramChartType = 3;
    public static final int TableType = 4;

    public void init(Connection con, HttpServletRequest request) {
        this.con = con;
        this.request = request;
    }

    public abstract MobileReportType getReportType(Connection var1);

    public abstract List<Object> getData() throws BGIllegalArgumentException;

    public Object getDataWithDefaultParameters() throws BGIllegalArgumentException {
        MobileReportType repType = this.getReportType(this.con);
        this.map = new HashMap<String, String>();
        if (repType.getListParam() != null) {
            for (MobileParamType paramType : repType.getListParam()) {
                this.map.put(paramType.getId(), paramType.getDefaultInstance());
            }
        }
        return this.getData();
    }

    public abstract Map<String, Object> getOptions();

    public int getTypeGraf() {
        return this.grafType;
    }

    protected final String getParameter(String name) {
        return this.getParameter(name, null);
    }

    protected String getParameter(String name, String defaultValue) {
        String value = this.request.getParameter(name);
        if (this.map != null && value == null) {
            value = this.map.get(name);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected final boolean getBooleanParameter(String name) {
        return this.getBooleanParameter(name, false);
    }

    protected final boolean getBooleanParameter(String name, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            String v = this.getParameter(name).toUpperCase();
            if (defaultValue && ("0".equals(v) || "FALSE".equals(v) || "NO".equals(v))) {
                value = false;
            } else if (!defaultValue && ("1".equals(v) || "TRUE".equals(v) || "YES".equals(v))) {
                value = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    protected final Date getDateParameter(String name) {
        return this.getDateParameter(name, null);
    }

    protected final Date getDateParameter(String name, Date defaultValue) {
        return this.getDateParameter(name, "dd.MM.yyyy", defaultValue);
    }

    protected final Date getDateParameter(String name, String pattern, Date defaultValue) {
        Date outDate = defaultValue;
        String inDate = this.getParameter(name);
        if (inDate != null && !"".equals(inDate) && !"00.00.0000".equals(inDate)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(pattern);
                outDate = new Date(format.parse(inDate).getTime());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return outDate;
    }

    protected Color getColor() {
        return this.getColor(this.numColor++);
    }

    protected Color getColor(int number) {
        if (colorList == null) {
            colorList = new ArrayList<Color>();
            colorList.add(new Color(101, 214, 86));
            colorList.add(new Color(237, 2, 11));
            colorList.add(new Color(64, 120, 211));
            colorList.add(new Color(255, 202, 43));
            colorList.add(new Color(238, 47, 127));
            colorList.add(new Color(127, 176, 5));
            colorList.add(new Color(244, 101, 40));
            colorList.add(new Color(255, 169, 206));
            colorList.add(new Color(80, 168, 227));
            colorList.add(new Color(204, 255, 0));
            colorList.add(new Color(173, 222, 250));
            colorList.add(new Color(124, 20, 77));
            colorList.add(new Color(108, 92, 50));
        }
        if (colorList.size() - 1 < number || number < 0) {
            Random rand = new Random();
            return new Color(rand.nextInt(255), rand.nextInt(255), rand.nextInt(255));
        }
        return colorList.get(number);
    }
}

