/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.task;

import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.task.SormUploadTaskCommon;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormProjectUpload;

public class SormUploadTask
extends SormUploadTaskCommon {
    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        List<SormProject> activeSormProjects = this.getActiveSormProjects();
        this.getLogger().info("\u0421\u0442\u0430\u0440\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c \u043f\u043e \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044e");
        this.getLogger().info("\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432 \u0421\u041e\u0420\u041c \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + activeSormProjects.size());
        for (SormProject sormProject : activeSormProjects) {
            try {
                this.getLogger().info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0440\u043e\u0435\u043a\u0442\u0430: " + sormProject.getTitle());
                int uploadType = this.taskSetup.getInt("typeUpload." + sormProject.getId(), 0);
                this.getLogger().info("\u0422\u0438\u043f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + (uploadType == 1 ? "\u041f\u043e\u043b\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430" : "\u0418\u043d\u043a\u0440\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f"));
                boolean isFullUpload = uploadType == 1;
                SormProjectUpload.Builder uploadBuilder = SormProjectUpload.newUploadBuilder(this.getModuleId(), sormProject);
                if (isFullUpload) {
                    uploadBuilder.fullUploadWithoutPayments();
                } else {
                    uploadBuilder.uploadWithoutPayments();
                }
                uploadBuilder.build().startUpload();
                this.getLogger().info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 " + sormProject.getTitle() + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
            }
            catch (BGException ex) {
                this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c: " + sormProject.getTitle() + " \u0422\u0435\u043a\u0441\u0442 \u043e\u0448\u0438\u0431\u043a\u0438: " + ex.getMessage());
            }
        }
    }

    public String getDescription() {
        return "\u0421\u041e\u0420\u041c. \u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432";
    }

    public List<TaskParameter> taskParameters() {
        return this.getActiveSormProjects().stream().map(sormProject -> new TaskParameter().setKey("typeUpload." + sormProject.getId()).setTitle("\u0422\u0438\u043f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438, 0-\u0438\u043d\u043a\u0440\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f(\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c), 1-\u043f\u043e\u043b\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430").setDefaultValue("0")).collect(Collectors.toList());
    }
}

