/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.extension.DefaultClassExtension;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.LocationUploader;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.UploadFileRow;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.AddressObj;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.FiasCity;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.FiasStreet;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasUploadService;
import ru.bitel.bgbilling.plugins.fias.server.bean.AddressLoadManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.fias.common.service.FiasUploadService")
public class FiasUploadServiceImpl
extends AbstractService
implements FiasUploadService {
    protected AddressLoadManager lm;
    protected Map<Integer, FiasCity> cityMap;
    protected Set<Integer> cityStreetLoad = new HashSet<Integer>();
    protected Map<Integer, FiasStreet> streetyMap = new HashMap<Integer, FiasStreet>();

    public Result<UploadFileRow> uploadFor122() throws BGMessageException, BGException {
        try {
            Connection con = this.getConnection();
            this.lm = new AddressLoadManager(con);
            Set exclude = Utils.toSet((String)Setup.getSetup().get("find.location.upload.module.exclude")).stream().map(Integer::parseInt).collect(Collectors.toSet());
            ArrayList<UploadFileRow> list = new ArrayList<UploadFileRow>();
            for (LocationUploader uploader : ModuleCache.getInstance().extensionListForPoint((DefaultClassExtension)new LocationUploader(-1), LocationUploader.class.getName())) {
                if (exclude.contains(uploader.getmoduleId())) continue;
                uploader.init(con);
                for (UploadFileRow row : uploader.getRowList()) {
                    String fullString = this.getStreetFull(row);
                    if (fullString == null) continue;
                    row.setFullStreet(fullString);
                    list.add(row);
                }
            }
            return new Result(list);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private String getStreetFull(UploadFileRow row) throws BGException {
        FiasCity city = this.getCity(row.getCityId());
        if (city == null) {
            return null;
        }
        FiasStreet street = this.getStreet(row.getCityId(), row.getStreetId());
        if (street == null) {
            return null;
        }
        return street.getFullTitle(city);
    }

    private Map<Integer, FiasCity> getCityMap() throws BGException {
        return this.lm.getCityList().stream().collect(Collectors.toMap(AddressObj::getId, i -> i));
    }

    private FiasCity getCity(int cityId) throws BGException {
        if (this.cityMap == null) {
            this.cityMap = this.getCityMap();
        }
        return this.cityMap.get(cityId);
    }

    private FiasStreet getStreet(int cityId, int streetId) throws BGException {
        if (!this.cityStreetLoad.contains(cityId)) {
            this.streetyMap.putAll(this.lm.getStreetList(this.cityMap.get(cityId)).stream().collect(Collectors.toMap(AddressObj::getId, i -> i)));
            this.cityStreetLoad.add(cityId);
        }
        return this.streetyMap.get(streetId);
    }
}

