/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.CheckTransactionArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.CheckTransactionResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.GenericParam;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.GenericResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.GetStatementArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.GetStatementResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.PerformTransactionArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.PerformTransactionResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.ProviderWebService;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.ProviderWebService_Service;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.test.com.provider.uws.TransactionStatement;
import ru.bitel.common.TimeUtils;

public class PaynetTest {
    ProviderWebService service = new ProviderWebService_Service().getProviderWebService();

    public static void main(String[] args) {
        PaynetTest test = new PaynetTest();
        test.performTransactionTest();
        test.checkTransactionTest();
        test.getStatementTest();
    }

    private void getStatementTest() {
        System.out.println("getStatementTest");
        GetStatementArguments arguments = new GetStatementArguments();
        arguments.setPassword("password");
        arguments.setUsername("user");
        arguments.setServiceId(1L);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(2016, 3, 1);
        arguments.setDateFrom(this.getTimestamp(calendar));
        calendar.set(5, 25);
        arguments.setDateTo(this.getTimestamp(calendar));
        GenericParam param = new GenericParam();
        param.setParamKey("clientId");
        param.setParamValue("artur_test");
        arguments.getParameters().add(param);
        GetStatementResult result = this.service.getStatement(arguments);
        this.printStatus(result);
        for (TransactionStatement st : result.getStatements()) {
            long amount = st.getAmount();
            long bgId = st.getProviderTrnId();
            long trId = st.getTransactionId();
            GregorianCalendar dt = st.getTransactionTime().toGregorianCalendar();
            System.out.println("\tamount : " + amount + "; bgId = " + bgId + "; trId = " + trId + "; trDate = " + TimeUtils.format((Calendar)dt, (String)"dd.MM.yyyy HH:mm:ss"));
        }
    }

    private void checkTransactionTest() {
        System.out.println("CheckTransactionTest");
        CheckTransactionArguments arguments = new CheckTransactionArguments();
        arguments.setPassword("password");
        arguments.setUsername("user");
        arguments.setTransactionId(123456L);
        arguments.setTransactionTime(this.getTimestamp(new GregorianCalendar()));
        GenericParam param = new GenericParam();
        param.setParamKey("clientId");
        param.setParamValue("artur_test");
        arguments.getParameters().add(param);
        CheckTransactionResult result = this.service.checkTransaction(arguments);
        this.printStatus(result);
        long bgId = result.getProviderTrnId();
        int status = result.getStatus();
        int trState = result.getTransactionState();
        int state = result.getTransactionStateErrorStatus();
        String stateMsg = result.getTransactionStateErrorMsg();
        System.out.println("\t bgId = " + bgId + "; status = " + status + "; trState = " + trState + "; trStateStatus = " + state + "; trStateMsg = " + stateMsg);
    }

    private void printStatus(GenericResult result) {
        String msg = result.getErrorMsg();
        int status = result.getStatus();
        GregorianCalendar dt = result.getTimeStamp().toGregorianCalendar();
        System.out.println("\tstatus = " + status + "; msg = " + msg + "; timestamp = " + TimeUtils.format((Calendar)dt, (String)"dd.MM.yyyy HH:mm:ss"));
    }

    private void performTransactionTest() {
        System.out.println("PerformTransactionTest");
        PerformTransactionArguments arguments = new PerformTransactionArguments();
        arguments.setPassword("password");
        arguments.setUsername("user");
        GenericParam param = new GenericParam();
        param.setParamKey("clientId");
        param.setParamValue("artur_test");
        arguments.getParameters().add(param);
        arguments.setAmount(10249L);
        arguments.setServiceId(1L);
        arguments.setTransactionId(111119L);
        arguments.setTransactionTime(this.getTimestamp(new GregorianCalendar()));
        PerformTransactionResult result = this.service.performTransaction(arguments);
        this.printStatus(result);
        long bgId = result.getProviderTrnId();
        System.out.println("\t bgId = " + bgId);
    }

    private XMLGregorianCalendar getTimestamp(GregorianCalendar calendar) {
        XMLGregorianCalendar result = null;
        try {
            result = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        return result;
    }
}

