/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.email.server.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.EmailServiceActivator;
import ru.bitel.bgbilling.modules.email.server.bean.LdapEmailServiceActivator;
import ru.bitel.bgbilling.modules.email.server.bean._DomainManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class DomainManager
extends AbstractIdDao<ru.bitel.bgbilling.modules.email.common.bean.Domain> {
    private final Map<String, SoftReference<EmailServiceActivator>> serviceActivatorMap = Collections.synchronizedMap(new HashMap());

    public DomainManager(Connection con, int moduleId) {
        super(con, moduleId, "email_domain");
    }

    protected ru.bitel.bgbilling.modules.email.common.bean.Domain getFromRS(ResultSet rs) throws SQLException {
        return ru.bitel.bgbilling.modules.email.common.bean.Domain.builder().setId(rs.getInt("id")).setName(rs.getString("name")).setParams(rs.getString("params")).setComment(rs.getString("comment")).setPos(rs.getInt("pos")).build();
    }

    protected void updateImpl(ru.bitel.bgbilling.modules.email.common.bean.Domain domain) throws SQLException {
        String querySet = "name=?, params=?, comment=?, pos=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)domain, querySet);){
            int index = 1;
            ps.setString(index++, domain.getName());
            ps.setString(index++, domain.getParams());
            ps.setString(index++, domain.getComment());
            ps.setInt(index++, domain.getPos());
            this.executeUpdate((Id)domain, index, ps);
        }
    }

    public ru.bitel.bgbilling.modules.email.common.bean.Domain get(int id) throws SQLException {
        int inheritFrom;
        ru.bitel.bgbilling.modules.email.common.bean.Domain result = (ru.bitel.bgbilling.modules.email.common.bean.Domain)super.get(id);
        if (result == null) {
            this.importFromOld();
            result = (ru.bitel.bgbilling.modules.email.common.bean.Domain)super.get(id);
        }
        if (result != null && (inheritFrom = result.getParameterMap().getInt("inherit", -1)) > 0) {
            ru.bitel.bgbilling.modules.email.common.bean.Domain ancestor = (ru.bitel.bgbilling.modules.email.common.bean.Domain)super.get(inheritFrom);
            if (ancestor != null) {
                result.inherit(ancestor);
            } else {
                this.getLogger().error("Domain ancestor not found [id=" + inheritFrom + "]");
            }
        }
        return result;
    }

    public List<ru.bitel.bgbilling.modules.email.common.bean.Domain> list(String order) throws SQLException {
        List result;
        if (Utils.isBlankString((String)order)) {
            order = "name";
        }
        if ((result = super.list(null, order, new Object[0])).size() == 0) {
            this.importFromOld();
            result = super.list(null, order, new Object[0]);
        }
        Map map = Id.newMap((List)result);
        for (ru.bitel.bgbilling.modules.email.common.bean.Domain domain : result) {
            int inheritFrom = domain.getParameterMap().getInt("inherit", -1);
            if (inheritFrom <= 0) continue;
            ru.bitel.bgbilling.modules.email.common.bean.Domain ancestor = (ru.bitel.bgbilling.modules.email.common.bean.Domain)map.get(inheritFrom);
            if (ancestor != null) {
                int ancestorInheritFrom = ancestor.getParameterMap().getInt("inherit", -1);
                if (ancestorInheritFrom > 0) {
                    this.getLogger().error("Multiplie ancestors [id= " + domain.getId() + " => " + inheritFrom + " => " + ancestorInheritFrom + "]");
                }
                domain.inherit(ancestor);
                continue;
            }
            this.getLogger().error("Domain ancestor not found [id=" + inheritFrom + "]");
        }
        return result;
    }

    public EmailServiceActivator getServiceActivator(ru.bitel.bgbilling.modules.email.common.bean.Domain domain) throws BGException {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String className = domain.getParameterMap().get("sa", moduleSetup.get("sa", "ru.bitel.bgbilling.modules.email.server.bean.LdapEmailServiceActivator")).trim();
        SoftReference<EmailServiceActivator> ref = this.serviceActivatorMap.get(this.moduleId + "_" + className);
        EmailServiceActivator sa = ref != null ? ref.get() : null;
        try {
            if (sa == null) {
                Class<EmailServiceActivator> clazz = Class.forName(className).asSubclass(EmailServiceActivator.class);
                sa = clazz.getConstructor(ru.bitel.bgbilling.modules.email.common.bean.Domain.class, ParameterMap.class).newInstance(domain, moduleSetup);
                this.serviceActivatorMap.put(this.moduleId + "_" + className, new SoftReference<EmailServiceActivator>(sa));
            }
            return sa;
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            return new LdapEmailServiceActivator(domain, (ParameterMap)moduleSetup);
        }
    }

    private void add(ru.bitel.bgbilling.modules.email.common.bean.Domain domain) throws SQLException {
        Objects.requireNonNull(domain);
        String query = "INSERT INTO email_domain_" + this.moduleId + " (id, name, params, comment, pos) VALUES (?, ?, ?, ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, domain.getId());
            ps.setString(2, domain.getName());
            ps.setString(3, domain.getParams());
            ps.setString(4, domain.getComment());
            ps.setInt(5, domain.getPos());
            ps.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFromOld() throws SQLException {
        Class<DomainManager> clazz = DomainManager.class;
        synchronized (DomainManager.class) {
            if (super.list(null, null, new Object[0]).size() > 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.getLogger().info("Importing domains from config (old format)...");
            _DomainManager dm = new _DomainManager((Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
            for (Domain d : dm.getDomainList()) {
                this.getLogger().info(d.getName());
                ru.bitel.bgbilling.modules.email.common.bean.Domain domain = new ru.bitel.bgbilling.modules.email.common.bean.Domain();
                domain.setId(d.getId());
                domain.setName(d.getName());
                domain.setComment("");
                StringBuilder params = new StringBuilder();
                if (d.getLikeId() > 0) {
                    params.append("inherit=").append(d.getLikeId());
                } else {
                    params.append("sa=").append("ru.bitel.bgbilling.modules.email.server.bean.LdapEmailServiceActivator").append("\n");
                    params.append("sa.ldap.class=").append(d.getDriverClass()).append("\n");
                    params.append("sa.ldap.host=").append(d.getLDAPHost()).append("\n");
                    params.append("sa.ldap.port=").append(d.getLDAPPort()).append("\n");
                    params.append("sa.ldap.root=").append(d.getLDAPRootNode()).append("\n");
                    params.append("sa.ldap.user=").append(d.getLDAPUser()).append("\n");
                    params.append("sa.ldap.password=").append(d.getLDAPPassword()).append("\n");
                    params.append("sa.ldap.base=").append(d.getBase()).append("\n");
                    if (d.getAddAttributes() != null && d.getAddAttributes().size() > 0) {
                        params.append("sa.ldap.addattr=");
                        for (Map.Entry<String, String> e : d.getAddAttributes().entrySet()) {
                            params.append(e.getKey()).append(":").append(e.getValue()).append(";");
                        }
                    }
                }
                domain.setParams(params.toString());
                this.add(domain);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

