/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractTryAndBuy;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Period;

public class MegogoContractTryAndBuyDao
extends AbstractIdDao<MegogoContractTryAndBuy> {
    public MegogoContractTryAndBuyDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_try_and_buy");
    }

    public MegogoContractTryAndBuy getContractTBByIdSub(int idSub) throws SQLException {
        return (MegogoContractTryAndBuy)this.get("idSub=?", new Object[]{idSub});
    }

    public List<MegogoContractTryAndBuy> getContractTBList(int contractId, Period period, int idTB) throws SQLException {
        String query = "SELECT mctab.*, mtab.title FROM " + this.tableName + " AS mctab LEFT JOIN megogo_try_and_buy_" + this.moduleId + " AS mtab ON mctab.idTB=mtab.id WHERE 1=1";
        if (contractId > 0) {
            query = query + " AND contractId=" + contractId;
        }
        if (idTB > 0) {
            query = query + " AND idTB=" + idTB;
        }
        if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
            query = query + " AND dateFrom<=? AND dateTo>=?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            }
            ArrayList<MegogoContractTryAndBuy> list = new ArrayList<MegogoContractTryAndBuy>();
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    MegogoContractTryAndBuy contractTryAndBuy = this.getFromRS(rs);
                    contractTryAndBuy.setTitle(rs.getString("mtab.title"));
                    list.add(contractTryAndBuy);
                }
            }
            ArrayList<MegogoContractTryAndBuy> arrayList = list;
            return arrayList;
        }
    }

    protected MegogoContractTryAndBuy getFromRS(ResultSet rs) throws SQLException {
        MegogoContractTryAndBuy contractTryAndBuy = new MegogoContractTryAndBuy();
        contractTryAndBuy.setContractId(rs.getInt("contractId"));
        contractTryAndBuy.setId(rs.getInt("id"));
        contractTryAndBuy.setIdTB(rs.getInt("idTB"));
        contractTryAndBuy.setIdSub(rs.getInt("idSub"));
        contractTryAndBuy.setPeriod(new Period((Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo")));
        contractTryAndBuy.setUserId(rs.getInt("userId"));
        return contractTryAndBuy;
    }

    protected void updateImpl(MegogoContractTryAndBuy contractTB) throws SQLException {
        Objects.requireNonNull(contractTB);
        if (contractTB.getPeriod() == null) {
            throw new BGRuntimeException("contractTB.getPeriod() == null");
        }
        String querySet = "contractId=?, idTB=?, idSub=?, dateFrom=?, dateTo=?, userId=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)contractTB, querySet);){
            int index = 1;
            ps.setInt(index++, contractTB.getContractId());
            ps.setInt(index++, contractTB.getIdTB());
            ps.setInt(index++, contractTB.getIdSub());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractTB.getPeriod().getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)contractTB.getPeriod().getDateTo()));
            ps.setInt(index++, contractTB.getUserId());
            this.executeUpdate((Id)contractTB, index, ps);
        }
    }
}

