/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import ru.bitel.bgbilling.kernel.auth.ModuleAuth;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;

public class ModuleAuthImpl
extends BGLogger
implements ModuleAuth {
    public ModuleUser findModuleUserByLogin(String login, int moduleId, int authMode, Connection con) {
        ModuleUser moduleUser = null;
        if (login != null && login.trim().length() > 0 && moduleId > -1) {
            String query = "SELECT t1.cid, t1.pswd, t2.title FROM trayinfo_login_" + moduleId + " AS t1, contract AS t2 WHERE t1.id=? AND t1.cid=t2.id AND ( t1.date1 IS NULL OR t1.date1<=NOW() ) AND ( t1.date2 IS NULL OR t1.date2>=NOW() )";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setString(1, login);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        moduleUser = new ModuleUser().setLogin(login).setPassword(rs.getString(2)).setContractId(rs.getInt(1)).setContractTitle(rs.getString(3));
                    }
                }
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return moduleUser;
    }
}

