/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelContract;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class RunTelDao
extends AbstractDao<RunTelContract> {
    public RunTelDao(Connection con, int moduleId) {
        super(con, "", moduleId);
    }

    public void searchContracts(SearchResult<RunTelContract> searchResult, int emailParameterId) throws SQLException {
        String query = "SELECT c.id, c.title, c.comment, c.date1, c.date2, c.status, e.email  FROM contract_module AS cm LEFT JOIN contract AS c ON c.id=cm.cid LEFT JOIN contract_parameter_type_3 AS e ON c.id=e.cid AND e.pid=?  WHERE cm.mid=?";
        List contracts = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, emailParameterId);
            ps.setInt(index++, this.moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String[] emailArray = null;
                    String emails = rs.getString("e.email");
                    if (Utils.notBlankString((String)emails)) {
                        emailArray = emails.split("\n");
                    }
                    RunTelContract runTelContract = new RunTelContract().setContractId(rs.getInt("c.id")).setContractTitle(rs.getString("c.title")).setContractComment(rs.getString("c.comment")).setPeriod(new Period((Date)rs.getDate("c.date1"), (Date)rs.getDate("c.date2"))).setStatus(rs.getInt("c.status")).setEmail(emailArray != null && emailArray.length > 0 ? emailArray[0] : null);
                    contracts.add(runTelContract);
                }
            }
        }
    }

    protected RunTelContract getFromRS(ResultSet rs) throws SQLException {
        return null;
    }

    protected void updateImpl(RunTelContract b) throws SQLException {
    }
}

