/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class BotDialogElementDao
extends AbstractIdDao<BotDialogElement> {
    public BotDialogElementDao(Connection connection, int moduleId) {
        this(connection, moduleId, "bot_dialog_elements");
    }

    private BotDialogElementDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public BotDialogElement getElement(int id) throws SQLException {
        BotDialogElement element;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=" + id;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            element = this.getFromRS(rs);
        }
        return element;
    }

    public List<BotDialogElement> getElements() throws SQLException {
        return super.list(null, "sort", new Object[0]);
    }

    public List<BotDialogElement> getElementsByIds(String ids) throws SQLException {
        ArrayList<BotDialogElement> result = new ArrayList<BotDialogElement>();
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN(" + ids + ") order by id";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        List idsList = Utils.toIntegerList((String)ids);
        result.sort(Comparator.comparingInt(el -> idsList.indexOf(el.getId())));
        return result;
    }

    public List<BotDialogElement> getElementsByIds(List<Integer> ids) throws SQLException {
        return this.getElementsByIds(Utils.toString(ids, (String)","));
    }

    public List<BotDialogElement> getElementsOfDialog(int dialogId) throws SQLException {
        ArrayList<BotDialogElement> elements = new ArrayList<BotDialogElement>();
        String query = "SELECT * FROM " + this.tableName + " WHERE dialog_ids LIKE '" + dialogId + "'";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                elements.add(this.getFromRS(rs));
            }
        }
        return elements;
    }

    protected BotDialogElement getFromRS(ResultSet rs) throws SQLException {
        BotDialogElement element = new BotDialogElement();
        element.setId(rs.getInt("id"));
        element.setElementType(BotDialogElementType.getElementType((int)rs.getInt("element_type")));
        element.setDialogIds(Utils.toIntegerSet((String)rs.getString("dialog_ids")));
        element.setConfigElement(rs.getString("config"));
        element.setSortPosition(rs.getInt("sort"));
        return element;
    }

    protected void updateImpl(BotDialogElement dialogElement) throws SQLException {
        this.updateElement(dialogElement);
    }

    public int updateElement(BotDialogElement element) throws SQLException {
        String querySet = "dialog_ids=?, element_type=?, config=?, sort=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)element, querySet);){
            int index = 1;
            ps.setString(index++, Utils.toString((Iterable)element.getDialogIds(), (String)","));
            ps.setInt(index++, element.getElementType().ordinal());
            ps.setString(index++, element.getConfigElement());
            ps.setInt(index++, element.getSortPosition());
            this.executeUpdate((Id)element, index, ps);
            if (element.getId() <= 0) {
                element.setSortPosition(this.updateSortPosition(element.getId()));
            }
        }
        return element.getId();
    }

    private int updateSortPosition(int elementId) throws SQLException {
        int newSortPosition = 0;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery("select MAX(sort) as sort from " + this.tableName);){
            if (rs.next()) {
                newSortPosition = rs.getInt("sort");
            }
        }
        st = this.con.createStatement();
        try {
            st.executeUpdate("UPDATE " + this.tableName + " set sort=" + newSortPosition + " where id=" + elementId);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        return newSortPosition;
    }

    public synchronized void updateSortingElements(Map<Integer, Integer> elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        Setup setup = Setup.getSetup();
        Connection connection = setup.getDBConnectionFromPool();
        new Thread(() -> {
            try (Statement statement = connection.createStatement();){
                for (Integer key : elements.keySet()) {
                    String update = "UPDATE " + this.tableName + " SET sort=" + String.valueOf(elements.get(key)) + " WHERE id=" + key;
                    statement.addBatch(update);
                }
                statement.executeBatch();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }).start();
    }
}

