/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.restriction;

import java.util.Calendar;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServRestriction;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffRequest;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.common.RangeUtils;

public abstract class InetServRestrictionRuntime {
    protected final int id;
    protected final long timeFrom;
    protected final long timeTo;
    protected final int type;

    public int getType() {
        return this.type;
    }

    public InetServRestrictionRuntime(InetServRestriction restriction, Calendar utilCalendar) {
        this.id = restriction.getId();
        this.timeFrom = InetUtils.dateFrom(restriction.getDateFrom(), utilCalendar);
        this.timeTo = InetUtils.dateTo(restriction.getDateTo(), utilCalendar);
        this.type = restriction.getType();
    }

    public Integer test(InetTariffWorkerContext workerContext, InetApplication application, InetServRuntime inetServRuntime, InetConnectionRuntime connectionRuntime, InetTariffRequest req) throws BGException {
        long millis;
        long l = millis = req != null ? req.getTime().getTimeInMillis() : System.currentTimeMillis();
        if (!RangeUtils.inRange((long)millis, (long)millis, (long)this.timeFrom, (long)this.timeTo)) {
            return null;
        }
        return this.testImpl(workerContext, application, inetServRuntime, connectionRuntime, req);
    }

    protected abstract Integer testImpl(InetTariffWorkerContext var1, InetApplication var2, InetServRuntime var3, InetConnectionRuntime var4, InetTariffRequest var5) throws BGException;
}

