/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server;

import bitel.billing.server.contract.bean.ContractScriptManager;
import bitel.billing.server.script.bean.Function;
import bitel.billing.server.script.bean.FunctionManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventKey;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.script.common.ScriptFunctionModifiedEvent;
import ru.bitel.bgbilling.kernel.script.common.bean.EventType;
import ru.bitel.bgbilling.kernel.script.server.bean.EventTypeManager;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerThreadFactory;

public class ScriptEventListener
implements EventListener<Event> {
    private static final Logger logger;
    private final DefaultServerSetup setup;
    private final Function function;
    private final ScriptInstance scriptInstance;
    private final boolean logProcess;
    private final AtomicInteger checkCount = new AtomicInteger();
    private final Worker worker;
    private static final ScriptEventListener EMPTY_LISTENER;
    private static volatile boolean STARTED;
    private static boolean AUTO_COMMIT;

    public ScriptEventListener(DefaultServerSetup setup, Function function, boolean logProcess) throws BGException {
        this.setup = setup;
        this.logProcess = logProcess;
        this.function = function;
        this.scriptInstance = new ScriptInstance(function);
        this.worker = function.getScript() == null || ScriptInstance.methodExist(function, "onEvent") ? new Invoker(this.scriptInstance) : new Worker(this.scriptInstance);
    }

    public void init() throws BGException {
        block8: {
            try {
                if (!(this.worker instanceof Invoker)) break block8;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                PrintStream outPrintStream = new PrintStream(out);
                PrintStream errPrintStream = new PrintStream(err);
                StringBuilder warnings = new StringBuilder();
                Throwable error = null;
                try {
                    this.scriptInstance.eval(outPrintStream, errPrintStream, null);
                    if (this.checkCount.get() < 100) {
                        this.checkCount.incrementAndGet();
                        ScriptInstance.DeprecatedCheker.checkOnDeprecated(this.scriptInstance.getInterpreter(), this.scriptInstance, warnings);
                    }
                }
                catch (Throwable ex) {
                    error = ex;
                }
                outPrintStream.flush();
                errPrintStream.flush();
                if (out.size() > 0) {
                    logger.info(out.toString());
                }
                if (err.size() > 0) {
                    logger.error(err.toString());
                }
                if (error != null) {
                    throw error;
                }
            }
            catch (Throwable ex) {
                throw new BGException("Error init script event listener for " + String.valueOf((Object)this.scriptInstance.getScript()), ex);
            }
        }
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptEventListener other = (ScriptEventListener)obj;
        return !(this.function == null ? other.function != null : !this.function.equals((Object)other.function));
    }

    public String toString() {
        return String.valueOf((Object)this.function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event e, EventListenerContext ctx) {
        BGNestedContext.push((String)"script");
        ConnectionSet connectionSet = ctx.getConnectionSet();
        boolean autoCommit = connectionSet.getAutoCommit();
        try {
            if (AUTO_COMMIT && !(e instanceof LocalEvent)) {
                connectionSet.setAutoCommit(true);
            }
            if (e.getContractId() == -1 || this.function.getScriptId() == -1) {
                this.runScript(ctx, connectionSet, e);
            } else {
                for (ContractScript contractScript : new ContractScriptManager(connectionSet.getConnection()).getContractScriptList(e.getContractId(), new GregorianCalendar())) {
                    if (contractScript.getScriptId() != this.function.getScriptId()) continue;
                    this.runScript(ctx, connectionSet, e);
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            connectionSet.setAutoCommit(autoCommit);
            BGNestedContext.pop();
        }
    }

    private final void runScript(EventListenerContext ctx, ConnectionSet connectionSet, Event e) {
        long time = System.currentTimeMillis();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream outPrintStream = new PrintStream(out);
        PrintStream errPrintStream = new PrintStream(err);
        StringBuilder warnings = new StringBuilder();
        StringWriter exceptions = new StringWriter();
        try {
            logger.info("Caught event: " + e.getClass().getName());
            this.runScript(this.setup, ctx, connectionSet, e, outPrintStream, errPrintStream);
            if (this.checkCount.get() < 100) {
                this.checkCount.incrementAndGet();
                ScriptInstance.DeprecatedCheker.checkOnDeprecated(this.scriptInstance.getInterpreter(), this.scriptInstance, warnings);
            }
        }
        catch (Throwable ex) {
            logger.error("Eval error: " + ex.getMessage(), ex);
            exceptions.append(ex.getMessage()).append("\n");
            ex.printStackTrace(new PrintWriter(exceptions));
        }
        long processTime = System.currentTimeMillis() - time;
        logger.info("Process time => " + processTime);
        outPrintStream.flush();
        errPrintStream.flush();
        if (out.size() > 0) {
            logger.info(out.toString());
        }
        if (err.size() > 0) {
            logger.error(err.toString());
        }
        if (this.logProcess && e.isLogFunctionProcess()) {
            FunctionManager.logFunctionProcess(this.setup, connectionSet, e.getTime(), e.getContractId(), this.function.getTitle(), out.toString(), err.toString(), exceptions.toString(), warnings.toString(), processTime, logger);
        }
    }

    protected Object runScript(DefaultServerSetup setup, EventListenerContext ctx, ConnectionSet connectionSet, Event event, PrintStream outPrintStream, PrintStream errPrintStream) throws Exception {
        return this.worker.runScriptImpl(setup, connectionSet, event, outPrintStream, errPrintStream);
    }

    private static Set<EventKey> getEventTypeKeys(Connection con, boolean local) throws BGException {
        HashSet<EventKey> eventTypes = new HashSet<EventKey>();
        for (EventType e : new EventTypeManager(con).getEventTypeList(-1)) {
            EventKey eventKey;
            if (Utils.parseInt((String)e.getEventId(), (int)-1) != -1 || (eventKey = ScriptEventListener.parse(e.getModuleId(), e.getEventId())) == null || local && !LocalEvent.class.isAssignableFrom(eventKey.clazz)) continue;
            eventTypes.add(eventKey);
        }
        return eventTypes;
    }

    private static EventKey parse(String moduleIdOrPluginId, String eventType) {
        try {
            URI eventURI = new URI(eventType);
            String event = eventURI.getPath();
            String query = eventURI.getQuery();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(event);
            }
            catch (ClassNotFoundException e) {
                try {
                    clazz = DynamicClassManager.getInstance().loadClass(event);
                }
                catch (Exception ex) {
                    logger.warn("Skip event type " + eventType + ". Class not found for this application.");
                }
            }
            if (clazz != null) {
                Class<Event> eventClazz = clazz.asSubclass(Event.class);
                int moduleId = Utils.parseInt((String)moduleIdOrPluginId, (int)-1);
                int pluginId = moduleIdOrPluginId.startsWith("p") ? Utils.parseInt((String)moduleIdOrPluginId.substring(1), (int)-1) : -1;
                return new EventKey(eventClazz, moduleId, pluginId, query);
            }
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEventListener linkFunction(DefaultServerSetup setup, Function f, Set<EventKey> eventTypes, boolean logProcess) throws BGException {
        EventProcessor processor;
        int timeout = setup.getInt("script.timeout", 600);
        eventTypes = new HashSet<EventKey>(eventTypes);
        ArrayList<EventKey> links = new ArrayList<EventKey>();
        ArrayList<String> keys = new ArrayList<String>();
        for (String s : f.getEventTypeIdList()) {
            EventKey eventKey;
            String[] ss = s.split("_");
            if (ss.length <= 1 || Utils.parseInt((String)ss[1], (int)-1) != -1 || (eventKey = ScriptEventListener.parse(ss[0], ss[1])) == null || !eventTypes.contains(eventKey)) continue;
            links.add(eventKey);
            keys.add(EventProcessor.getKey(eventKey.clazz, eventKey.moduleId, eventKey.pluginId, eventKey.query));
        }
        ScriptEventListener l = timeout >= 0 ? new ThreadedScriptEventListener(setup, f, logProcess, timeout) : new ScriptEventListener(setup, f, logProcess);
        if (links.size() > 0) {
            l.init();
        }
        EventProcessor eventProcessor = processor = EventProcessor.getInstance();
        synchronized (eventProcessor) {
            processor.removeListener(l, keys);
            for (EventKey link : links) {
                if (!QueueEvent.class.isAssignableFrom(link.clazz)) {
                    logger.warn("Linking script event listener to not queue event.");
                }
                processor.updateListener(l, link.clazz, link.moduleId, link.pluginId, link.query);
            }
        }
        if (links.size() > 0) {
            return l;
        }
        return null;
    }

    public static void start(final DefaultServerSetup setup, final boolean local) throws BGException {
        if (STARTED) {
            logger.error("Already started");
            return;
        }
        STARTED = true;
        AUTO_COMMIT = !local && Setup.getSetup().getInt("script.autoCommit", 0) > 0;
        EventProcessor.getInstance().addListener(new EventListener<ScriptFunctionModifiedEvent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notify(ScriptFunctionModifiedEvent e, EventListenerContext ctx) {
                BGNestedContext.push((String)"script");
                logger.info("Script event function  was modified. (Re)linking function...");
                try {
                    this.fixFunction(setup, e.getFunctionId());
                    ScriptEventListener.relinkFunctions(setup, local);
                }
                catch (BGException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    BGNestedContext.pop();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fixFunction(DefaultServerSetup setup2, int functionId) throws BGException {
                Connection con = setup2.getDBConnectionFromPool();
                try {
                    boolean logProcess;
                    Set<EventKey> eventTypes = ScriptEventListener.getEventTypeKeys(con, local);
                    boolean bl = logProcess = setup2.getInt("log.function.process", 0) > 0;
                    if (functionId > 0) {
                        Function function = new FunctionManager(con).getFunctionById(functionId);
                        if (function == null) {
                            function = new Function();
                            function.setId(functionId);
                        }
                        ScriptEventListener.linkFunction(setup2, function, eventTypes, logProcess);
                    }
                }
                finally {
                    ServerUtils.closeConnection(con);
                }
            }
        }, ScriptFunctionModifiedEvent.class);
        BGNestedContext.push((String)"script");
        logger.info("Starting ScriptEventListener...");
        try {
            ScriptEventListener.relinkFunctions(setup, local);
        }
        finally {
            BGNestedContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void relinkFunctions(DefaultServerSetup setup, boolean local) throws BGException {
        logger.info("Relinking script functions.");
        boolean logProcess = setup.getInt("log.function.process", 0) > 0;
        Connection con = setup.getDBConnectionFromPool();
        try {
            EventProcessor processor;
            EventProcessor eventProcessor = processor = EventProcessor.getInstance();
            synchronized (eventProcessor) {
                Set<EventKey> eventTypes = ScriptEventListener.getEventTypeKeys(con, local);
                for (Function f : new FunctionManager(con).getEventProcessFunctions()) {
                    if (logger.isInfoEnabled()) {
                        logger.debug("Try linking " + String.valueOf((Object)f));
                    }
                    try {
                        ScriptEventListener l = ScriptEventListener.linkFunction(setup, f, eventTypes, logProcess);
                        if (!logger.isInfoEnabled() || l == null) continue;
                        logger.info("Linked " + String.valueOf((Object)f));
                    }
                    catch (BGException e) {
                        logger.error("ERROR link " + String.valueOf((Object)f) + ". " + e.getMessage(), (Throwable)e);
                    }
                }
                ScriptEventListener.updateEmptyListener(processor, con, local);
            }
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateEmptyListener(EventProcessor processor, Connection con, boolean local) throws BGException {
        EventProcessor eventProcessor = processor;
        synchronized (eventProcessor) {
            if (local) {
                return;
            }
            processor.removeListener(EMPTY_LISTENER);
            Set<EventKey> eventTypes = ScriptEventListener.getEventTypeKeys(con, local);
            List<EventKey> events = processor.getListeningEventKeys();
            for (EventKey key : events) {
                eventTypes.remove(key);
            }
            for (EventKey key : eventTypes) {
                if (!QueueEvent.class.isAssignableFrom(key.clazz) || LocalEvent.class.isAssignableFrom(key.clazz)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Add empty listener to " + String.valueOf(key));
                }
                processor.updateListener(EMPTY_LISTENER, key.clazz, key.moduleId, key.pluginId, key.query);
            }
        }
    }

    static {
        EmptyScriptEventListener l;
        logger = LogManager.getLogger();
        try {
            l = new EmptyScriptEventListener();
        }
        catch (BGException e) {
            l = null;
            logger.error(e.getMessage(), (Throwable)e);
        }
        EMPTY_LISTENER = l;
        STARTED = false;
        AUTO_COMMIT = false;
    }

    static final class Invoker
    extends Worker {
        public Invoker(ScriptInstance scriptInstance) {
            super(scriptInstance);
        }

        @Override
        public Object runScriptImpl(DefaultServerSetup setup, ConnectionSet connectionSet, Event event, PrintStream out, PrintStream err) throws Exception {
            return this.scriptInstance.invoke("onEvent", new Object[]{event, setup, connectionSet.getConnection(), connectionSet.getSlaveConnection()}, out, err);
        }
    }

    static class Worker {
        final ScriptInstance scriptInstance;

        public Worker(ScriptInstance scriptInstance) {
            this.scriptInstance = scriptInstance;
        }

        public Object runScriptImpl(DefaultServerSetup setup, ConnectionSet connectionSet, Event event, PrintStream out, PrintStream err) throws Exception {
            logger.warn("You are using old function definition! Use \"void onEvent( e, setup, con, conSlave ) {}\" instead!");
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("event", event);
            params.put("setup", (Object)setup);
            params.put("con", connectionSet.getConnection());
            params.put("conSlave", connectionSet.getSlaveConnection());
            return this.scriptInstance.eval(out, err, params);
        }
    }

    public static final class ThreadedScriptEventListener
    extends ScriptEventListener {
        private static final ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new WorkerThreadFactory("scrpt-evnt-lstnr", null, null));
        private final long seconds;

        public ThreadedScriptEventListener(DefaultServerSetup setup, Function function, boolean logProcess, int timeoutSeconds) throws BGException {
            super(setup, function, logProcess);
            this.seconds = timeoutSeconds;
        }

        @Override
        protected Object runScript(final DefaultServerSetup setup, final EventListenerContext context, final ConnectionSet connectionSet, final Event event, final PrintStream outPrintStream, final PrintStream errPrintStream) throws Exception {
            final Subject subject = Subject.getSubject(AccessController.getContext());
            final AtomicReference thread = new AtomicReference();
            Future<Object> future = executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    thread.set(Thread.currentThread());
                    ThreadContext parentContext = ThreadContext.get();
                    ThreadContext.set((ThreadContext)context);
                    try {
                        if (subject != null) {
                            Object object = Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    return ThreadedScriptEventListener.super.runScript(setup, context, connectionSet, event, outPrintStream, errPrintStream);
                                }
                            });
                            return object;
                        }
                        Object object = ThreadedScriptEventListener.super.runScript(setup, context, connectionSet, event, outPrintStream, errPrintStream);
                        return object;
                    }
                    finally {
                        ThreadContext.set((ThreadContext)parentContext);
                    }
                }
            });
            try {
                return future.get(this.seconds, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                e.setStackTrace(((Thread)thread.get()).getStackTrace());
                future.cancel(true);
                ((Thread)thread.get()).stop();
                throw new ExecutionException("The script execution took more than " + this.seconds + " seconds and was interrupted!", e);
            }
        }
    }

    private static final class EmptyScriptEventListener
    extends ScriptEventListener {
        public EmptyScriptEventListener() throws BGException {
            super(null, EmptyScriptEventListener.nullFunction(), false);
        }

        private static Function nullFunction() {
            Function result = new Function();
            result.setId(-1);
            return result;
        }

        @Override
        public void init() throws BGException {
        }

        @Override
        public void notify(Event e, EventListenerContext ctx) {
        }

        @Override
        public String toString() {
            return "EmptyScriptEventListener";
        }
    }
}

