/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.WebServiceContext;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.FindContractUtils;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.PaynetErrorCode;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.PaynetStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.PaynetTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.ResponceParameters;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.CancelTransactionArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.CancelTransactionResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.ChangePasswordArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.ChangePasswordResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.CheckTransactionArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.CheckTransactionResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.GenericArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.GenericParam;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.GetInformationArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.GetInformationResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.GetStatementArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.GetStatementResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.PerformTransactionArguments;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.PerformTransactionResult;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.ProviderWebService;
import ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.TransactionStatement;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforePaymentEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mps.server.bean.ws.paynet.com.provider.uws.ProviderWebService")
public class ProviderWebServiceImpl
extends AbstractService
implements ProviderWebService {
    @Resource
    private WebServiceContext wsc;
    private ModuleSetup moduleSetup;
    private Conf.MPSSystem system;

    @PostConstruct
    private void init() {
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String mpsId = null;
        try {
            mpsId = this.getMpsId();
        }
        catch (PaynetException e) {
            e.printStackTrace();
        }
        this.system = ((Conf)Setup.getSetup().getConfig((int)this.moduleId, Conf.class)).mpsSystems.get(mpsId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PerformTransactionResult performTransaction(PerformTransactionArguments arguments) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043c\u0435\u0442\u043e\u0434\u0430 PerformTransaction");
        }
        PerformTransactionResult result = new PerformTransactionResult();
        try {
            this.authorize(arguments);
            int contractId = this.getContractId(arguments.getParameters());
            long amount = arguments.getAmount();
            long transactionId = arguments.getTransactionId();
            XMLGregorianCalendar trTime = arguments.getTransactionTime();
            int serviceId = (int)arguments.getServiceId();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0445\u043e\u0434\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: amount = " + amount + "; transactionId = " + transactionId + "; serviceId = " + serviceId + "; transactionTime = " + String.valueOf(trTime));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432");
            }
            if (amount <= 0L || transactionId <= 0L || serviceId <= 0) {
                throw new PaynetException(PaynetErrorCode.REQUIRED_PARAMETER_NOT_SPECIFIED);
            }
            String mpsId = this.getMpsId();
            GregorianCalendar transactionTime = trTime != null ? trTime.toGregorianCalendar() : new GregorianCalendar();
            BigDecimal sum = new BigDecimal(amount).divide(new BigDecimal(100));
            if (sum.compareTo(this.system.minSumm) < 0 || sum.compareTo(this.system.maxSumm) > 0) {
                String msg = "\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430! \u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u043e\u0442 " + Utils.formatBigDecimalSumm((BigDecimal)this.system.minSumm) + " \u0434\u043e " + Utils.formatBigDecimalSumm((BigDecimal)this.system.maxSumm);
                throw new PaynetException(PaynetErrorCode.INVALID_SUM, msg);
            }
            int pid = this.moduleSetup.getInt("mps." + mpsId + ".pid." + serviceId, 0);
            if (pid <= 0) throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, "\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 mps.<mpsId>.pid.<serviceId>!");
            PaynetTransactionManager transactionManager = (PaynetTransactionManager)MPSTransactionManager.getInstance(mpsId, this.getSetup(), this.moduleId);
            Transaction transaction = null;
            try {
                transaction = transactionManager.getTransactionByTransId(this.getConnection(), this.moduleId, mpsId, transactionId, transactionTime.getTime());
            }
            catch (Exception e) {
                throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, e.getMessage(), e);
            }
            if (transaction != null) throw new PaynetException(PaynetErrorCode.TRANSACTION_ALREADY_EXIST);
            this.system.paymentType = pid;
            try {
                MPSBeforePaymentEvent event = new MPSBeforePaymentEvent(this.moduleId, sum);
                event = (MPSBeforePaymentEvent)EventProcessor.getInstance().request((QueueEvent)event);
                BigDecimal scriptSum = event.getPaymentSum();
                transaction = transactionManager.addTransaction(-1, this.getConnection(), this.moduleId, mpsId, this.system, contractId, transactionTime.getTime(), scriptSum, sum, String.valueOf(transactionId), this.getClientId(arguments.getParameters()), 0, "");
            }
            catch (Exception e) {
                throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, e.getMessage(), e);
            }
            result.setProviderTrnId(transaction.getId());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u043b\u0430\u0442\u0435\u0436 \u0441 \u043a\u043e\u0434\u043e\u043c " + transaction.getId());
            }
            result.setStatus(PaynetErrorCode.SUCCESS.getErrorCode());
            result.setErrorMsg(PaynetErrorCode.SUCCESS.getErrorMsg());
            result.setTimeStamp(this.getTimestamp(new Date()));
            return result;
        }
        catch (PaynetException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            result.setStatus(e.getErrorCode().getErrorCode());
            result.setErrorMsg(e.getMessage());
            result.setTimeStamp(this.getTimestamp(new Date()));
        }
        return result;
    }

    @Override
    public CheckTransactionResult checkTransaction(CheckTransactionArguments arguments) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043c\u0435\u0442\u043e\u0434\u0430 CheckTransaction");
        }
        CheckTransactionResult result = new CheckTransactionResult();
        try {
            this.authorize(arguments);
            long transactionId = arguments.getTransactionId();
            XMLGregorianCalendar trTime = arguments.getTransactionTime();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0445\u043e\u0434\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: transactionId = " + transactionId + "; transactionTime = " + String.valueOf(trTime));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432");
            }
            if (transactionId <= 0L || trTime == null) {
                throw new PaynetException(PaynetErrorCode.REQUIRED_PARAMETER_NOT_SPECIFIED);
            }
            GregorianCalendar transactionTime = trTime.toGregorianCalendar();
            String mpsId = this.getMpsId();
            MPSTransactionManager transactionManager = MPSTransactionManager.getInstance(mpsId, this.getSetup(), this.moduleId);
            try {
                Transaction transaction = transactionManager.getTransactionByTransId(this.getConnection(), this.moduleId, mpsId, transactionId, transactionTime.getTime());
                if (transaction == null) {
                    throw new PaynetException(PaynetErrorCode.ORDER_IS_NOT_EXIST, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0440\u0430\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + transactionId);
                }
                if (transaction.getStatus().equals(TransactionStatus.PAYMENT_CANCELED.getCode())) {
                    result.setTransactionState(PaynetStatus.CANCEL.getStatus());
                } else {
                    result.setTransactionState(PaynetStatus.SUCCESS.getStatus());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("CheckTransaction. \u0423\u0441\u043f\u0435\u0448\u043d\u043e");
                }
                result.setTransactionStateErrorMsg("Success");
                result.setTransactionStateErrorStatus(0);
                result.setProviderTrnId(transaction.getId());
                result.setTimeStamp(this.getTimestamp(new Date()));
                result.setStatus(PaynetErrorCode.SUCCESS.getErrorCode());
                result.setErrorMsg(PaynetErrorCode.SUCCESS.getErrorMsg());
            }
            catch (Exception e) {
                throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, e.getMessage(), e);
            }
        }
        catch (PaynetException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            result.setStatus(e.getErrorCode().getErrorCode());
            result.setErrorMsg(e.getMessage());
            result.setTimeStamp(this.getTimestamp(new Date()));
        }
        return result;
    }

    @Override
    public CancelTransactionResult cancelTransaction(CancelTransactionArguments arguments) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041e\u0442\u043c\u0435\u043d\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043c\u0435\u0442\u043e\u0434\u0430 CancelTransaction");
        }
        CancelTransactionResult result = new CancelTransactionResult();
        try {
            this.authorize(arguments);
            long transactionId = arguments.getTransactionId();
            XMLGregorianCalendar trTime = arguments.getTransactionTime();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0445\u043e\u0434\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: transactionId = " + transactionId + "; transactionTime = " + String.valueOf(trTime));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432");
            }
            if (transactionId <= 0L || trTime == null) {
                throw new PaynetException(PaynetErrorCode.REQUIRED_PARAMETER_NOT_SPECIFIED);
            }
            GregorianCalendar transactionTime = trTime.toGregorianCalendar();
            String mpsId = this.getMpsId();
            MPSTransactionManager transactionManager = MPSTransactionManager.getInstance(mpsId, this.getSetup(), this.moduleId);
            Transaction transaction = null;
            try {
                transaction = transactionManager.getTransactionByTransId(this.getConnection(), this.moduleId, mpsId, transactionId, transactionTime.getTime());
                if (transaction == null) {
                    throw new PaynetException(PaynetErrorCode.ORDER_IS_NOT_EXIST, "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0440\u0430\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + transactionId);
                }
            }
            catch (Exception e) {
                throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, e.getMessage(), e);
            }
            if (!transaction.getStatus().equals(TransactionStatus.PAYMENT_CANCELED.getCode())) {
                try {
                    transactionManager.cancelTransaction(this.getConnection(), this.moduleId, mpsId, this.system, transaction);
                }
                catch (Exception e) {
                    throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, e.getMessage(), e);
                }
            } else {
                throw new PaynetException(PaynetErrorCode.TRANSACTION_ALREADY_CANCELLED);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("CancelTransaction. \u0423\u0441\u043f\u0435\u0448\u043d\u043e");
            }
            result.setTransactionState(PaynetStatus.CANCEL.getStatus());
            result.setStatus(PaynetErrorCode.SUCCESS.getErrorCode());
            result.setErrorMsg(PaynetErrorCode.SUCCESS.getErrorMsg());
            result.setTimeStamp(this.getTimestamp(new Date()));
        }
        catch (PaynetException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            result.setStatus(e.getErrorCode().getErrorCode());
            result.setErrorMsg(e.getMessage());
            result.setTimeStamp(this.getTimestamp(new Date()));
        }
        return result;
    }

    @Override
    public GetStatementResult getStatement(GetStatementArguments arguments) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0421\u0432\u0435\u0440\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043c\u0435\u0442\u043e\u0434\u0430 GetStatement");
        }
        GetStatementResult result = new GetStatementResult();
        try {
            this.authorize(arguments);
            XMLGregorianCalendar xmlFrom = arguments.getDateFrom();
            XMLGregorianCalendar xmlTo = arguments.getDateTo();
            int ptId = (int)arguments.getServiceId();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0445\u043e\u0434\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: serviceId = " + ptId + "; dateFrom = " + String.valueOf(xmlFrom) + "; xmlto = " + String.valueOf(xmlTo));
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432");
            }
            if (ptId <= 0 || xmlFrom == null || xmlTo == null) {
                throw new PaynetException(PaynetErrorCode.REQUIRED_PARAMETER_NOT_SPECIFIED);
            }
            String mpsId = this.getMpsId();
            MPSTransactionManager transactionManager = MPSTransactionManager.getInstance(mpsId, this.getSetup(), this.moduleId);
            try {
                GregorianCalendar from = xmlFrom.toGregorianCalendar();
                GregorianCalendar to = xmlTo.toGregorianCalendar();
                List<Transaction> transactionList = transactionManager.getTransactionList(this.getConnection(), this.moduleId, mpsId, from, (Calendar)to, ptId, TransactionStatus.PAYMENT_PAYED.getCode());
                for (Transaction transaction : transactionList) {
                    TransactionStatement statement = new TransactionStatement();
                    statement.setAmount(transaction.getSum().multiply(new BigDecimal(100)).longValue());
                    statement.setProviderTrnId(transaction.getId());
                    statement.setTransactionId(Long.valueOf(transaction.getTransId()));
                    statement.setTransactionTime(this.getTimestamp(transaction.getTime()));
                    result.getStatements().add(statement);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("GetStatement. \u0423\u0441\u043f\u0435\u0448\u043d\u043e");
                }
                result.setStatus(PaynetErrorCode.SUCCESS.getErrorCode());
                result.setErrorMsg(PaynetErrorCode.SUCCESS.getErrorMsg());
                result.setTimeStamp(this.getTimestamp(new Date()));
            }
            catch (BGException ex) {
                throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, ex.getMessage(), ex);
            }
        }
        catch (PaynetException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            result.setStatus(e.getErrorCode().getErrorCode());
            result.setErrorMsg(e.getMessage());
            result.setTimeStamp(this.getTimestamp(new Date()));
        }
        return result;
    }

    @Override
    public GetInformationResult getInformation(GetInformationArguments arguments) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043c\u0435\u0442\u043e\u0434\u0430 GetInformation");
        }
        GetInformationResult result = new GetInformationResult();
        try {
            this.authorize(arguments);
            int contractId = this.getContractId(arguments.getParameters());
            String className = this.moduleSetup.get("mps." + this.getMpsId() + ".getInformation.class", null);
            if (Utils.notBlankString((String)className)) {
                try {
                    ResponceParameters responceParameters = (ResponceParameters)DynamicClassManager.getInstance().newProxyInstance(ResponceParameters.class, className);
                    Map<String, String> params = responceParameters.getResponceParameters(this.getConnection(), this.getSetup(), contractId);
                    for (Map.Entry<String, String> param : params.entrySet()) {
                        GenericParam genericParam = new GenericParam();
                        genericParam.setParamKey(param.getKey());
                        genericParam.setParamValue(param.getValue());
                        result.getParameters().add(genericParam);
                    }
                }
                catch (BGException e) {
                    throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, e.getMessage(), e);
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("GetInformation. \u0423\u0441\u043f\u0435\u0448\u043d\u043e");
            }
            result.setTimeStamp(this.getTimestamp(new Date()));
            result.setStatus(PaynetErrorCode.SUCCESS.getErrorCode());
            result.setErrorMsg(PaynetErrorCode.SUCCESS.getErrorMsg());
        }
        catch (PaynetException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            result.setStatus(e.getErrorCode().getErrorCode());
            result.setErrorMsg(e.getMessage());
            result.setTimeStamp(this.getTimestamp(new Date()));
        }
        return result;
    }

    @Override
    public ChangePasswordResult changePassword(ChangePasswordArguments arguments) {
        ChangePasswordResult result = new ChangePasswordResult();
        result.setStatus(PaynetErrorCode.SYSTEM_ERROR.getErrorCode());
        result.setErrorMsg("\u0421\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f!");
        result.setTimeStamp(this.getTimestamp(new Date()));
        return result;
    }

    private void authorize(GenericArguments arguments) throws PaynetException {
        String requestUsername = arguments.getUsername();
        String requestPassword = arguments.getPassword();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f. \u041f\u0440\u0438\u0448\u0435\u0434\u0448\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: username = " + requestUsername + "; password = *******");
        }
        String mpsId = this.getMpsId();
        String systemLogin = this.moduleSetup.get("mps." + mpsId + ".login", "");
        String systemPassword = this.moduleSetup.get("mps." + mpsId + ".login", "");
        if (!requestUsername.equals(systemLogin) && !requestPassword.equals(systemPassword)) {
            throw new PaynetException(PaynetErrorCode.ACCESS_DENIED);
        }
    }

    private int getContractId(List<GenericParam> parameters) throws PaynetException {
        Contract contract;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u0434\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430. ");
        }
        String contractTitle = this.getClientId(parameters);
        int contractId = FindContractUtils.findContractByTitle(this.getConnection(), contractTitle);
        if (contractId <= 0) {
            throw new PaynetException(PaynetErrorCode.CLIENT_IS_NOT_FOUND);
        }
        boolean deny4Jur = this.moduleSetup.getBoolean("mps." + this.getMpsId() + ".deny.jur", false);
        if (deny4Jur && (contract = new ContractManager(this.getConnection()).getContractById(contractId)).getFc() == 1) {
            throw new PaynetException(PaynetErrorCode.DENIED_FOR_JURIDICAL);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\t\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 " + contractId);
        }
        return contractId;
    }

    private String getClientId(List<GenericParam> parameters) throws PaynetException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 clientId \u0438\u0437 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430.");
        }
        String contractTitle = "";
        for (GenericParam genericParam : parameters) {
            if (!genericParam.getParamKey().equals("clientId")) continue;
            contractTitle = genericParam.getParamValue();
        }
        if (Utils.isBlankString((String)contractTitle)) {
            throw new PaynetException(PaynetErrorCode.REQUIRED_PARAMETER_NOT_SPECIFIED, "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 clientId!");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\t\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 " + contractTitle);
        }
        return contractTitle;
    }

    private String getMpsId() throws PaynetException {
        String pathInfo = (String)this.wsc.getMessageContext().get((Object)"jakarta.xml.ws.http.request.pathinfo");
        String[] pathParams = pathInfo.split("/");
        String mpsId = pathParams[pathParams.length - 1];
        if (mpsId == null) {
            throw new PaynetException(PaynetErrorCode.SYSTEM_ERROR, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 mpsId \u0438\u0437 url!");
        }
        return mpsId;
    }

    private XMLGregorianCalendar getTimestamp(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        XMLGregorianCalendar result = null;
        try {
            result = DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
        }
        catch (DatatypeConfigurationException e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private class PaynetException
    extends Exception {
        private PaynetErrorCode errorCode;

        public PaynetException(PaynetErrorCode error) {
            this(error, error.getErrorMsg());
        }

        public PaynetException(PaynetErrorCode error, String msg) {
            super(msg);
            this.errorCode = error;
        }

        public PaynetException(PaynetErrorCode error, String msg, Throwable cause) {
            super(msg, cause);
            this.errorCode = error;
        }

        public PaynetErrorCode getErrorCode() {
            return this.errorCode;
        }
    }
}

