/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.robokassa.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.robokassa.common.bean.Transaction;
import ru.bitel.bgbilling.modules.robokassa.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.robokassa.server.bean.Constants;
import ru.bitel.bgbilling.modules.robokassa.server.bean.TransactionManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Robokassa")
public class ActionDoTransaction
extends AbstractPaymentAction {
    private static final String PARAM_SIGNATURE_VALUE = "SignatureValue";
    private static final String PARAM_DESC = "Desc";
    private static final String PARAM_INV_ID = "InvId";
    private static final String PARAM_OUT_SUM = "OutSum";
    private static final String PARAM_MRCH_LOGIN = "MrchLogin";

    public ActionDoTransaction() {
        super("robokassa");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("robokassa.gate.url", "https://merchant.roboxchange.com/Index.aspx"));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = new SearchParam().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        String[] sort = new String[]{"createDate:1", "transactionDate:1"};
        SearchResult searchResult = new SearchResult(this.getPeriod(), this.getPage(), sort);
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws Exception {
        int transactionId = this.req.getInt(PARAM_INV_ID, 0);
        if (transactionId > 0) {
            new TransactionManager(this.con, this.moduleId).doCheckRequest(transactionId);
        }
        this.execute();
    }

    public void fail() throws Exception {
        int transactionId = this.req.getInt(PARAM_INV_ID, 0);
        if (transactionId > 0) {
            new TransactionManager(this.con, this.moduleId).doCheckRequest(transactionId);
        }
        this.execute();
    }

    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        String description = this.moduleSetup.get("robokassa.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(this.sum)).setContractId(this.contractId)).setCreateDate(new Date())).build();
        new TransactionManager(this.con, this.moduleId).update(transaction);
        this.setResultParam(PARAM_INV_ID, String.valueOf(transaction.getId()));
        String email = this.customerAddress;
        this.setResultParam("gateUrl", this.moduleSetup.get("robokassa.gate.url", "https://merchant.roboxchange.com/Index.aspx"));
        this.setResultParam("formFields", new String[]{PARAM_MRCH_LOGIN, PARAM_OUT_SUM, PARAM_INV_ID, PARAM_DESC, "Email", "Receipt", PARAM_SIGNATURE_VALUE});
        this.setResultParam(PARAM_MRCH_LOGIN, this.moduleSetup.get("robokassa.merchant.login", ""));
        this.setResultParam(PARAM_OUT_SUM, new DecimalFormat("###########0.00").format(this.sum).replace(",", "."));
        this.setResultParam(PARAM_DESC, description);
        if (Utils.notBlankString((String)email)) {
            this.setResultParam("Email", email);
        }
        TransactionManager.addReceipt((ParameterMap)this.moduleSetup, contract.getTitle(), this.getResult(), this.sum);
        ArrayList<String> signList = new ArrayList<String>();
        signList.add((String)this.getResultParam(PARAM_MRCH_LOGIN));
        signList.add((String)this.getResultParam(PARAM_OUT_SUM));
        signList.add((String)this.getResultParam(PARAM_INV_ID));
        signList.add((String)this.getResultParam("Receipt"));
        signList.add(this.moduleSetup.get("robokassa.merchant.password.1", ""));
        String signData = signList.stream().filter(a -> a != null).collect(Collectors.joining(":"));
        try {
            this.setResultParam(PARAM_SIGNATURE_VALUE, Utils.getDigest((String)signData, (String)"UTF-8"));
        }
        catch (Exception ex) {
            this.getLogger().error("error make signature", (Throwable)ex);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("MrchLogin: " + String.valueOf(this.getResultParam(PARAM_MRCH_LOGIN)));
            this.getLogger().debug("OutSum: " + String.valueOf(this.getResultParam(PARAM_OUT_SUM)));
            this.getLogger().debug("Desc: " + String.valueOf(this.getResultParam(PARAM_DESC)));
            this.getLogger().debug("InvId: " + String.valueOf(this.getResultParam(PARAM_INV_ID)));
            this.getLogger().debug("Receipt: " + String.valueOf(this.getResultParam("Receipt")));
            this.getLogger().debug("SignatureValue: " + String.valueOf(this.getResultParam(PARAM_SIGNATURE_VALUE)));
        }
    }
}

