/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.TransactionUtils;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMode;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.Constants;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.gazprombank.server.event.worker.GazprombankAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.gazprombank.server.event.worker.GazprombankCheckEventWorker;
import ru.bitel.bgbilling.modules.gazprombank.server.service.GazprombankServiceImpl;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    public static final String MODULE_NAME = "gazprombank";
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), GazprombankServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.gazprombank.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(module.getId())).getBoolean("gazprombank.event.worker", true)) {
            new GazprombankCheckEventWorker(Setup.getSetup(), module.getId());
            new GazprombankAutopaymentEventWorker(Setup.getSetup(), module.getId());
        }
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), MODULE_NAME, moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getBoolean("gazprombank.sbp.enable", false)) {
            methods.add(PaymentMethod.SBP);
        }
        methods.add(PaymentMethod.CARD);
        return methods;
    }

    public PaymentMode getPaymentMode() {
        return PaymentMode.REDIRECT;
    }

    public Map<String, Object> getContractAutopaymentData(int moduleId, int contractId, Connection con) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        try {
            AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
            TransactionUtils.setAutopaymentData((int)moduleId, (int)contractId, dataMap, (Connection)con, (String)MODULE_NAME, (AbstractAutopaymentManager)autopaymentManager, Constants.class);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return dataMap;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

